/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.ScriptableObject;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Node;

class TextFormControl
extends FormControl {
    private String[] _value = new String[1];
    private String[] _defaultValue;

    public TextFormControl(Node node, String defaultValue) {
        super(node);
        this._defaultValue = new String[]{defaultValue};
    }

    public String[] getValues() {
        return this._value[0] != null ? this._value : this._defaultValue;
    }

    public boolean isTextControl() {
        return true;
    }

    public ScriptableObject getScriptableObject() {
        return new Scriptable();
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (this.getName().length() > 0) {
            processor.addParameter(this.getName(), this.getValues()[0], characterSet);
        }
    }

    void claimValue(List values) {
        if (this.isReadOnly()) {
            return;
        }
        if (values.isEmpty()) {
            this._value[0] = "";
        } else {
            this._value[0] = (String)values.get(0);
            values.remove(0);
        }
    }

    void reset() {
        this._value[0] = null;
    }

    void claimRequiredValues(List values) {
        if (this.isReadOnly()) {
            this.claimValueIsRequired(values);
        }
    }

    protected void claimValueIsRequired(List values) {
        this.claimValueIsRequired(values, this._defaultValue[0]);
    }

    class Scriptable
    extends FormControl.Scriptable {
        Scriptable() {
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("value")) {
                String string = value.toString();
                ((TextFormControl)TextFormControl.this)._defaultValue[0] = string;
                ((TextFormControl)TextFormControl.this)._value[0] = string;
            } else {
                super.set(propertyName, value);
            }
        }
    }
}

