package monalipse.perspectives;

import monalipse.views.BoardListView;
import monalipse.views.ResponseWriterView;
import monalipse.views.ThreadListView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class MonalipsePerspective implements IPerspectiveFactory
{
	public void createInitialLayout(IPageLayout layout)
	{
		defineActions(layout);
		defineLayout(layout);
	}

	public void defineActions(IPageLayout layout)
	{
		// Add "new wizards".
//		layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder"); //$NON-NLS-1$
//		layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file"); //$NON-NLS-1$
	
		// Add "show views".
//		layout.addShowViewShortcut(IPageLayout.ID_RES_NAV);
//		layout.addShowViewShortcut(IPageLayout.ID_BOOKMARKS);
//		layout.addShowViewShortcut(IPageLayout.ID_OUTLINE);
//		layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);
//		layout.addShowViewShortcut(IPageLayout.ID_TASK_LIST);
	}

	public void defineLayout(IPageLayout layout)
	{
		// Editors are placed for free.
		String editorArea = layout.getEditorArea();
	
		// Top left.
		IFolderLayout topLeft = layout.createFolder("topLeft", IPageLayout.LEFT, (float) 0.20, editorArea); //$NON-NLS-1$
		topLeft.addView(BoardListView.ID_BOARD_LIST);
//		topLeft.addPlaceholder(IPageLayout.ID_BOOKMARKS);
	
		// Bottom right.
		IFolderLayout bottomRight = layout.createFolder("bottomRight", IPageLayout.BOTTOM, (float) 0.70, editorArea); //$NON-NLS-1$
		bottomRight.addView(ThreadListView.ID_THREAD_LIST);
		bottomRight.addView(ResponseWriterView.ID_RESPONSE_WRITER);
	}
}
