package monalipse.preferences.giko;

import java.net.MalformedURLException;
import java.net.URL;

import monalipse.MonalipsePlugin;
import monalipse.server.giko.GikoServer;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchMessages;

public class GikoPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage
{
	public GikoPreferencePage()
	{
		super(GRID);
		setPreferenceStore(MonalipsePlugin.getDefault().getPreferenceStore());
		setDescription("2ch Preferences");
		initializeDefaults();
	}

	private void initializeDefaults()
	{
		IPreferenceStore store = getPreferenceStore();
		store.setDefault(GikoServer.PREF_BBSMENU_URL, GikoServer.DEFAULT_BBSMENU_URL);
		store.setDefault(GikoServer.PREF_OYSTER_ID, GikoServer.DEFAULT_OYSTER_ID);
		store.setDefault(GikoServer.PREF_OYSTER_PASSWORD, GikoServer.DEFAULT_OYSTER_PASSWORD);
	}

	public void createFieldEditors()
	{
		addField(new StringFieldEditor(GikoServer.PREF_BBSMENU_URL, WorkbenchMessages.getString("Preference.bbsmenuLabel"), getFieldEditorParent())
			{
				public boolean isValid()
				{
					try
					{
						new URL(getStringValue());
						GikoPreferencePage.this.setErrorMessage(null);
						return true;
					}
					catch (MalformedURLException e)
					{
						GikoPreferencePage.this.setErrorMessage(WorkbenchMessages.getString("Preference.invalidURL"));
						return false;
					}
				}
			});
		addField(new StringFieldEditor(GikoServer.PREF_OYSTER_ID, WorkbenchMessages.getString("Preference.oysterIDLabel"), getFieldEditorParent()));
		addField(new StringFieldEditor(GikoServer.PREF_OYSTER_PASSWORD, WorkbenchMessages.getString("Preference.oysterIDPassword"), getFieldEditorParent()));
	}

	public void init(IWorkbench workbench)
	{
	}
	
	public void propertyChange(PropertyChangeEvent event)
	{
		super.propertyChange(event);
		checkState();
	}
}