package monalipse.server;

import monalipse.part.CancelableRunner;
import monalipse.widgets.ColoredText;
import monalipse.widgets.ColoredText.TextSelection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public interface IThreadContentProvider
{
	public String getBaseURL();
	public String getURLHint();
	public IFolder getLogFolder();
	public IFile getLogFile();
	public String getID();
	public String getName();
	public IResponseEnumeration getResponses(int sequence, int rangeStart, RendererResource rendererResource);
	public IResponseEnumeration updateResponses(CancelableRunner cancelable, int sequence, int rangeStart, RendererResource rendererResource);
	public boolean submitResponse(CancelableRunner cancelable, String name, String mail, String body);
	public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, String selection);
}
