package monalipse.server.giko;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IAdaptable;

class Category implements IAdaptable
{
	private Category category;
	private String name;
	private List children = new ArrayList();

	public Category(Category category, String name)
	{
		this.category = category;
		this.name = name;
	}
	
	public Category getCategory()
	{
		return category;
	}
	
	public String getName()
	{
		return name;
	}
	
	public void addChild(Object child)
	{
		children.add(child);
	}
	
	public Object[] getChildren()
	{
		return children.toArray();
	}
	
	public Object getChild(String name)
	{
		for(int i = 0; i < children.size(); i++)
		{
			Object e = children.get(i);
			if(e instanceof Board && ((Board)e).getName().equals(name))
				return e;
			else if(e instanceof Category && ((Category)e).getName().equals(name))
				return e;
		}
		return null;
	}

	public boolean hasChildren()
	{
		return !children.isEmpty();
	}

	public Object getAdapter(Class adapter)
	{
		return null;
	}

}
