/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.CheckboxFormControl;
import com.meterware.httpunit.FileSubmitFormControl;
import com.meterware.httpunit.HiddenFieldFormControl;
import com.meterware.httpunit.MissingParameterValueException;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.RadioButtonFormControl;
import com.meterware.httpunit.ScriptableObject;
import com.meterware.httpunit.SelectionFormControl;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.TextAreaFormControl;
import com.meterware.httpunit.TextFieldFormControl;
import com.meterware.httpunit.WebForm;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Node;

abstract class FormControl {
    static final String[] NO_VALUE = new String[0];
    private String _name;
    private final String _valueAttribute;
    private final boolean _readOnly;
    private final boolean _disabled;

    FormControl() {
        this._name = "";
        this._valueAttribute = "";
        this._readOnly = false;
        this._disabled = false;
    }

    FormControl(Node node) {
        this._name = NodeUtils.getNodeAttribute(node, "name");
        this._valueAttribute = NodeUtils.getNodeAttribute(node, "value");
        this._readOnly = NodeUtils.isNodeAttributePresent(node, "readonly");
        this._disabled = NodeUtils.isNodeAttributePresent(node, "disabled");
    }

    public String getName() {
        return this._name;
    }

    public abstract String[] getValues();

    public ScriptableObject getScriptableObject() {
        return new Scriptable();
    }

    public String[] getOptionValues() {
        return NO_VALUE;
    }

    public String[] getDisplayedOptions() {
        return NO_VALUE;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public boolean isTextControl() {
        return false;
    }

    public boolean isExclusive() {
        return false;
    }

    public boolean isMultiValued() {
        return false;
    }

    public boolean isFileParameter() {
        return false;
    }

    abstract void addValues(ParameterProcessor var1, String var2) throws IOException;

    void claimRequiredValues(List values) {
    }

    void claimValue(List values) {
    }

    void claimUniqueValue(List values) {
    }

    void claimUploadSpecification(List files) {
    }

    void reset() {
    }

    protected String getValueAttribute() {
        return this._valueAttribute;
    }

    protected final void claimValueIsRequired(List values, String value) {
        if (!values.contains(value)) {
            throw new MissingParameterValueException(this.getName(), value, values.toArray(new String[values.size()]));
        }
        values.remove(value);
    }

    static FormControl newFormParameter(WebForm form, Node node) {
        if (node.getNodeType() != 1) {
            return null;
        }
        if (node.getNodeName().equals("textarea")) {
            return new TextAreaFormControl(node);
        }
        if (node.getNodeName().equals("select")) {
            return new SelectionFormControl(node);
        }
        if (node.getNodeName().equals("button")) {
            String type = NodeUtils.getNodeAttribute(node, "type", "submit");
            if (type.equalsIgnoreCase("submit")) {
                return new SubmitButton(form, node);
            }
            return null;
        }
        if (!node.getNodeName().equals("input")) {
            return null;
        }
        String type = NodeUtils.getNodeAttribute(node, "type", "text");
        if (type.equalsIgnoreCase("text") || type.equalsIgnoreCase("password")) {
            return new TextFieldFormControl(node);
        }
        if (type.equalsIgnoreCase("hidden")) {
            return new HiddenFieldFormControl(node);
        }
        if (type.equalsIgnoreCase("radio")) {
            return new RadioButtonFormControl(node);
        }
        if (type.equalsIgnoreCase("checkbox")) {
            return new CheckboxFormControl(node);
        }
        if (type.equalsIgnoreCase("submit") || type.equalsIgnoreCase("image")) {
            return new SubmitButton(form, node);
        }
        if (type.equalsIgnoreCase("file")) {
            return new FileSubmitFormControl(node);
        }
        return null;
    }

    class Scriptable
    implements ScriptableObject {
        Scriptable() {
        }

        public Object get(String propertyName) {
            throw new RuntimeException("Unknown property: " + propertyName);
        }

        public void set(String propertyName, Object value) {
            throw new RuntimeException("Unknown property: " + propertyName);
        }
    }
}

