/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.RadioButtonFormControl;
import com.meterware.httpunit.RadioGroupFormControl;
import com.meterware.httpunit.ScriptableObject;
import com.meterware.httpunit.UnusedParameterValueException;
import com.meterware.httpunit.UnusedUploadFileException;
import com.meterware.httpunit.UploadFileSpec;
import java.util.ArrayList;
import java.util.Arrays;

class FormParameter {
    private FormControl[] _controls;
    private ArrayList _controlList = new ArrayList();
    private RadioGroupFormControl _group;
    private String _name;

    FormParameter() {
    }

    void addControl(FormControl control) {
        this._controls = null;
        if (this._name == null) {
            this._name = control.getName();
        }
        if (!this._name.equalsIgnoreCase(control.getName())) {
            throw new RuntimeException("all controls should have the same name");
        }
        if (control.isExclusive()) {
            this.getRadioGroup().addRadioButton((RadioButtonFormControl)control);
        } else {
            this._controlList.add(control);
        }
    }

    private FormControl[] getControls() {
        if (this._controls == null) {
            this._controls = this._controlList.toArray(new FormControl[this._controlList.size()]);
        }
        return this._controls;
    }

    ScriptableObject getScriptableObject() {
        return this.getControls()[0].getScriptableObject();
    }

    String[] getValues() {
        ArrayList<String> valueList = new ArrayList<String>();
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            valueList.addAll(Arrays.asList(controls[i].getValues()));
            ++i;
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    void setValues(String[] values) {
        ArrayList<String> list = new ArrayList<String>(values.length);
        list.addAll(Arrays.asList(values));
        int i = 0;
        while (i < this.getControls().length) {
            this.getControls()[i].claimRequiredValues(list);
            ++i;
        }
        i = 0;
        while (i < this.getControls().length) {
            this.getControls()[i].claimUniqueValue(list);
            ++i;
        }
        i = 0;
        while (i < this.getControls().length) {
            this.getControls()[i].claimValue(list);
            ++i;
        }
        if (!list.isEmpty()) {
            throw new UnusedParameterValueException(this._name, (String)list.get(0));
        }
    }

    void setFiles(UploadFileSpec[] fileArray) {
        ArrayList<UploadFileSpec> list = new ArrayList<UploadFileSpec>(fileArray.length);
        list.addAll(Arrays.asList(fileArray));
        int i = 0;
        while (i < this.getControls().length) {
            this.getControls()[i].claimUploadSpecification(list);
            ++i;
        }
        if (!list.isEmpty()) {
            throw new UnusedUploadFileException(this._name, fileArray.length - list.size(), fileArray.length);
        }
    }

    String[] getOptions() {
        ArrayList<String> optionList = new ArrayList<String>();
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            optionList.addAll(Arrays.asList(controls[i].getDisplayedOptions()));
            ++i;
        }
        return optionList.toArray(new String[optionList.size()]);
    }

    String[] getOptionValues() {
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < this.getControls().length) {
            valueList.addAll(Arrays.asList(this.getControls()[i].getOptionValues()));
            ++i;
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    boolean isMultiValuedParameter() {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (controls[i].isMultiValued()) {
                return true;
            }
            if (!controls[i].isExclusive() && controls.length > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int getNumTextParameters() {
        int result = 0;
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (controls[i].isTextControl()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    boolean isTextParameter() {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (controls[i].isTextControl()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isFileParameter() {
        FormControl[] controls = this.getControls();
        int i = 0;
        while (i < controls.length) {
            if (controls[i].isFileParameter()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private RadioGroupFormControl getRadioGroup() {
        if (this._group == null) {
            this._group = new RadioGroupFormControl();
            this._controlList.add(this._group);
        }
        return this._group;
    }
}

