/*
 * Decompiled with CFR 0.152.
 */
package monalipse.bookmark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import monalipse.MonalipsePlugin;
import monalipse.bookmark.IBookmarkTreeNode;
import monalipse.server.BBSServerManager;
import monalipse.server.IThreadContentProvider;
import monalipse.views.IBBSReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.PluginTransferData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BookmarkManager {
    private static Transformer transformer;
    private static IBookmarkTreeNode bookmark;
    private static long timestamp;
    static /* synthetic */ Class class$0;

    public static IBookmarkTreeNode getBookmarks() {
        IProject project = MonalipsePlugin.getProject();
        if (project == null) {
            return new NullBookmarkTreeNode();
        }
        IFile file = project.getFile("bookmarks.xml");
        try {
            MonalipsePlugin.ensureSynchronized(file);
        }
        catch (CoreException coreException) {}
        if (file.exists() && timestamp != file.getModificationStamp()) {
            bookmark = null;
            timestamp = file.getModificationStamp();
        }
        if (bookmark != null) {
            return bookmark;
        }
        try {
            if (file.exists()) {
                DOMResult dom = new DOMResult();
                BookmarkManager.getTransformer().transform(new StreamSource(file.getContents()), dom);
                bookmark = XMLBookmarkTreeNode.of(((Document)dom.getNode()).getDocumentElement());
                if (bookmark != null) {
                    return bookmark;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("folder");
            root.setAttribute("name", "<root>");
            doc.appendChild(root);
            bookmark = XMLBookmarkTreeNode.of(root);
            if (bookmark != null) {
                return bookmark;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        bookmark = new NullBookmarkTreeNode();
        return bookmark;
    }

    public static void setBookmarks(IWorkbenchWindow workbenchWindow, IBookmarkTreeNode bookmark) {
        if (!(bookmark instanceof XMLBookmarkTreeNode)) {
            return;
        }
        final IProject project = MonalipsePlugin.getProject();
        if (project == null) {
            return;
        }
        BookmarkManager.bookmark = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BookmarkManager.getTransformer().transform(new DOMSource(((XMLBookmarkTreeNode)bookmark).getDocument()), new StreamResult(bout));
            bout.close();
            final byte[] bytes = bout.toByteArray();
            MonalipsePlugin.asyncExec(workbenchWindow, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        IFile file = project.getFile("bookmarks.xml");
                        MonalipsePlugin.ensureSynchronized(file);
                        if (file.exists()) {
                            file.setContents((InputStream)new ByteArrayInputStream(bytes), false, true, monitor);
                        } else {
                            file.create((InputStream)new ByteArrayInputStream(bytes), false, monitor);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static IBookmarkTreeNode[] getBookmarks(PluginTransferData data) {
        String string = data.getExtensionId();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.bookmark.IBookmarkTreeNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!string.equals(clazz.getName())) {
            return null;
        }
        try {
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(data.getData()));
            IBookmarkTreeNode[] nodes = new IBookmarkTreeNode[din.readInt()];
            IBookmarkTreeNode root = BookmarkManager.getBookmarks();
            int i = 0;
            while (i < nodes.length) {
                int pos;
                IBookmarkTreeNode select = root;
                while ((pos = din.readInt()) != -1) {
                    IBookmarkTreeNode[] ch = select.getChildren();
                    if (pos >= 0 && pos < ch.length) {
                        select = ch[pos];
                        continue;
                    }
                    return null;
                }
                nodes[i] = select;
                ++i;
            }
            return nodes;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static PluginTransferData getTransferData(IBookmarkTreeNode[] nodes) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            dout.writeInt(nodes.length);
            int i = 0;
            while (i < nodes.length) {
                if (!BookmarkManager.writeIndexes(dout, nodes[i])) {
                    return null;
                }
                dout.writeInt(-1);
                ++i;
            }
            dout.close();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.bookmark.IBookmarkTreeNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return new PluginTransferData(clazz.getName(), bout.toByteArray());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static boolean writeIndexes(DataOutputStream dout, IBookmarkTreeNode node) throws IOException {
        if (node.getParent() != null) {
            if (BookmarkManager.writeIndexes(dout, node.getParent())) {
                IBookmarkTreeNode[] nodes = node.getParent().getChildren();
                int i = 0;
                while (i < nodes.length) {
                    if (nodes[i] == node) {
                        dout.writeInt(i);
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean bookmarkChanged(IResourceChangeEvent event) {
        IProject project = MonalipsePlugin.getProject();
        if (project == null) {
            return false;
        }
        return MonalipsePlugin.resourceModified(7, event.getDelta(), (IResource)project.getFile("bookmarks.xml"));
    }

    private static Transformer getTransformer() throws TransformerException {
        if (transformer == null) {
            TransformerFactory tf = TransformerFactory.newInstance();
            transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", ResourcesPlugin.getEncoding());
        }
        return transformer;
    }

    private static class XMLBookmarkTreeLeaf
    extends XMLBookmarkTreeNode
    implements IBBSReference {
        XMLBookmarkTreeLeaf(Element element, String name, URL url) {
            super(element, name, url);
        }

        public boolean hasNewResponses() {
            IThreadContentProvider thread = BBSServerManager.getThreadContentProviderOf(this.getURL());
            return thread != null && thread.hasNewResponses();
        }
    }

    private static class XMLBookmarkTreeNode
    implements IBookmarkTreeNode {
        private Element element;
        private XMLBookmarkTreeNode parent;
        private String name;
        private boolean folder;
        private List children;
        private URL url;

        XMLBookmarkTreeNode(Element element, String name, List children) {
            this.element = element;
            this.name = name;
            this.children = new ArrayList(children);
            this.folder = true;
            int i = 0;
            while (i < children.size()) {
                ((XMLBookmarkTreeNode)children.get((int)i)).parent = this;
                ++i;
            }
        }

        XMLBookmarkTreeNode(Element element, String name, URL url) {
            this.element = element;
            this.name = name;
            this.url = url;
            this.folder = false;
        }

        public static XMLBookmarkTreeNode of(Element element) {
            if (element.getTagName().equals("folder") && element.getAttribute("name") != null) {
                NodeList nodes = element.getChildNodes();
                ArrayList<XMLBookmarkTreeNode> list = new ArrayList<XMLBookmarkTreeNode>();
                ArrayList<Node> removal = new ArrayList<Node>();
                int i = 0;
                while (i < nodes.getLength()) {
                    if (nodes.item(i) instanceof Element) {
                        XMLBookmarkTreeNode node = XMLBookmarkTreeNode.of((Element)nodes.item(i));
                        if (node != null) {
                            list.add(node);
                        }
                    } else if (nodes.item(i) instanceof Text) {
                        removal.add(nodes.item(i));
                    }
                    ++i;
                }
                i = 0;
                while (i < removal.size()) {
                    element.removeChild((Node)removal.get(i));
                    ++i;
                }
                return new XMLBookmarkTreeNode(element, element.getAttribute("name"), list);
            }
            if (element.getTagName().equals("link") && element.getAttribute("name") != null && element.getAttribute("href") != null) {
                try {
                    return new XMLBookmarkTreeLeaf(element, element.getAttribute("name"), new URL(element.getAttribute("href")));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        private Document getDocument() {
            return this.element.getOwnerDocument();
        }

        public IBookmarkTreeNode[] getChildren() {
            if (this.children == null) {
                return new IBookmarkTreeNode[0];
            }
            IBookmarkTreeNode[] nodes = new IBookmarkTreeNode[this.children.size()];
            this.children.toArray(nodes);
            return nodes;
        }

        public String getName() {
            return this.name;
        }

        public IBookmarkTreeNode getParent() {
            return this.parent;
        }

        public IBookmarkTreeNode getRoot() {
            XMLBookmarkTreeNode root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            return root;
        }

        public boolean hasChildren() {
            return this.folder;
        }

        public URL getURL() {
            return this.url;
        }

        public IBookmarkTreeNode createFolder(String name) {
            Element item = this.element.getOwnerDocument().createElement("folder");
            item.setAttribute("name", name);
            return this.insertItem(new XMLBookmarkTreeNode(item, name, new ArrayList()));
        }

        public IBookmarkTreeNode createLink(String name, URL href) {
            Element item = this.element.getOwnerDocument().createElement("link");
            item.setAttribute("name", name);
            item.setAttribute("href", href.toExternalForm());
            return this.insertItem(new XMLBookmarkTreeNode(item, name, href));
        }

        private IBookmarkTreeNode insertItem(XMLBookmarkTreeNode item) {
            if (this.folder) {
                this.element.appendChild(item.element);
                this.children.add(item);
            } else {
                this.element.getParentNode().insertBefore(item.element, this.element);
                this.parent.children.add(this.parent.children.indexOf(this), item);
            }
            return item;
        }

        public void setName(String name) {
            this.name = name;
            this.element.setAttribute("name", name);
        }

        public void remove() {
            this.element.getParentNode().removeChild(this.element);
            this.parent.children.remove(this);
        }

        public IBookmarkTreeNode findItem(URL url) {
            if (this.folder) {
                int i = 0;
                while (i < this.children.size()) {
                    IBookmarkTreeNode item = ((IBookmarkTreeNode)this.children.get(i)).findItem(url);
                    if (item != null) {
                        return item;
                    }
                    ++i;
                }
            } else if (this.url.equals(url)) {
                return this;
            }
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean isAncestorOf(IBookmarkTreeNode node) {
            while (node != null) {
                if (node == this) {
                    return true;
                }
                node = node.getParent();
            }
            return false;
        }

        public boolean hasNewResponses() {
            if (this.children != null) {
                int i = 0;
                while (i < this.children.size()) {
                    if (((IBookmarkTreeNode)this.children.get(i)).hasNewResponses()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    private static class NullBookmarkTreeNode
    implements IBookmarkTreeNode {
        NullBookmarkTreeNode() {
        }

        public IBookmarkTreeNode[] getChildren() {
            return new IBookmarkTreeNode[0];
        }

        public void setName(String name) {
        }

        public String getName() {
            return "";
        }

        public IBookmarkTreeNode getParent() {
            return null;
        }

        public IBookmarkTreeNode getRoot() {
            return null;
        }

        public boolean hasChildren() {
            return false;
        }

        public IBookmarkTreeNode createFolder(String name) {
            return null;
        }

        public IBookmarkTreeNode createLink(String name, URL href) {
            return null;
        }

        public void remove() {
        }

        public IBookmarkTreeNode findItem(URL url) {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean isAncestorOf(IBookmarkTreeNode node) {
            return false;
        }

        public boolean hasNewResponses() {
            return false;
        }
    }
}

