/*
 * Decompiled with CFR 0.152.
 */
package monalipse.editors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import monalipse.MonalipsePlugin;
import monalipse.editors.ThreadEditorInput;
import monalipse.editors.ThreadViewerEditorActionBarContributor;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.ILinkedLineFragment;
import monalipse.server.INewResponseLineFragment;
import monalipse.server.IResponseEnumeration;
import monalipse.server.IResponseHeaderLine;
import monalipse.server.IThreadContentProvider;
import monalipse.utils.CancelableRunner;
import monalipse.widgets.ColoredText;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ThreadViewerEditor
extends EditorPart
implements ColoredText.ToolTipProvider,
ColoredText.LinkProvider,
IFindReplaceTarget {
    private static final Logger logger;
    private ThreadEditorInput input;
    private IThreadContentProvider content;
    private Display display;
    private ColoredText text;
    private int sequence;
    private int responseCount;
    private boolean writable;
    private boolean toolTipActive;
    private LinkSelectionProvider linkSelectionProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = MonalipsePlugin.getLogger(clazz);
    }

    public void updateThread(final int scrollTo) {
        CancelableRunner cancelable = ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).getCancelable();
        cancelable.run(this, new CancelableRunner.ICancelableRunnableWithProgress(){

            public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                ThreadViewerEditor.this.updateThread(monitor, true, scrollTo);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateThread(CancelableRunner.ICancelableProgressMonitor monitor, final boolean download, int scroll) {
        block23: {
            block21: {
                block20: {
                    monitor.beginTask("getting thread...", 130);
                    try {
                        IThreadContentProvider thread = this.getContentProvider();
                        if (thread == null) {
                            Object var18_5 = null;
                            break block20;
                        }
                        this.display.syncExec(new Runnable(){

                            public void run() {
                                ThreadViewerEditor.this.setTitleImage(MonalipsePlugin.getDefault().getLabelImageOf(ThreadViewerEditor.this.getContentProvider()));
                                int i = 0;
                                while (i < ThreadViewerEditor.this.text.getLineCount()) {
                                    ThreadViewerEditor.this.unmarkNewResponse(ThreadViewerEditor.this.text.getLineAt(i));
                                    ++i;
                                }
                                ThreadViewerEditor.this.text.redraw();
                            }
                        });
                        monitor.worked(10);
                        IResponseEnumeration e = download ? thread.updateResponses(monitor.getRunner().getSubProgressMonitor(monitor, 100), this.getSite().getWorkbenchWindow(), this.sequence, this.responseCount) : thread.getResponses(monitor.getRunner().getSubProgressMonitor(monitor, 100), this.sequence, this.responseCount);
                        this.writable = e.isWritable();
                        monitor.worked(10);
                        if (e == null) {
                            break block21;
                        }
                        try {
                            if (!e.isPartialContent()) {
                                this.responseCount = 0;
                                this.display.syncExec(new Runnable(){

                                    public void run() {
                                        ThreadViewerEditor.this.text.clear();
                                    }
                                });
                            }
                            monitor.worked(10);
                            final ColoredText.TextPosition[] latestResponseLocation = new ColoredText.TextPosition[1];
                            final ColoredText.TextPosition[] scrollTo = new ColoredText.TextPosition[1];
                            if (download) {
                                this.display.syncExec(new Runnable(){

                                    public void run() {
                                        if (ThreadViewerEditor.this.responseCount != 0 && ThreadViewerEditor.this.saveScrollPosition() == ThreadViewerEditor.this.responseCount) {
                                            int i = 0;
                                            while (i < ThreadViewerEditor.this.text.getLineCount()) {
                                                ColoredText.Line line = ThreadViewerEditor.this.text.getLineAt(i);
                                                if (line instanceof IResponseHeaderLine && ((IResponseHeaderLine)((Object)line)).getReponseNumber() == ThreadViewerEditor.this.responseCount) {
                                                    latestResponseLocation[0] = new ColoredText.TextPosition(i, 0);
                                                }
                                                ++i;
                                            }
                                        }
                                    }
                                });
                            }
                            if (scroll <= this.responseCount) {
                                scrollTo[0] = latestResponseLocation[0];
                            }
                            final ArrayList lines = new ArrayList();
                            long bulkWrite = System.currentTimeMillis();
                            int writePeriod = this.responseCount + 10;
                            Runnable applyLines = new Runnable(){

                                public void run() {
                                    if (!download) {
                                        int i = 0;
                                        while (i < lines.size()) {
                                            ThreadViewerEditor.this.unmarkNewResponse((ColoredText.Line)lines.get(i));
                                            ++i;
                                        }
                                    }
                                    ThreadViewerEditor.this.text.addLines(lines);
                                    lines.clear();
                                    if (scrollTo[0] != null) {
                                        Point pt = ThreadViewerEditor.this.text.getPointFromIndex(scrollTo[0]);
                                        ScrollBar vert = ThreadViewerEditor.this.text.getVerticalBar();
                                        if (vert.getSelection() + pt.y < vert.getMaximum() - vert.getThumb()) {
                                            ThreadViewerEditor.this.text.scrollTo(scrollTo[0], 128);
                                            scrollTo[0] = null;
                                        }
                                    }
                                }
                            };
                            try {
                                try {
                                    while (!monitor.isCanceled() && e.hasNextResponse()) {
                                        if (!e.getNextResponse(lines)) continue;
                                        if (this.responseCount == 0) {
                                            this.input.setTitle(e.getTitle());
                                            this.display.syncExec(new Runnable(){

                                                public void run() {
                                                    ThreadViewerEditor.this.setTitle(ThreadViewerEditor.this.input.getTitle());
                                                    ((ThreadViewerEditorActionBarContributor)ThreadViewerEditor.this.getEditorSite().getActionBarContributor()).updateBookmarkDependentActions();
                                                    ColoredText.Line line = new ColoredText.Line(0);
                                                    line.addLineFragment(new ColoredText.LineFragment(ThreadViewerEditor.this.input.getTitle(), 1, 0, false));
                                                    ThreadViewerEditor.this.text.addLine(line);
                                                    ThreadViewerEditor.this.text.addLine(new ColoredText.Line(0));
                                                }
                                            });
                                        }
                                        ++this.responseCount;
                                        if (this.responseCount < 5 || this.responseCount == writePeriod || 300L < System.currentTimeMillis() - bulkWrite || scroll == this.responseCount) {
                                            bulkWrite = System.currentTimeMillis();
                                            this.display.syncExec(applyLines);
                                            if (scroll == this.responseCount) {
                                                this.display.syncExec(new Runnable(){

                                                    public void run() {
                                                        int i = ThreadViewerEditor.this.text.getLineCount() - 1;
                                                        while (i >= 0) {
                                                            ColoredText.Line line = ThreadViewerEditor.this.text.getLineAt(i);
                                                            if (line instanceof IResponseHeaderLine) {
                                                                scrollTo[0] = new ColoredText.TextPosition(i, 0);
                                                                break;
                                                            }
                                                            --i;
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                        if (this.responseCount != 1) continue;
                                        String tooltipText = String.valueOf(this.input.getTitle()) + "\n" + this.input.getURL();
                                        this.input.setToolTipText(tooltipText);
                                        this.display.syncExec(new Runnable(){

                                            public void run() {
                                                ThreadViewerEditor.this.setTitleToolTip(ThreadViewerEditor.this.input.getToolTipText());
                                                ThreadViewerEditor.this.setTitle(ThreadViewerEditor.this.input.getTitle());
                                            }
                                        });
                                    }
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            catch (Throwable throwable) {
                                Object var14_18 = null;
                                if (lines.size() <= 0) throw throwable;
                                this.display.syncExec(applyLines);
                                throw throwable;
                            }
                            Object var14_19 = null;
                            if (lines.size() > 0) {
                                this.display.syncExec(applyLines);
                            }
                            this.sequence = e.getSequenceNumber();
                            if (this.responseCount < scroll) {
                                scrollTo[0] = latestResponseLocation[0];
                            }
                            if (scrollTo[0] != null) {
                                this.display.syncExec(new Runnable(){

                                    public void run() {
                                        ThreadViewerEditor.this.text.scrollTo(scrollTo[0], 128);
                                    }
                                });
                            }
                        }
                        catch (Throwable throwable) {
                            Object var16_21 = null;
                            e.close();
                            throw throwable;
                        }
                        Object var16_22 = null;
                        e.close();
                        break block23;
                    }
                    catch (Throwable throwable) {
                        Object var18_7 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return;
            }
            Object var18_6 = null;
            monitor.done();
            return;
        }
        Object var18_8 = null;
        monitor.done();
    }

    private void unmarkNewResponse(ColoredText.Line line) {
        int j = 0;
        while (j < line.getLineFragmentCount()) {
            ColoredText.LineFragment f = line.getLineFragmentAt(j);
            if (f instanceof INewResponseLineFragment) {
                ((INewResponseLineFragment)((Object)f)).unmark();
            }
            ++j;
        }
    }

    public void disposeCache() {
        try {
            this.getContentProvider().getLogFile().delete(true, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    public void lockToolTip() {
        this.text.lockToolTip();
    }

    public ITextOperationTarget getTextOperationTarget() {
        return this.text;
    }

    public boolean scrollTo(final int responseNumber) {
        final boolean[] res = new boolean[1];
        this.display.asyncExec(new Runnable(){

            public void run() {
                int i = 0;
                while (i < ThreadViewerEditor.this.text.getLineCount()) {
                    ColoredText.Line line = ThreadViewerEditor.this.text.getLineAt(i);
                    if (line instanceof IResponseHeaderLine && ((IResponseHeaderLine)((Object)line)).getReponseNumber() == responseNumber) {
                        ColoredText.TextPosition read = new ColoredText.TextPosition(i, 0);
                        ThreadViewerEditor.this.text.scrollTo(read, 128);
                        res[0] = true;
                        break;
                    }
                    ++i;
                }
            }
        });
        return res[0];
    }

    private int saveScrollPosition() {
        ColoredText.TextPosition bottomLine = this.text.getIndexFromPoint(new Point(0, this.text.getSize().y - 1), false);
        if (bottomLine.isValid()) {
            int i = bottomLine.row;
            while (i >= 0) {
                ColoredText.Line line = this.text.getLineAt(i);
                if (line instanceof IResponseHeaderLine) {
                    int read = ((IResponseHeaderLine)((Object)line)).getReponseNumber();
                    try {
                        IThreadContentProvider cp = this.getContentProvider();
                        IFolder iFolder = cp.getLogFolder();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iFolder.setPersistentProperty(new QualifiedName(clazz.getName(), String.valueOf(cp.getID()) + ".read"), String.valueOf(read));
                        IFolder iFolder2 = cp.getLogFolder();
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iFolder2.setPersistentProperty(new QualifiedName(clazz2.getName(), String.valueOf(cp.getID()) + ".readLine"), String.valueOf(bottomLine.row));
                    }
                    catch (CoreException coreException) {}
                    return read;
                }
                --i;
            }
        }
        return 0;
    }

    private void loadScrollPosition() {
        try {
            IThreadContentProvider cp = this.getContentProvider();
            IFolder iFolder = cp.getLogFolder();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ColoredText.TextPosition read = new ColoredText.TextPosition(Integer.parseInt(iFolder.getPersistentProperty(new QualifiedName(clazz.getName(), String.valueOf(cp.getID()) + ".readLine"))), 0);
            this.text.scrollTo(read, 1024);
        }
        catch (CoreException coreException) {
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public IThreadContentProvider getContentProvider() {
        if (this.content == null) {
            try {
                this.content = BBSServerManager.getThreadContentProviderOf(new URL(this.input.getURL()));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.content;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof ThreadEditorInput) {
            this.input = (ThreadEditorInput)input;
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public static void activateEditor(IWorkbenchPartSite site, IThreadContentProvider thread) {
        logger.finest("begin");
        IWorkbenchPage page = site.getPage().getWorkbenchWindow().getActivePage();
        IEditorPart part = page.findEditor((IEditorInput)new ThreadEditorInput(thread));
        if (part != null) {
            try {
                logger.finest("activate");
                ThreadEditorInput threadEditorInput = new ThreadEditorInput(thread);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                page.openEditor((IEditorInput)threadEditorInput, clazz.getName(), false);
            }
            catch (PartInitException ex) {
                ex.printStackTrace();
            }
        }
        logger.finest("done");
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getShell().getDisplay();
        this.text = new ColoredText(parent, 512);
        this.text.setBackground(this.text.getAttributes().getColor(4));
        this.text.setForeground(this.text.getAttributes().getColor(0));
        this.text.setToolTipProvider(this);
        this.text.setLinkProvider(this);
        this.text.addTextTrackListener(new ColoredText.TextTrackListener(){

            public void textEnter(ColoredText.TextEvent e) {
                if (e.fragment instanceof ColoredText.ToolTipTarget) {
                    ThreadViewerEditor.this.getContentProvider().prefetchToolTip((ColoredText.ToolTipTarget)((Object)e.fragment));
                }
            }

            public void textExit(ColoredText.TextEvent e) {
            }

            public void textHover(ColoredText.TextEvent e) {
            }

            public void textSelectionEnter(ColoredText.TextEvent e) {
            }

            public void textSelectionExit(ColoredText.TextEvent e) {
            }

            public void textSelectionHover(ColoredText.TextEvent e) {
            }
        });
        this.text.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((ThreadViewerEditorActionBarContributor)ThreadViewerEditor.this.getEditorSite().getActionBarContributor()).updateSelectionDependentActions();
            }
        });
        this.text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    ThreadViewerEditor.this.text.setSelection(ColoredText.TextPosition.INVALID, ColoredText.TextPosition.INVALID, true);
                } else if (e.keyCode == 0x100000E) {
                    ThreadViewerEditor.this.updateThread(-1);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.hookContextMenu();
        this.getSite().getPage().addPartListener((IPartListener)new PartActivationListener());
        this.linkSelectionProvider = new LinkSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.linkSelectionProvider);
        CancelableRunner cancelable = ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).getCancelable();
        cancelable.setDisplay(this.display);
        cancelable.runDirect(new CancelableRunner.ICancelableRunnableWithProgress(){

            public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                ThreadViewerEditor.this.updateThread(monitor, false, -1);
            }
        });
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ThreadViewerEditor.this.display.asyncExec(new Runnable(this){
                    private final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        ThreadViewerEditor.access$10(15.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ ThreadViewerEditor access$0(15 var0) {
                return var0.ThreadViewerEditor.this;
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ThreadViewerEditorActionBarContributor cont = (ThreadViewerEditorActionBarContributor)ThreadViewerEditor.this.getEditorSite().getActionBarContributor();
                cont.contributeToContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.text);
        this.text.setMenu(menu);
    }

    public void linkClicked(ColoredText text, ColoredText.LinkTarget target) {
        if (target instanceof ILinkedLineFragment) {
            String href = ((ILinkedLineFragment)target).getURL();
            try {
                IThreadContentProvider thread = BBSServerManager.getThreadContentProviderOf(new URL(href));
                if (thread != null) {
                    IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
                    try {
                        IEditorPart part;
                        boolean update = page.findEditor((IEditorInput)new ThreadEditorInput(thread)) == null;
                        ThreadEditorInput threadEditorInput = new ThreadEditorInput(thread);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((part = page.openEditor((IEditorInput)threadEditorInput, clazz.getName())) instanceof ThreadViewerEditor) {
                            boolean scrolled = true;
                            int pos = ((ILinkedLineFragment)target).getResponseFragment();
                            if (pos > 0 && ((ThreadViewerEditor)part).scrollTo(pos)) {
                                pos = -1;
                            }
                            if (update) {
                                ((ThreadViewerEditor)part).updateThread(scrolled ? -1 : pos);
                            }
                        }
                    }
                    catch (PartInitException ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                IBBSBoard board = BBSServerManager.getBoardOf(new URL(href));
                if (board != null) {
                    this.linkSelectionProvider.fireSelectionChangedEvent(board);
                    return;
                }
                if (href.startsWith("http")) {
                    Program.launch((String)href);
                    return;
                }
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Point fillToolTip(Composite parent, ColoredText text, int maxWidth, ColoredText.ToolTipTarget target) {
        return this.getContentProvider().fillToolTip(parent, text, maxWidth, target, this.getTitle());
    }

    public Point fillToolTip(Composite parent, ColoredText text, int maxWidth, String selection) {
        return this.getContentProvider().fillToolTip(parent, text, maxWidth, selection, this.getTitle());
    }

    public void toolTipActivated(ColoredText text) {
        this.toolTipActive = true;
        ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).updateToolTipDependentActions();
    }

    public void toolTipDeactivated(ColoredText text) {
        this.toolTipActive = false;
        ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).updateToolTipDependentActions();
    }

    public boolean isToolTipActive() {
        return this.toolTipActive;
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public void dispose() {
        if (this.text != null) {
            this.text.dispose();
        }
        this.text = null;
        super.dispose();
    }

    public boolean canPerformFind() {
        return true;
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        ColoredText.TextPosition off = new ColoredText.TextPosition(this.text.getLineCount() - 1, this.text.getLineAt(this.text.getLineCount() - 1).getTextLength());
        int i = 0;
        while (i < this.text.getLineCount()) {
            int len = this.text.getLineAt(i).getTextLength();
            if (offset < len) {
                off = new ColoredText.TextPosition(i, Math.max(offset, 0));
                break;
            }
            offset -= len;
            ++i;
        }
        return this.text.textPositionToIntPosition(this.text.findAndSelect(off, findString, searchForward, caseSensitive, wholeWord));
    }

    public Point getSelection() {
        ColoredText.TextSelection sel = this.text.getTextSelection();
        int start = this.text.textPositionToIntPosition(sel.from);
        int end = this.text.textPositionToIntPosition(sel.to);
        return new Point(start, end - start);
    }

    public String getSelectionText() {
        ColoredText.TextSelection sel = this.text.getTextSelection();
        return this.text.getText(sel.from, sel.to, false);
    }

    public boolean isEditable() {
        return false;
    }

    public void replaceSelection(String text) {
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    static /* synthetic */ void access$10(ThreadViewerEditor threadViewerEditor) {
        threadViewerEditor.loadScrollPosition();
    }

    private class PartActivationListener
    implements IPartListener {
        private boolean active = true;

        PartActivationListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            this.active = true;
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == ThreadViewerEditor.this && this.active) {
                ThreadViewerEditor.this.saveScrollPosition();
                this.active = false;
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class LinkSelectionProvider
    implements ISelectionProvider {
        private List selectionChangedListeners = new ArrayList();

        LinkSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
        }

        public ISelection getSelection() {
            return null;
        }

        private void fireSelectionChangedEvent(IBBSBoard board) {
            SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection((Object)board));
            int i = 0;
            while (i < this.selectionChangedListeners.size()) {
                ISelectionChangedListener l = (ISelectionChangedListener)this.selectionChangedListeners.get(i);
                l.selectionChanged(e);
                ++i;
            }
        }
    }
}

