package monalipse.actions;

import java.net.URL;

import monalipse.bookmark.BookmarkManager;
import monalipse.bookmark.IBookmarkTreeNode;
import monalipse.views.IBBSReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public class BookmarkAction extends Action
{
	private IWorkbenchWindow workbenchWindow;
	private String title;
	private URL url;

	public BookmarkAction()
	{
		super(BookmarkAction.class.getName());
	}
	
	public void run()
	{
		if(workbenchWindow != null && title != null && url != null && isEnabled())
		{
			IBookmarkTreeNode bookmark = BookmarkManager.getBookmarks();
			IBookmarkTreeNode exist = bookmark.findItem(url);
			if(exist == null)
			{
				bookmark.createLink(title, url);
			}
			else
			{
				while(exist != null)
				{
					exist.remove();
					exist = bookmark.findItem(url);
				}
			}
			BookmarkManager.setBookmarks(workbenchWindow, bookmark);
		}
	}
	
	public void updateState(IWorkbenchWindow workbenchWindow, String title, URL url, boolean enabled)
	{
		this.workbenchWindow = workbenchWindow;
		this.title = title;
		this.url = url;
		if(!enabled || BookmarkManager.getBookmarks().findItem(url) == null)
		{
			setText("Add Bookmark");
			setToolTipText("Add Bookmark");
		}
		else
		{
			setText("Remove Bookmark");
			setToolTipText("Remove Bookmark");
		}
		setEnabled(enabled);
	}
	
	public IBBSReference updateState(IWorkbenchWindow workbenchWindow, ISelection selection)
	{
		if(selection instanceof IStructuredSelection)
		{
			Object first = ((IStructuredSelection)selection).getFirstElement();
			if(first instanceof IBBSReference)
			{
				IBBSReference ref = (IBBSReference)first;
				updateState(workbenchWindow, ref.getName(), ref.getURL(), true);
				return ref;
			}
		}
		
		updateState(null, null, null, false);
		return null;
	}

}
