package monalipse.bookmark;

import java.net.URL;

import monalipse.views.IBBSReference;
import org.eclipse.core.runtime.IAdaptable;

public interface IBookmarkTreeNode extends IAdaptable
{
	public IBookmarkTreeNode createLink(String name, URL href);
	public IBookmarkTreeNode createFolder(String name);
	public void remove();
	public void setName(String name);
	public String getName();
	public boolean hasChildren();
	public IBookmarkTreeNode[] getChildren();
	public IBookmarkTreeNode getParent();
	public IBookmarkTreeNode getRoot();
	public IBookmarkTreeNode findItem(URL url);
	public boolean isAncestorOf(IBookmarkTreeNode node);
	public boolean hasNewResponses();
}
