package monalipse.server;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import monalipse.MonalipsePlugin;
import monalipse.server.giko.GikoServer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BBSServerManager
{
	private static Map instances = new HashMap();
	private static IBBSServer[] servers = new IBBSServer[0];
	
	private static void ensureProjectRetarget()
	{
		if(servers.length != 0)
			return;
		
		IProject project = MonalipsePlugin.getProject();
		if(project != null)
			ensureProjectRetarget(project);
	}
	
	private static void ensureProjectRetarget(IProject project)
	{
		List list = new ArrayList();
		IBBSServer server;

		server = new GikoServer();
		server.initialize(project.getFolder(server.getTargetName()));
		list.add(server);

		servers = new IBBSServer[list.size()];
		list.toArray(servers);
	}
	
	public static IThreadContentProvider getThreadContentProviderOf(URL url)
	{
		IBBSBoard board = getBoardOf(url);
		if(board == null)
			return null;
		else
			return board.getThreadOf(url);
	}
	
	public static IBBSBoard getBoardOf(URL url)
	{
		ensureProjectRetarget();
		for(int i = 0; i < servers.length; i++)
		{
			IBBSBoard board = servers[i].getBoardOf(url);
			if(board != null)
				return board;
		}
		return null;
	}

	public static IBBSServer getInstanceOf(String target)
	{
		ensureProjectRetarget();
		for(int i = 0; i < servers.length; i++)
		{
			if(servers[i].getTargetName().equals(target))
				return servers[i];
		}
		return null;
	}
}
