/*
 * Decompiled with CFR 0.152.
 */
package monalipse.editors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import monalipse.MonalipsePlugin;
import monalipse.bookmark.BookmarkManager;
import monalipse.editors.ThreadEditorInput;
import monalipse.editors.ThreadViewerEditor;
import monalipse.editors.ThreadViewerEditorActionBarContributor;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.IBBSReference;
import monalipse.server.ILinkedLineFragment;
import monalipse.server.IResponseEnumeration;
import monalipse.server.IThreadContentProvider;
import monalipse.server.LinkedObject;
import monalipse.server.Response;
import monalipse.utils.CancelableRunner;
import monalipse.widgets.ColoredText;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ThreadViewerEditor
extends EditorPart
implements ColoredText.ToolTipProvider,
ColoredText.LinkProvider,
IFindReplaceTarget,
IPartListener,
IResourceChangeListener,
ISelectionListener {
    private static String PREF_PREFIX = "threadViewer.";
    public static String PREF_BODY_COLOR = String.valueOf(PREF_PREFIX) + "body.color";
    private static RGB DEFAULT_BODY_COLOR = new RGB(0, 0, 0);
    public static String PREF_LINK_COLOR = String.valueOf(PREF_PREFIX) + "link.color";
    private static RGB DEFAULT_LINK_COLOR = new RGB(0, 0, 255);
    public static String PREF_LINK_CLICKED_COLOR = String.valueOf(PREF_PREFIX) + "link.clicked.color";
    private static RGB DEFAULT_LINK_CLICKED_COLOR = new RGB(102, 0, 153);
    public static String PREF_MARKING_COLOR = String.valueOf(PREF_PREFIX) + "marking.color";
    private static RGB DEFAULT_MARKING_COLOR = new RGB(255, 0, 0);
    public static String PREF_NAME_COLOR = String.valueOf(PREF_PREFIX) + "name.color";
    private static RGB DEFAULT_NAME_COLOR = new RGB(34, 139, 34);
    public static String PREF_MAIL_COLOR = String.valueOf(PREF_PREFIX) + "mail.color";
    private static RGB DEFAULT_MAIL_COLOR = new RGB(0, 0, 255);
    public static String PREF_BACKGROUND_COLOR = String.valueOf(PREF_PREFIX) + "background.color";
    private static RGB DEFAULT_BACKGROUND_COLOR = new RGB(239, 239, 239);
    public static String PREF_NORMAL_FONT = String.valueOf(PREF_PREFIX) + "normal.font";
    private static FontData DEFAULT_NORMAL_FONT = new FontData("MS P Gothic", 12, 0);
    public static String PREF_LINE_HEIGHT = String.valueOf(PREF_PREFIX) + "line.height";
    private static int DEFAULT_LINE_HEIGHT = 18;
    private static final Logger logger;
    private ThreadEditorInput input;
    private Display display;
    private ColoredText text;
    private ThreadViewerAttributes attributes;
    private int sequence;
    private int responseCount;
    private boolean writable;
    private boolean toolTipActive;
    private SelectionProvider selectionProvider;
    private boolean active = true;
    private boolean toBeUpdated;
    private LinkedObject[] linkedObjects;
    private boolean linkedObjectsValid;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        PreferenceConverter.setDefault((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_BODY_COLOR, (RGB)DEFAULT_BODY_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_LINK_COLOR, (RGB)DEFAULT_LINK_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_LINK_CLICKED_COLOR, (RGB)DEFAULT_LINK_CLICKED_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_MARKING_COLOR, (RGB)DEFAULT_MARKING_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_NAME_COLOR, (RGB)DEFAULT_NAME_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_MAIL_COLOR, (RGB)DEFAULT_MAIL_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_BACKGROUND_COLOR, (RGB)DEFAULT_BACKGROUND_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_NORMAL_FONT, (FontData)DEFAULT_NORMAL_FONT);
        MonalipsePlugin.getDefault().getPreferenceStore().setDefault(PREF_LINE_HEIGHT, DEFAULT_LINE_HEIGHT);
        logger = MonalipsePlugin.getLogger();
    }

    public void updateThread(int scrollTo) {
        CancelableRunner cancelable = ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).getCancelable();
        cancelable.run(this, new CancelableRunner.ICancelableRunnableWithProgress(this, scrollTo){
            private final /* synthetic */ int val$scrollTo;
            private final /* synthetic */ ThreadViewerEditor this$0;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
                this.val$scrollTo = n;
            }

            public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                this.this$0.updateThread(monitor, true, this.val$scrollTo);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateThread(CancelableRunner.ICancelableProgressMonitor monitor, boolean download, int scroll) {
        block25: {
            block23: {
                block22: {
                    monitor.beginTask("getting thread...", 130);
                    try {
                        IThreadContentProvider thread = this.getContentProvider();
                        if (thread == null) {
                            Object var19_5 = null;
                            break block22;
                        }
                        this.display.syncExec(new Runnable(this){
                            private final /* synthetic */ ThreadViewerEditor this$0;
                            {
                                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                                threadViewerEditor2.getClass();
                                this.this$0 = threadViewerEditor2;
                            }

                            public void run() {
                                this.this$0.setTitleImage(MonalipsePlugin.getDefault().getLabelImageOf(this.this$0.getContentProvider()));
                                int i = 0;
                                while (i < this.this$0.text.getLineCount()) {
                                    if (this.this$0.text.getLineAt(i) instanceof Response.HeaderLine) {
                                        ((Response.HeaderLine)this.this$0.text.getLineAt(i)).getResponse().unmarkNewResponse();
                                    }
                                    ++i;
                                }
                                this.this$0.text.redraw();
                            }
                        });
                        monitor.worked(10);
                        IResponseEnumeration e = download ? thread.updateResponses(monitor.getRunner().getSubProgressMonitor(monitor, 100), this.getSite().getWorkbenchWindow(), this.sequence, this.responseCount) : thread.getResponses(monitor.getRunner().getSubProgressMonitor(monitor, 100), this.sequence, this.responseCount);
                        this.writable = e.isWritable();
                        monitor.worked(10);
                        if (e == null) {
                            break block23;
                        }
                        try {
                            if (!e.isPartialContent()) {
                                this.responseCount = 0;
                                this.display.syncExec(new Runnable(this){
                                    private final /* synthetic */ ThreadViewerEditor this$0;
                                    {
                                        ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                                        threadViewerEditor2.getClass();
                                        this.this$0 = threadViewerEditor2;
                                    }

                                    public void run() {
                                        this.this$0.text.clear();
                                    }
                                });
                            }
                            monitor.worked(10);
                            ColoredText.TextPosition[] latestResponseLocation = new ColoredText.TextPosition[1];
                            ColoredText.TextPosition[] scrollTo = new ColoredText.TextPosition[1];
                            if (download) {
                                this.display.syncExec(new Runnable(this, latestResponseLocation){
                                    private final /* synthetic */ ThreadViewerEditor this$0;
                                    private final /* synthetic */ ColoredText.TextPosition[] val$latestResponseLocation;
                                    {
                                        ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                                        threadViewerEditor2.getClass();
                                        this.this$0 = threadViewerEditor2;
                                        this.val$latestResponseLocation = textPositionArray;
                                    }

                                    public void run() {
                                        if (this.this$0.responseCount != 0 && this.this$0.saveScrollPosition() == this.this$0.responseCount) {
                                            int i = 0;
                                            while (i < this.this$0.text.getLineCount()) {
                                                ColoredText.Line line = this.this$0.text.getLineAt(i);
                                                if (line instanceof Response.HeaderLine && ((Response.HeaderLine)line).getReponseNumber() == this.this$0.responseCount) {
                                                    this.val$latestResponseLocation[0] = new ColoredText.TextPosition(i, 0);
                                                }
                                                ++i;
                                            }
                                        }
                                    }
                                });
                            }
                            if (scroll <= this.responseCount) {
                                scrollTo[0] = latestResponseLocation[0];
                            }
                            ArrayList<Response> responses = new ArrayList<Response>();
                            long bulkWrite = System.currentTimeMillis();
                            int writePeriod = this.responseCount + 10;
                            Runnable applyLines = new Runnable(this, download, responses, scrollTo){
                                private final /* synthetic */ boolean val$download;
                                private final /* synthetic */ List val$responses;
                                private final /* synthetic */ ThreadViewerEditor this$0;
                                private final /* synthetic */ ColoredText.TextPosition[] val$scrollTo;
                                {
                                    ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                                    threadViewerEditor2.getClass();
                                    this.this$0 = threadViewerEditor2;
                                    this.val$download = bl;
                                    this.val$responses = list;
                                    this.val$scrollTo = textPositionArray;
                                }

                                public void run() {
                                    if (!this.val$download) {
                                        int i = 0;
                                        while (i < this.val$responses.size()) {
                                            ((Response)this.val$responses.get(i)).unmarkNewResponse();
                                            ++i;
                                        }
                                    }
                                    ArrayList<ColoredText.Line> lines = new ArrayList<ColoredText.Line>();
                                    int i = 0;
                                    while (i < this.val$responses.size()) {
                                        ((Response)this.val$responses.get(i)).getLines(lines);
                                        lines.add(new ColoredText.Line(0));
                                        ++i;
                                    }
                                    this.this$0.text.addLines(lines);
                                    this.val$responses.clear();
                                    if (this.val$scrollTo[0] != null) {
                                        Point pt = this.this$0.text.getPointFromIndex(this.val$scrollTo[0]);
                                        ScrollBar vert = this.this$0.text.getVerticalBar();
                                        if (vert.getSelection() + pt.y < vert.getMaximum() - vert.getThumb()) {
                                            this.this$0.text.scrollTo(this.val$scrollTo[0], 128);
                                            this.val$scrollTo[0] = null;
                                        }
                                    }
                                }
                            };
                            try {
                                try {
                                    while (!monitor.isCanceled() && e.hasNextResponse()) {
                                        Response response = e.getNextResponse();
                                        if (response == null) continue;
                                        responses.add(response);
                                        if (this.responseCount == 0) {
                                            this.input.setTitle(e.getTitle());
                                            this.display.syncExec(new Runnable(this){
                                                private final /* synthetic */ ThreadViewerEditor this$0;
                                                {
                                                    ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                                                    threadViewerEditor2.getClass();
                                                    this.this$0 = threadViewerEditor2;
                                                }

                                                public void run() {
                                                    this.this$0.setTitle(this.this$0.input.getTitle());
                                                    ((ThreadViewerEditorActionBarContributor)this.this$0.getEditorSite().getActionBarContributor()).updateBookmarkDependentActions();
                                                    ColoredText.Line line = new ColoredText.Line(0);
                                                    line.addLineFragment(new ColoredText.LineFragment(this.this$0.input.getTitle(), 3, 0, false));
                                                    this.this$0.text.addLine(line);
                                                    this.this$0.text.addLine(new ColoredText.Line(0));
                                                }
                                            });
                                        }
                                        ++this.responseCount;
                                        if (this.responseCount < 5 || this.responseCount == writePeriod || 300L < System.currentTimeMillis() - bulkWrite || scroll == this.responseCount) {
                                            bulkWrite = System.currentTimeMillis();
                                            this.display.syncExec(applyLines);
                                            if (scroll == this.responseCount) {
                                                this.display.syncExec(new Runnable(this, scrollTo){
                                                    private final /* synthetic */ ThreadViewerEditor this$0;
                                                    private final /* synthetic */ ColoredText.TextPosition[] val$scrollTo;
                                                    {
                                                        ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                                                        threadViewerEditor2.getClass();
                                                        this.this$0 = threadViewerEditor2;
                                                        this.val$scrollTo = textPositionArray;
                                                    }

                                                    public void run() {
                                                        int i = this.this$0.text.getLineCount() - 1;
                                                        while (i >= 0) {
                                                            ColoredText.Line line = this.this$0.text.getLineAt(i);
                                                            if (line instanceof Response.HeaderLine) {
                                                                this.val$scrollTo[0] = new ColoredText.TextPosition(i, 0);
                                                                break;
                                                            }
                                                            --i;
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                        if (this.responseCount != 1) continue;
                                        String tooltipText = String.valueOf(this.input.getTitle()) + "\n" + this.input.getURL();
                                        this.input.setToolTipText(tooltipText);
                                        this.display.syncExec(new Runnable(this){
                                            private final /* synthetic */ ThreadViewerEditor this$0;
                                            {
                                                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                                                threadViewerEditor2.getClass();
                                                this.this$0 = threadViewerEditor2;
                                            }

                                            public void run() {
                                                this.this$0.setTitleToolTip(this.this$0.input.getToolTipText());
                                                this.this$0.setTitle(this.this$0.input.getTitle());
                                            }
                                        });
                                    }
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            catch (Throwable throwable) {
                                Object var15_19 = null;
                                if (responses.size() <= 0) throw throwable;
                                this.display.syncExec(applyLines);
                                throw throwable;
                            }
                            Object var15_20 = null;
                            if (responses.size() > 0) {
                                this.display.syncExec(applyLines);
                            }
                            this.sequence = e.getSequenceNumber();
                            if (this.responseCount < scroll) {
                                scrollTo[0] = latestResponseLocation[0];
                            }
                            if (scrollTo[0] != null) {
                                this.display.syncExec(new Runnable(this, scrollTo){
                                    private final /* synthetic */ ThreadViewerEditor this$0;
                                    private final /* synthetic */ ColoredText.TextPosition[] val$scrollTo;
                                    {
                                        ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                                        threadViewerEditor2.getClass();
                                        this.this$0 = threadViewerEditor2;
                                        this.val$scrollTo = textPositionArray;
                                    }

                                    public void run() {
                                        this.this$0.text.scrollTo(this.val$scrollTo[0], 128);
                                    }
                                });
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_22 = null;
                            if (this.linkedObjects != null) {
                                this.linkedObjectsValid = false;
                            }
                            e.close();
                            throw throwable;
                        }
                        Object var17_23 = null;
                        if (this.linkedObjects != null) {
                            this.linkedObjectsValid = false;
                        }
                        e.close();
                        break block25;
                    }
                    catch (Throwable throwable) {
                        Object var19_7 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return;
            }
            Object var19_6 = null;
            monitor.done();
            return;
        }
        Object var19_8 = null;
        monitor.done();
    }

    public LinkedObject[] getLinkedObjects() {
        if (this.linkedObjects == null) {
            this.linkedObjects = new LinkedObject[0];
        }
        if (!this.linkedObjectsValid) {
            this.updateLinkedObjects();
        }
        return this.linkedObjects;
    }

    public void updateLinkedObjects() {
        this.linkedObjectsValid = true;
        IThreadContentProvider thread = this.getContentProvider();
        if (thread == null) {
            return;
        }
        logger.finest("begin");
        ArrayList<LinkedObject> list = new ArrayList<LinkedObject>();
        int responseNumber = 0;
        int i = 0;
        while (i < this.text.getLineCount()) {
            ColoredText.Line line = this.text.getLineAt(i);
            if (line instanceof Response.HeaderLine) {
                responseNumber = ((Response.HeaderLine)line).getReponseNumber();
            }
            int j = 0;
            while (j < line.getLineFragmentCount()) {
                ColoredText.LineFragment f = line.getLineFragmentAt(j);
                if (f instanceof ILinkedLineFragment) {
                    String link = ((ILinkedLineFragment)((Object)f)).getURL();
                    try {
                        if (LinkedObject.matches(link)) {
                            if (list.size() < this.linkedObjects.length && this.linkedObjects[list.size()].getResponseNumber() == responseNumber && this.linkedObjects[list.size()].getURLText().equals(link)) {
                                list.add(this.linkedObjects[list.size()]);
                            } else {
                                list.add(new LinkedObject(thread, responseNumber, new URL(link)));
                            }
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                ++j;
            }
            ++i;
        }
        this.linkedObjects = new LinkedObject[list.size()];
        list.toArray(this.linkedObjects);
        logger.finest("done");
    }

    public void disposeCache() {
        try {
            this.getContentProvider().getLogFile().delete(true, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    public void lockToolTip() {
        this.text.lockToolTip();
    }

    public ITextOperationTarget getTextOperationTarget() {
        return this.text;
    }

    public boolean scrollTo(int responseNumber) {
        boolean[] res = new boolean[1];
        this.display.asyncExec(new Runnable(this, responseNumber, res){
            private final /* synthetic */ ThreadViewerEditor this$0;
            private final /* synthetic */ int val$responseNumber;
            private final /* synthetic */ boolean[] val$res;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
                this.val$responseNumber = n;
                this.val$res = blArray;
            }

            public void run() {
                int i = 0;
                while (this.this$0.text != null && i < this.this$0.text.getLineCount()) {
                    ColoredText.Line line = this.this$0.text.getLineAt(i);
                    if (line instanceof Response.HeaderLine && ((Response.HeaderLine)line).getReponseNumber() == this.val$responseNumber) {
                        ColoredText.TextPosition read = new ColoredText.TextPosition(i, 0);
                        this.this$0.text.scrollTo(read, 128);
                        this.val$res[0] = true;
                        break;
                    }
                    ++i;
                }
            }
        });
        return res[0];
    }

    public int getResponseCount() {
        return this.responseCount;
    }

    private int saveScrollPosition() {
        ColoredText.TextPosition bottomLine;
        if ((this.text.getVerticalBar() == null || this.text.getVerticalBar().getSelection() > 0) && (bottomLine = this.text.getIndexFromPoint(new Point(0, this.text.getSize().y - 1), false)).isValid()) {
            int i = bottomLine.row;
            while (i >= 0) {
                ColoredText.Line line = this.text.getLineAt(i);
                if (line instanceof Response.HeaderLine) {
                    int read = ((Response.HeaderLine)line).getReponseNumber();
                    try {
                        IThreadContentProvider cp = this.getContentProvider();
                        IFile iFile = cp.getLogFile();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iFile.setPersistentProperty(new QualifiedName(clazz.getName(), "read"), String.valueOf(read));
                        IFile iFile2 = cp.getLogFile();
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iFile2.setPersistentProperty(new QualifiedName(clazz2.getName(), "readLine"), String.valueOf(bottomLine.row));
                    }
                    catch (CoreException coreException) {}
                    return read;
                }
                --i;
            }
        }
        return 0;
    }

    private void loadScrollPosition() {
        try {
            IThreadContentProvider cp = this.getContentProvider();
            IFile iFile = cp.getLogFile();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ColoredText.TextPosition read = new ColoredText.TextPosition(Integer.parseInt(iFile.getPersistentProperty(new QualifiedName(clazz.getName(), "readLine"))), 0);
            this.text.scrollTo(read, 1024);
        }
        catch (CoreException coreException) {
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public IThreadContentProvider getContentProvider() {
        try {
            return BBSServerManager.getThreadContentProviderOf(new URL(this.input.getURL()));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof ThreadEditorInput) {
            this.input = (ThreadEditorInput)input;
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public static void activateEditor(IWorkbenchPartSite site, IThreadContentProvider thread) {
        logger.finest("begin");
        IWorkbenchPage page = site.getPage().getWorkbenchWindow().getActivePage();
        IEditorPart part = page.findEditor((IEditorInput)new ThreadEditorInput(thread));
        if (part != null) {
            try {
                logger.finest("activate");
                ThreadEditorInput threadEditorInput = new ThreadEditorInput(thread);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                page.openEditor((IEditorInput)threadEditorInput, clazz.getName(), false);
            }
            catch (PartInitException ex) {
                ex.printStackTrace();
            }
        }
        logger.finest("done");
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getShell().getDisplay();
        this.attributes = new ThreadViewerAttributes((Device)parent.getDisplay());
        MonalipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(this){
            private final /* synthetic */ ThreadViewerEditor this$0;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
            }

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().startsWith(PREF_PREFIX)) {
                    this.this$0.attributes.dispose();
                    this.this$0.attributes = new ThreadViewerAttributes((Device)this.this$0.getSite().getShell().getDisplay());
                    this.this$0.text.setAttributes(this.this$0.attributes);
                }
            }
        });
        this.text = new ColoredText(parent, 65536);
        this.text.setAttributes(this.attributes);
        this.text.setBackgroundAttribute(6);
        this.text.setToolTipProvider(this);
        this.text.setLinkProvider(this);
        this.text.addTextTrackListener(new ColoredText.TextTrackListener(this){
            private final /* synthetic */ ThreadViewerEditor this$0;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
            }

            public void textEnter(ColoredText.TextEvent e) {
                if (e.fragment instanceof ColoredText.ToolTipTarget) {
                    this.this$0.getContentProvider().prefetchToolTip((ColoredText.ToolTipTarget)((Object)e.fragment));
                }
            }

            public void textExit(ColoredText.TextEvent e) {
            }

            public void textHover(ColoredText.TextEvent e) {
            }

            public void textSelectionEnter(ColoredText.TextEvent e) {
            }

            public void textSelectionExit(ColoredText.TextEvent e) {
            }

            public void textSelectionHover(ColoredText.TextEvent e) {
            }
        });
        this.text.addSelectionChangedListener(new ISelectionChangedListener(this){
            private final /* synthetic */ ThreadViewerEditor this$0;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                ((ThreadViewerEditorActionBarContributor)this.this$0.getEditorSite().getActionBarContributor()).updateSelectionDependentActions();
                int sel = this.this$0.getSelectedResponseNumber();
                if (sel != -1) {
                    this.this$0.selectionProvider.fireSelectionChangedEvent(sel);
                }
            }
        });
        this.text.addKeyListener(new KeyListener(this){
            private final /* synthetic */ ThreadViewerEditor this$0;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    this.this$0.text.setSelection(ColoredText.TextPosition.INVALID, ColoredText.TextPosition.INVALID, true);
                } else if (e.keyCode == 0x100000E) {
                    this.this$0.updateThread(-1);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.hookContextMenu();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.selectionProvider = new SelectionProvider(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        CancelableRunner cancelable = ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).getCancelable();
        cancelable.setDisplay(this.display);
        cancelable.runDirect(new CancelableRunner.ICancelableRunnableWithProgress(this){
            private final /* synthetic */ ThreadViewerEditor this$0;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
            }

            public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                this.this$0.updateThread(monitor, false, -1);
            }
        });
        Thread thread = new Thread(new Runnable(this){
            private final /* synthetic */ ThreadViewerEditor this$0;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
            }

            public void run() {
                this.this$0.display.asyncExec(new Runnable(this){
                    private final /* synthetic */ 16 this$1;
                    {
                        16 v0 = var1_1;
                        v0.getClass();
                        this.this$1 = v0;
                    }

                    public void run() {
                        ThreadViewerEditor.access$14(16.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ ThreadViewerEditor access$0(16 var0) {
                return var0.this$0;
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private int getSelectedResponseNumber() {
        ColoredText.TextPosition pos;
        if (this.text.getSelection() instanceof ColoredText.TextSelection && (pos = ((ColoredText.TextSelection)this.text.getSelection()).from).isValid()) {
            int i = pos.row;
            while (i >= 0) {
                ColoredText.Line line = this.text.getLineAt(i);
                if (line instanceof Response.HeaderLine) {
                    return ((Response.HeaderLine)line).getReponseNumber();
                }
                --i;
            }
        }
        return -1;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection && this.getContentProvider() != null) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            IBBSReference ref = null;
            if (first instanceof IBBSReference) {
                ref = (IBBSReference)first;
            } else if (first instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)first;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("monalipse.server.IBBSReference");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ref = (IBBSReference)iAdaptable.getAdapter((Class)clazz);
            }
            if (ref != null && ref.getResponseNumber() != -1 && ref.getURL().toExternalForm().equals(this.getContentProvider().getURL().toExternalForm())) {
                this.scrollTo(ref.getResponseNumber());
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        logger.finest("begin");
        IThreadContentProvider thread = this.getContentProvider();
        if (thread != null) {
            boolean threadChanged = thread.threadChanged(event);
            boolean boardChanged = thread.getBoard().threadListChanged(event);
            boolean bookmarkChanged = BookmarkManager.bookmarkChanged(event);
            if (threadChanged || boardChanged || bookmarkChanged) {
                this.setTitleImage(MonalipsePlugin.getDefault().getLabelImageOf(thread));
            }
        }
        logger.finest("done");
    }

    public void setToBeUpdated(boolean updated) {
        this.toBeUpdated = updated;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(this){
            private final /* synthetic */ ThreadViewerEditor this$0;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                ThreadViewerEditorActionBarContributor cont = (ThreadViewerEditorActionBarContributor)this.this$0.getEditorSite().getActionBarContributor();
                cont.contributeToContextMenu(manager, this.this$0);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.text);
        menu.addMenuListener(new MenuListener(this, menu){
            private boolean showHover;
            private List listeners;
            private final /* synthetic */ ThreadViewerEditor this$0;
            private final /* synthetic */ Menu val$menu;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
                this.val$menu = menu;
                this.listeners = new ArrayList();
            }

            public void menuShown(MenuEvent e) {
                Display display = this.this$0.getSite().getShell().getDisplay();
                Point cursotLocation = this.this$0.text.toControl(display.getCursorLocation());
                MenuItem[] items = this.val$menu.getItems();
                int i = 0;
                while (i < items.length) {
                    Object listener = null;
                    if (items[i].getText().startsWith(">>")) {
                        try {
                            String label = items[i].getText();
                            int res = Integer.parseInt(label.substring(2, label.length()));
                            listener = new ArmListener(this, cursotLocation, res){
                                private final /* synthetic */ 19 this$1;
                                private final /* synthetic */ Point val$cursotLocation;
                                private final /* synthetic */ int val$res;
                                {
                                    19 v0 = var1_1;
                                    v0.getClass();
                                    this.this$1 = v0;
                                    this.val$cursotLocation = point;
                                    this.val$res = n;
                                }

                                public void widgetArmed(ArmEvent e) {
                                    if (!ThreadViewerEditor.access$3(19.access$2(this.this$1)).isToolTipVisible() || 19.access$0(this.this$1)) {
                                        ThreadViewerEditor.access$3(19.access$2(this.this$1)).showToolTip(this.val$cursotLocation.x, this.val$cursotLocation.y, new ResponseReferToolTipTarget(19.access$2(this.this$1), this.val$res, this.val$res), null, false, true);
                                        19.access$1(this.this$1, true);
                                    }
                                }
                            };
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (listener == null) {
                        listener = new ArmListener(this){
                            private final /* synthetic */ 19 this$1;
                            {
                                19 v0 = var1_1;
                                v0.getClass();
                                this.this$1 = v0;
                            }

                            public void widgetArmed(ArmEvent e) {
                                if (19.access$0(this.this$1)) {
                                    ThreadViewerEditor.access$3(19.access$2(this.this$1)).disposeToolTip();
                                }
                            }
                        };
                    }
                    items[i].addArmListener(listener);
                    this.listeners.add(listener);
                    ++i;
                }
            }

            public void menuHidden(MenuEvent e) {
                this.showHover = false;
                MenuItem[] items = this.val$menu.getItems();
                int i = 0;
                while (i < items.length && i < this.listeners.size()) {
                    items[i].removeArmListener((ArmListener)this.listeners.get(i));
                    ++i;
                }
                this.listeners.clear();
            }

            static /* synthetic */ boolean access$0(19 var0) {
                return var0.showHover;
            }

            static /* synthetic */ void access$1(19 var0, boolean bl) {
                var0.showHover = bl;
            }

            static /* synthetic */ ThreadViewerEditor access$2(19 var0) {
                return var0.this$0;
            }
        });
        this.text.setMenu(menu);
    }

    public void linkClicked(ColoredText text, ColoredText.LinkTarget target) {
        if (target instanceof ILinkedLineFragment) {
            String href = ((ILinkedLineFragment)((Object)target)).getURL();
            try {
                IThreadContentProvider thread = BBSServerManager.getThreadContentProviderOf(new URL(href));
                if (thread != null) {
                    IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
                    try {
                        IEditorPart part;
                        boolean update = page.findEditor((IEditorInput)new ThreadEditorInput(thread)) == null;
                        ThreadEditorInput threadEditorInput = new ThreadEditorInput(thread);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((part = page.openEditor((IEditorInput)threadEditorInput, clazz.getName())) instanceof ThreadViewerEditor) {
                            int pos = ((ILinkedLineFragment)((Object)target)).getTargetResponseNumber();
                            if (pos > 0 && ((ThreadViewerEditor)part).scrollTo(pos)) {
                                pos = -1;
                            }
                            if (update) {
                                ((ThreadViewerEditor)part).updateThread(pos);
                            }
                        }
                    }
                    catch (PartInitException ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                IBBSBoard board = BBSServerManager.getBoardOf(new URL(href));
                if (board != null) {
                    this.selectionProvider.fireSelectionChangedEvent(board);
                    return;
                }
                if (href.startsWith("http")) {
                    Program.launch((String)href);
                    return;
                }
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Point createColoredTextToolTip(Composite parent, ColoredText sourceText, int maxWidth, String title, Response[] responses) {
        ColoredText text = new ColoredText(parent, 65536);
        text.setAttributes(sourceText.getAttributes());
        text.setBackgroundAttribute(sourceText.getBackgroundAttribute());
        text.setToolTipProvider(sourceText.getToolTipProvider());
        text.setToolTipSource(sourceText);
        text.setLinkProvider(sourceText.getLinkProvider());
        if (title != null) {
            ColoredText.Line line = new ColoredText.Line(0);
            line.addLineFragment(new ColoredText.LineFragment(title, 3, 0, false));
            text.addLine(line);
            if (responses != null && responses.length > 0) {
                text.addLine(new ColoredText.Line(0));
            }
        }
        if (responses != null && responses.length > 0) {
            ArrayList<ColoredText.Line> lines = new ArrayList<ColoredText.Line>();
            int i = 0;
            while (i < responses.length) {
                responses[i].getLines(lines);
                lines.add(new ColoredText.Line(0));
                ++i;
            }
            i = lines.size() - 1;
            while (i >= 0) {
                if (((ColoredText.Line)lines.get(i)).getText().trim().length() != 0) break;
                lines.remove(i);
                --i;
            }
            text.addLines(lines);
        }
        Point size = text.computeSize(-1, -1, true);
        if (maxWidth < size.x) {
            size = new Point(maxWidth, text.setWrapWidth(maxWidth));
        }
        text.setSize(size);
        return size;
    }

    private Point createImageToolTip(Composite parent, URL url) {
        final LinkedObject obj = new LinkedObject(this.getContentProvider(), 0, url);
        obj.loadImage();
        Image image = obj.getImage((Device)this.getSite().getShell().getDisplay());
        final IFile file = obj.getCachedFile();
        Label label = new Label(parent, 0);
        label.setImage(image);
        Point size = label.computeSize(-1, -1);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                obj.dispose();
            }
        });
        label.addMouseListener((MouseListener)new MouseAdapter(this, file, obj, label){
            private final /* synthetic */ IFile val$file;
            private final /* synthetic */ ThreadViewerEditor this$0;
            private final /* synthetic */ LinkedObject val$obj;
            private final /* synthetic */ Label val$label;
            {
                ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
                threadViewerEditor2.getClass();
                this.this$0 = threadViewerEditor2;
                this.val$file = iFile;
                this.val$obj = linkedObject;
                this.val$label = label;
            }

            public void mouseDoubleClick(MouseEvent e) {
                try {
                    MonalipsePlugin.ensureSynchronized(this.val$file);
                    if (this.val$file.exists()) {
                        Program.launch((String)this.val$file.getLocation().toOSString());
                        this.this$0.text.disposeToolTip();
                    } else {
                        new Thread(new Runnable(this, this.val$obj, this.val$label){
                            private final /* synthetic */ LinkedObject val$obj;
                            private final /* synthetic */ 23 this$1;
                            private final /* synthetic */ Label val$label;
                            {
                                23 v0 = var1_1;
                                ((Object)((Object)v0)).getClass();
                                this.this$1 = v0;
                                this.val$obj = linkedObject;
                                this.val$label = label;
                            }

                            public void run() {
                                try {
                                    this.val$obj.fetchObject(23.access$0(this.this$1).getSite().getWorkbenchWindow(), true);
                                }
                                catch (Exception exception) {}
                                23.access$0(this.this$1).getSite().getShell().getDisplay().asyncExec(new Runnable(this, this.val$label, this.val$obj){
                                    private final /* synthetic */ Label val$label;
                                    private final /* synthetic */ LinkedObject val$obj;
                                    private final /* synthetic */ 24 this$2;
                                    {
                                        24 v0 = var1_1;
                                        v0.getClass();
                                        this.this$2 = v0;
                                        this.val$label = label;
                                        this.val$obj = linkedObject;
                                    }

                                    public void run() {
                                        if (!this.val$label.isDisposed()) {
                                            this.val$obj.dispose();
                                            this.val$obj.loadImage();
                                            this.val$label.setImage(this.val$obj.getImage((Device)23.access$0(24.access$0(this.this$2)).getSite().getShell().getDisplay()));
                                        }
                                    }
                                });
                            }

                            static /* synthetic */ 23 access$0(24 var0) {
                                return var0.this$1;
                            }
                        }).start();
                    }
                }
                catch (CoreException coreException) {}
            }

            static /* synthetic */ ThreadViewerEditor access$0(23 var0) {
                return var0.this$0;
            }
        });
        DragSource dragSource = new DragSource((Control)label, 1);
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                try {
                    MonalipsePlugin.ensureSynchronized(file);
                    if (file.exists()) {
                        event.doit = true;
                        return;
                    }
                }
                catch (CoreException coreException) {}
                event.doit = false;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = new String[0];
                try {
                    MonalipsePlugin.ensureSynchronized(file);
                    if (file.exists()) {
                        event.data = new String[]{file.getLocation().toOSString()};
                    }
                }
                catch (CoreException coreException) {}
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        return size;
    }

    public Point fillToolTip(Composite parent, ColoredText text, int maxWidth, ColoredText.ToolTipTarget target) {
        if (target instanceof ResponseReferToolTipTarget) {
            IThreadContentProvider thread = this.getContentProvider();
            if (thread == null) {
                return new Point(0, 0);
            }
            ArrayList responses = new ArrayList();
            thread.getResponses(responses, ((ResponseReferToolTipTarget)target).start, ((ResponseReferToolTipTarget)target).end);
            Response[] r = new Response[responses.size()];
            responses.toArray(r);
            return ThreadViewerEditor.createColoredTextToolTip(parent, text, maxWidth, this.getTitle(), r);
        }
        Point size = this.getContentProvider().fillToolTip(parent, text, maxWidth, target, this.getTitle());
        if (size == null && target instanceof ILinkedLineFragment) {
            try {
                Label label;
                URL url = new URL(((ILinkedLineFragment)((Object)target)).getURL());
                IBBSBoard board = BBSServerManager.getBoardOf(url);
                if (board != null) {
                    label = new Label(parent, 0);
                    label.setText(board.getName());
                    size = label.computeSize(-1, -1);
                }
                if (size == null && LinkedObject.matches(url.toExternalForm())) {
                    return this.createImageToolTip(parent, url);
                }
                if (size == null) {
                    label = new Label(parent, 0);
                    label.setText(url.toExternalForm());
                    size = label.computeSize(-1, -1);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (size == null) {
            Label label = new Label(parent, 0);
            label.setText("(error)");
            size = label.computeSize(-1, -1);
        }
        return size;
    }

    public Point fillToolTip(Composite parent, ColoredText text, int maxWidth, String selection) {
        return this.getContentProvider().fillToolTip(parent, text, maxWidth, selection, this.getTitle());
    }

    public void toolTipActivated(ColoredText text) {
        this.toolTipActive = true;
        ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).updateToolTipDependentActions();
    }

    public void toolTipDeactivated(ColoredText text) {
        this.toolTipActive = false;
        ((ThreadViewerEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).updateToolTipDependentActions();
    }

    public boolean isToolTipActive() {
        return this.toolTipActive;
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getSite().getPage().removePartListener((IPartListener)this);
        if (this.text != null) {
            this.text.dispose();
        }
        this.text = null;
        if (this.attributes != null) {
            this.attributes.dispose();
        }
        this.attributes = null;
        super.dispose();
    }

    public boolean canPerformFind() {
        return true;
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        ColoredText.TextPosition off = new ColoredText.TextPosition(this.text.getLineCount() - 1, this.text.getLineAt(this.text.getLineCount() - 1).getTextLength());
        int i = 0;
        while (i < this.text.getLineCount()) {
            int len = this.text.getLineAt(i).getTextLength();
            if (offset < len) {
                off = new ColoredText.TextPosition(i, Math.max(offset, 0));
                break;
            }
            offset -= len;
            ++i;
        }
        return this.text.textPositionToIntPosition(this.text.findAndSelect(off, findString, searchForward, caseSensitive, wholeWord));
    }

    public Point getSelection() {
        ColoredText.TextSelection sel = this.text.getTextSelection();
        int start = this.text.textPositionToIntPosition(sel.from);
        int end = this.text.textPositionToIntPosition(sel.to);
        return new Point(start, end - start);
    }

    public String getSelectionText() {
        ColoredText.TextSelection sel = this.text.getTextSelection();
        return this.text.getText(sel.from, sel.to, false);
    }

    public boolean isEditable() {
        return false;
    }

    public void replaceSelection(String text) {
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this) {
            this.active = true;
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (this.text != null) {
            this.text.disposeToolTip();
        }
        if (part == this && this.active) {
            this.saveScrollPosition();
            this.active = false;
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    static /* synthetic */ void access$14(ThreadViewerEditor threadViewerEditor) {
        threadViewerEditor.loadScrollPosition();
    }

    private class ResponseSelection
    implements ISelection,
    IBBSReference {
        private int responseNumber;
        private final /* synthetic */ ThreadViewerEditor this$0;

        ResponseSelection(ThreadViewerEditor threadViewerEditor, int responseNumber) {
            ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
            threadViewerEditor2.getClass();
            this.this$0 = threadViewerEditor2;
            this.responseNumber = responseNumber;
        }

        public boolean isEmpty() {
            return false;
        }

        public String getName() {
            return this.this$0.getTitle();
        }

        public int getResponseNumber() {
            return this.responseNumber;
        }

        public URL getURL() {
            IThreadContentProvider thread = this.this$0.getContentProvider();
            if (thread == null) {
                return null;
            }
            return thread.getURL();
        }
    }

    private class ResponseReferToolTipTarget
    implements ColoredText.ToolTipTarget {
        private int start;
        private int end;
        private final /* synthetic */ ThreadViewerEditor this$0;

        public ResponseReferToolTipTarget(ThreadViewerEditor threadViewerEditor, int start, int end) {
            ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
            threadViewerEditor2.getClass();
            this.this$0 = threadViewerEditor2;
            this.start = start;
            this.end = end;
        }
    }

    private class SelectionProvider
    implements ISelectionProvider {
        private List selectionChangedListeners;
        private final /* synthetic */ ThreadViewerEditor this$0;

        SelectionProvider(ThreadViewerEditor threadViewerEditor) {
            ThreadViewerEditor threadViewerEditor2 = threadViewerEditor;
            threadViewerEditor2.getClass();
            this.this$0 = threadViewerEditor2;
            this.selectionChangedListeners = new ArrayList();
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.remove(listener);
        }

        public ISelection getSelection() {
            int sel = this.this$0.getSelectedResponseNumber();
            if (sel != -1) {
                return new ResponseSelection(this.this$0, sel);
            }
            return null;
        }

        public void setSelection(ISelection selection) {
            int sel;
            if (selection instanceof IBBSReference && (sel = ((IBBSReference)selection).getResponseNumber()) != -1) {
                this.this$0.scrollTo(sel);
            }
        }

        private void fireSelectionChangedEvent(SelectionChangedEvent e) {
            int i = 0;
            while (i < this.selectionChangedListeners.size()) {
                ((ISelectionChangedListener)this.selectionChangedListeners.get(i)).selectionChanged(e);
                ++i;
            }
        }

        private void fireSelectionChangedEvent(IBBSBoard board) {
            this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection((Object)board)));
        }

        private void fireSelectionChangedEvent(int responseNumber) {
            this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new ResponseSelection(this.this$0, responseNumber)));
        }
    }

    public static class ThreadViewerAttributes
    implements ColoredText.Attributes {
        public static final int COLOR_BODY = 0;
        public static final int COLOR_LINK = 1;
        public static final int COLOR_LINK_CLICKED = 2;
        public static final int COLOR_MARKING = 3;
        public static final int COLOR_NAME = 4;
        public static final int COLOR_MAIL = 5;
        public static final int COLOR_BACKGROUND = 6;
        public static final int FONT_NORMAL = 0;
        public static final int FONT_BOLD = 1;
        private Color[] colors = new Color[7];
        private Font[] fonts = new Font[2];
        private int lineSkip;

        public ThreadViewerAttributes(Device device) {
            this.colors[0] = new Color(device, PreferenceConverter.getColor((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_BODY_COLOR));
            this.colors[1] = new Color(device, PreferenceConverter.getColor((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_LINK_COLOR));
            this.colors[2] = new Color(device, PreferenceConverter.getColor((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_LINK_CLICKED_COLOR));
            this.colors[3] = new Color(device, PreferenceConverter.getColor((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_MARKING_COLOR));
            this.colors[4] = new Color(device, PreferenceConverter.getColor((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_NAME_COLOR));
            this.colors[5] = new Color(device, PreferenceConverter.getColor((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_MAIL_COLOR));
            this.colors[6] = new Color(device, PreferenceConverter.getColor((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_BACKGROUND_COLOR));
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)PREF_NORMAL_FONT);
            this.fonts[0] = new Font(device, fontData);
            this.fonts[1] = new Font(device, new FontData(fontData.getName(), fontData.getHeight(), 1));
            this.lineSkip = MonalipsePlugin.getDefault().getPreferenceStore().getInt(PREF_LINE_HEIGHT);
        }

        public Color getColor(int key) {
            try {
                return this.colors[key];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return this.colors[0];
            }
        }

        public Font getFont(int key) {
            try {
                return this.fonts[key];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return this.fonts[0];
            }
        }

        public int getLineHeight() {
            return this.lineSkip;
        }

        public void dispose() {
            int i = 0;
            while (i < this.colors.length) {
                if (this.colors[i] != null) {
                    this.colors[i].dispose();
                }
                this.colors[i] = null;
                ++i;
            }
            i = 0;
            while (i < this.fonts.length) {
                if (this.fonts[i] != null) {
                    this.fonts[i].dispose();
                }
                this.fonts[i] = null;
                ++i;
            }
        }
    }
}

