/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import monalipse.MonalipsePlugin;
import monalipse.server.IBBSReference;
import monalipse.server.IThreadContentProvider;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class LinkedObject
implements IAdaptable {
    private static final Logger logger = MonalipsePlugin.getLogger();
    private static final ImageData LINK_IMAGE_DATA;
    private static final ImageData WAIT_IMAGE_DATA;
    private static final ImageData ERROR_IMAGE_DATA;
    private static final IndexColorModel INDEX_COLOR_MODEL;
    private static final PaletteData INDEX_PALETTE_DATA;
    public static int IMAGE_SIZE;
    private IThreadContentProvider thread;
    private int responseNumber;
    private URL url;
    private String urlText;
    private IFile file;
    private SoftReference imageDataReference;
    private ImageData imageData;
    private org.eclipse.swt.graphics.Image image;
    private boolean isImage;
    private QualifiedName statusKey;
    static /* synthetic */ Class class$0;

    static {
        IMAGE_SIZE = 64;
        LINK_IMAGE_DATA = LinkedObject.getFittedImage(LinkedObject.getScaledImage(MonalipsePlugin.getDefault().getImageRegistry().get(MonalipsePlugin.IMG_OBJ_LINK).getImageData(), 32), IMAGE_SIZE);
        WAIT_IMAGE_DATA = LinkedObject.getFittedImage(LinkedObject.getScaledImage(MonalipsePlugin.getDefault().getImageRegistry().get(MonalipsePlugin.IMG_OBJ_CLOCK).getImageData(), 32), IMAGE_SIZE);
        ERROR_IMAGE_DATA = LinkedObject.getFittedImage(LinkedObject.getScaledImage(MonalipsePlugin.getDefault().getImageRegistry().get(MonalipsePlugin.IMG_OBJ_DISCONNECT).getImageData(), 32), IMAGE_SIZE);
        int[] colors = new int[256];
        RGB[] rgbs = new RGB[256];
        int r = 0;
        while (r < 6) {
            int g = 0;
            while (g < 6) {
                int b = 0;
                while (b < 6) {
                    int idx = r * 36 + g * 6 + b;
                    colors[idx] = r * 51 << 16 | g * 51 << 8 | b * 51;
                    rgbs[idx] = new RGB(r * 51, g * 51, b * 51);
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        int g = 6;
        int gray = g * 3;
        int i = 216;
        while (i < 256) {
            colors[i] = gray << 16 | gray << 8 | gray;
            rgbs[i] = new RGB(gray, gray, gray);
            gray += g;
            ++i;
        }
        INDEX_COLOR_MODEL = new IndexColorModel(8, 256, colors, 0, false, -1, 0);
        INDEX_PALETTE_DATA = new PaletteData(rgbs);
    }

    public LinkedObject(IThreadContentProvider thread, int responseNumber, URL url) {
        this.thread = thread;
        this.responseNumber = responseNumber;
        this.url = url;
        this.urlText = url.toExternalForm();
        String dir = url.toExternalForm().toLowerCase();
        this.file = thread.getLogFolder().getFolder(String.valueOf(thread.getID()) + ".images").getFile(dir.substring(dir.lastIndexOf(47) + 1, dir.length()));
        this.isImage = LinkedObject.isImage(this.file.getName().toLowerCase());
        this.statusKey = new QualifiedName(this.getClass().getName(), url + ".status");
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkedObject) {
            LinkedObject linked = (LinkedObject)obj;
            return linked.thread.equals(this.thread) && linked.responseNumber == this.responseNumber && linked.urlText.equals(this.urlText);
        }
        return false;
    }

    public int hashCode() {
        return this.urlText.hashCode();
    }

    public boolean isImage() {
        return this.isImage;
    }

    public IThreadContentProvider getThread() {
        return this.thread;
    }

    public int getResponseNumber() {
        return this.responseNumber;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean fetchObject(IWorkbenchWindow workbenchWindow, boolean force) throws SocketTimeoutException, ConnectException, UnknownHostException {
        block24: {
            block22: {
                if (!force) {
                    try {
                        status = this.thread.getLogFile().getPersistentProperty(this.statusKey);
                        if (status != null && status.equals("error")) {
                            this.dispose();
                            return false;
                        }
                    }
                    catch (CoreException v0) {}
                }
                try {
                    MonalipsePlugin.ensureSynchronized(this.file);
                    if (this.file.exists() != false) return false;
                    LinkedObject.logger.finest("begin " + this.url);
                    hc = new HttpClient();
                    hc.setTimeout(10000);
                    get = new GetMethod();
                    get.setRequestHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)");
                    get.setRequestHeader("Referer", this.urlText);
                    get.setRequestHeader("Accept", "image/png, image/jpeg, image/gif, */*");
                    get.setRequestHeader("Accept-Language", "ja");
                    get.setRequestHeader("Accept-Encoding", "gzip");
                    get.setRequestHeader("Accept-Charset", "Shift_JIS, *");
                    get.setPath(this.url.getPath());
                    get.setHttp11(false);
                    hc.startSession(this.url);
                    try {
                        block23: {
                            hc.executeMethod((HttpMethod)get);
                            MonalipsePlugin.log(LinkedObject.logger, (HttpMethod)get);
                            if (get.getStatusLine().getStatusCode() != 200) break block23;
                            LinkedObject.logger.finest("download");
                            in = get.getResponseBodyAsStream();
                            out = new ByteArrayOutputStream();
                            b = new byte[32768];
                            header = 16;
                            i = 0;
                            if (true) ** GOTO lbl63
                        }
                        if (get.getStatusLine().getStatusCode() == 404 || get.getStatusLine().getStatusCode() == 403 || get.getStatusLine().getStatusCode() == 302) {
                            this.thread.getLogFile().setPersistentProperty(this.statusKey, "error");
                            this.dispose();
                        }
                        break block22;
                    }
                    catch (Throwable var15_21) {
                        var14_19 = null;
                        hc.endSession();
                        LinkedObject.logger.finest("done");
                        throw var15_21;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (SocketTimeoutException e) {
                    throw e;
                }
                catch (ConnectException e) {
                    throw e;
                }
                catch (UnknownHostException e) {
                    throw e;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
                do {
                    b[i] = (byte)in.read();
                    ++i;
lbl63:
                    // 2 sources

                } while (i < header);
                LinkedObject.logger.finest("image:" + LinkedObject.isImage(b) + " archive:" + LinkedObject.isArchive(b));
                if (LinkedObject.isImage(b) || LinkedObject.isArchive(b)) break block24;
                this.thread.getLogFile().setPersistentProperty(this.statusKey, "error");
                this.dispose();
            }
            var14_20 = null;
            hc.endSession();
            LinkedObject.logger.finest("done");
            return false;
        }
        out.write(b, 0, header);
        while (true) {
            if ((r = in.read(b)) == -1) {
                out.close();
                LinkedObject.logger.finest("complete");
                mod = 0L;
                ** try [egrp 3[TRYBLOCK] [1 : 416->435)] { 
lbl81:
                // 1 sources

                break;
            }
            out.write(b, 0, r);
        }
        {
            mod = Date.parse(get.getResponseHeader("Last-Modified").getValue());
        }
lbl86:
        // 1 sources

        catch (RuntimeException v1) {}
        lastModified = mod;
        bytes = out.toByteArray();
        MonalipsePlugin.asyncExec(workbenchWindow, (IRunnableWithProgress)new WorkspaceModifyOperation(this, workbenchWindow, bytes, lastModified){
            private final /* synthetic */ IWorkbenchWindow val$workbenchWindow;
            private final /* synthetic */ LinkedObject this$0;
            private final /* synthetic */ byte[] val$bytes;
            private final /* synthetic */ long val$lastModified;
            {
                LinkedObject linkedObject2 = linkedObject;
                linkedObject2.getClass();
                this.this$0 = linkedObject2;
                this.val$workbenchWindow = iWorkbenchWindow;
                this.val$bytes = byArray;
                this.val$lastModified = l;
            }

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    this.createLogFolder(this.val$workbenchWindow, monitor);
                    MonalipsePlugin.ensureSynchronized(this.this$0.file);
                    if (this.this$0.file.exists()) {
                        this.this$0.file.setContents((InputStream)new ByteArrayInputStream(this.val$bytes), false, false, monitor);
                    } else {
                        this.this$0.file.create((InputStream)new ByteArrayInputStream(this.val$bytes), false, monitor);
                    }
                    this.this$0.imageData = null;
                    this.this$0.imageDataReference = null;
                    if (this.val$lastModified != 0L) {
                        this.this$0.file.getLocation().toFile().setLastModified(this.val$lastModified);
                        MonalipsePlugin.ensureSynchronized(this.this$0.file);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }

            private void createLogFolder(IWorkbenchWindow workbenchWindow, IProgressMonitor monitor) {
                this.this$0.thread.getBoard().getServer().createServerFolder(workbenchWindow, monitor);
                this.this$0.thread.getBoard().createLogFolder(workbenchWindow, monitor);
                try {
                    if (!this.this$0.file.getParent().exists()) {
                        ((IFolder)this.this$0.file.getParent()).create(true, true, monitor);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        });
        var14_18 = null;
        hc.endSession();
        LinkedObject.logger.finest("done");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadImage() {
        if (this.imageData != null) return false;
        if (this.imageDataReference != null && this.imageDataReference.get() != null) {
            return false;
        }
        try {
            MonalipsePlugin.ensureSynchronized(this.file);
            if (this.file.exists()) {
                block13: {
                    if (this.isImage) {
                        try {
                            ImageInputStream in;
                            ImageReader reader;
                            block15: {
                                int size = IMAGE_SIZE;
                                String name = this.file.getName();
                                Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(name.substring(name.lastIndexOf(46) + 1, name.length()));
                                if (!readers.hasNext()) break block13;
                                reader = readers.next();
                                in = null;
                                try {
                                    try {
                                        in = ImageIO.createImageInputStream(this.file.getLocation().toFile());
                                        reader.setInput(in);
                                        ImageReadParam param = reader.getDefaultReadParam();
                                        int skip = (int)Math.ceil((double)Math.max(reader.getWidth(0), reader.getHeight(0)) / (double)size);
                                        param.setSourceSubsampling(skip, skip, 0, 0);
                                        BufferedImage image = reader.read(0, param);
                                        BufferedImage indexed = new BufferedImage(size, size, 13, INDEX_COLOR_MODEL);
                                        Graphics2D g = indexed.createGraphics();
                                        g.setColor(Color.white);
                                        g.fillRect(0, 0, size, size);
                                        g.drawImage((Image)image, (size - image.getWidth()) / 2, (size - image.getHeight()) / 2, null);
                                        g.dispose();
                                        ImageData data = new ImageData(size, size, 8, INDEX_PALETTE_DATA, 1, ((DataBufferByte)indexed.getRaster().getDataBuffer()).getData());
                                        this.imageDataReference = new SoftReference<ImageData>(data);
                                        Object var12_17 = null;
                                        reader.dispose();
                                        if (in == null) return true;
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                        break block15;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var12_18 = null;
                                    reader.dispose();
                                    if (in == null) throw throwable;
                                    in.close();
                                    throw throwable;
                                }
                                in.close();
                                return true;
                            }
                            Object var12_19 = null;
                            reader.dispose();
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                String name = this.file.getName();
                this.imageDataReference = new SoftReference<ImageData>(LinkedObject.getImageDataOf(name.substring(name.lastIndexOf(46) + 1, name.length())));
                return true;
            }
            String status = this.thread.getLogFile().getPersistentProperty(this.statusKey);
            if (status != null && status.equals("error")) {
                this.imageData = ERROR_IMAGE_DATA;
                return true;
            }
            this.imageData = LINK_IMAGE_DATA;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public org.eclipse.swt.graphics.Image getImage(Device device) {
        ImageData data;
        Object object = this.imageData == null ? (this.imageDataReference == null ? null : (ImageData)this.imageDataReference.get()) : (data = this.imageData);
        if (this.image == null && data != null) {
            this.image = new org.eclipse.swt.graphics.Image(device, data);
        }
        return this.image;
    }

    public String getName() {
        return this.file.getName();
    }

    public URL getURL() {
        return this.url;
    }

    public String getURLText() {
        return this.urlText;
    }

    public IFile getCachedFile() {
        return this.file;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.server.IBBSReference");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new IBBSReference(this){
                private final /* synthetic */ LinkedObject this$0;
                {
                    LinkedObject linkedObject2 = linkedObject;
                    linkedObject2.getClass();
                    this.this$0 = linkedObject2;
                }

                public String getName() {
                    return this.this$0.thread.getName();
                }

                public URL getURL() {
                    return this.this$0.thread.getURL();
                }

                public int getResponseNumber() {
                    return this.this$0.getResponseNumber();
                }
            };
        }
        return null;
    }

    private static ImageData getImageDataOf(String extension) {
        Program p = Program.findProgram((String)extension);
        if (p != null) {
            return LinkedObject.getFittedImage(LinkedObject.getScaledImage(p.getImageData(), 32), IMAGE_SIZE);
        }
        return null;
    }

    private static ImageData getScaledImage(ImageData data, int size) {
        if (data.width == size && data.height == size) {
            return data;
        }
        double scale = (double)size / (double)Math.max(data.width, data.height);
        data = data.scaledTo((int)((double)data.width * scale), (int)((double)data.height * scale));
        return data;
    }

    private static ImageData getFittedImage(ImageData data, int size) {
        int white;
        if (data.width == size && data.height == size) {
            return data;
        }
        boolean convertColor = false;
        try {
            white = data.palette.getPixel(new RGB(255, 255, 255));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            white = 0xFFFFFF;
            convertColor = true;
        }
        int[] whites = new int[size];
        int[] pixels = new int[size];
        int i = 0;
        while (i < whites.length) {
            whites[i] = white;
            ++i;
        }
        int xoff = (size - data.width) / 2;
        int yoff = (size - data.height) / 2;
        ImageData fit = new ImageData(size, size, convertColor ? 24 : data.depth, convertColor ? new PaletteData(0xFF0000, 65280, 255) : data.palette);
        int i2 = 0;
        while (i2 < yoff) {
            fit.setPixels(0, i2, size, whites, 0);
            ++i2;
        }
        int y = 0;
        while (y < data.height) {
            System.arraycopy(whites, 0, pixels, 0, size);
            if (convertColor && !data.palette.isDirect) {
                int i3 = 0;
                while (i3 < data.width) {
                    RGB rgb = data.palette.colors[data.getPixel(i3, y)];
                    pixels[xoff + i3] = rgb.red << 16 | rgb.green << 8 | rgb.blue;
                    ++i3;
                }
            } else {
                data.getPixels(0, y, data.width, pixels, xoff);
            }
            fit.setPixels(0, yoff + y, size, pixels, 0);
            ++y;
        }
        i2 = yoff + data.height;
        while (i2 < size) {
            fit.setPixels(0, i2, size, whites, 0);
            ++i2;
        }
        return fit;
    }

    public static boolean matches(String fileName) {
        String lc = fileName.toLowerCase();
        return LinkedObject.isImage(lc) || LinkedObject.isArchive(lc);
    }

    private static boolean isImage(String lc) {
        return lc.endsWith(".jpg") || lc.endsWith(".jpeg") || lc.endsWith(".gif") || lc.endsWith(".png") || lc.endsWith(".bmp");
    }

    private static boolean isArchive(String lc) {
        return lc.endsWith(".zip") || lc.endsWith(".lzh") || lc.endsWith(".rar") || lc.endsWith(".gca");
    }

    private static boolean isImage(byte[] b) {
        return b[0] == -1 && b[1] == -40 || b[0] == 71 && b[1] == 73 && b[2] == 70 || b[0] == -119 && b[1] == 80 && b[2] == 78 && b[3] == 71 || b[0] == 66 && b[1] == 77;
    }

    private static boolean isArchive(byte[] b) {
        return b[0] == 80 && b[1] == 75 || b[2] == 45 && b[3] == 76 && b[4] == 72 || b[0] == 82 && b[1] == 97 && b[2] == 114 || b[0] == 71 && b[1] == 67 && b[2] == 65;
    }

    public static LinkedObject[] getChangedNodes(LinkedObject[] objects, IResourceChangeEvent event) {
        HashMap cachedResources = new HashMap();
        int i = 0;
        while (i < objects.length) {
            LinkedObject.addNodeMap(cachedResources, objects[i].file, objects[i]);
            ++i;
        }
        ArrayList list = new ArrayList();
        LinkedObject.nodeModified(7, event.getDelta(), cachedResources, list);
        if (list.size() == 0) {
            return null;
        }
        objects = new LinkedObject[list.size()];
        list.toArray(objects);
        return objects;
    }

    private static void addNodeMap(Map map, Object key, LinkedObject node) {
        List<LinkedObject> list;
        if (map.containsKey(key)) {
            list = (List)map.get(key);
        } else {
            list = new ArrayList();
            map.put(key, list);
        }
        list.add(node);
    }

    private static void nodeModified(int type, IResourceDelta delta, Map cachedResources, List resultNodes) {
        if (delta != null) {
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(type);
            int i = 0;
            while (i < affectedChildren.length) {
                List nodeList;
                IResource res = affectedChildren[i].getResource();
                if (res instanceof IFile && (nodeList = (List)cachedResources.get(res)) != null) {
                    int j = 0;
                    while (j < nodeList.size()) {
                        ((LinkedObject)nodeList.get(j)).dispose();
                        ++j;
                    }
                    resultNodes.addAll(nodeList);
                }
                LinkedObject.nodeModified(type, affectedChildren[i], cachedResources, resultNodes);
                ++i;
            }
        }
    }
}

