/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server;

import java.util.Arrays;
import java.util.Collection;
import monalipse.server.ILinkedLineFragment;
import monalipse.widgets.ColoredText;

public class Response {
    public static final int FRAGMENT_NAME = 1;
    public static final int FRAGMENT_MAIL = 2;
    public static final int FRAGMENT_DATE = 4;
    public static final int FRAGMENT_BODY = 8;
    private HeaderLine header;
    private ColoredText.LineFragment[] name;
    private ColoredText.LineFragment[] mail;
    private ColoredText.LineFragment[] date;
    private ColoredText.Line[] body;
    private String delimiter;
    private String title;

    public Response(int responseNumber, ColoredText.LineFragment[] name, ColoredText.LineFragment[] mail, ColoredText.LineFragment[] date, ColoredText.Line[] body, String delimiter, String title) {
        this.header = new HeaderLine(this, responseNumber);
        this.name = name;
        this.mail = mail;
        this.date = date;
        this.body = body;
        this.delimiter = delimiter;
        this.title = title;
        this.header.addLineFragment(new ColoredText.LineFragment(String.valueOf(responseNumber) + " : ", 0, 0, false));
        this.header.addLineFragments(name);
        this.header.addLineFragment(new ColoredText.LineFragment(" [", 0, 0, false));
        this.header.addLineFragments(mail);
        this.header.addLineFragment(new ColoredText.LineFragment("] ", 0, 0, false));
        this.header.addLineFragments(date);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Response) {
            Response resp = (Response)obj;
            if (this.name.length != resp.name.length || this.mail.length != resp.mail.length || this.date.length != resp.date.length || this.body.length != resp.body.length) {
                return false;
            }
            if (!this.header.getText().equals(resp.header.getText())) {
                return false;
            }
            int i = 0;
            while (i < this.body.length) {
                if (!this.body[i].getText().equals(resp.body[i].getText())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.date.length == 0) {
            return 0;
        }
        return this.date[0].getText().hashCode();
    }

    public void getLines(Collection receiver) {
        receiver.add(this.header);
        receiver.addAll(Arrays.asList(this.body));
    }

    public ColoredText.LineFragment[] getName() {
        return this.name;
    }

    public ColoredText.LineFragment[] getMail() {
        return this.mail;
    }

    public ColoredText.LineFragment[] getDate() {
        return this.date;
    }

    public ColoredText.Line[] getBody() {
        return this.body;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasLink(int fragment, String url) {
        if ((fragment & 1) != 0 && Response.hasLink(this.name, url)) {
            return true;
        }
        if ((fragment & 2) != 0 && Response.hasLink(this.mail, url)) {
            return true;
        }
        if ((fragment & 4) != 0 && Response.hasLink(this.date, url)) {
            return true;
        }
        return (fragment & 8) != 0 && Response.hasLink(this.body, url);
    }

    private static boolean hasLink(ColoredText.Line[] lines, String url) {
        int i = 0;
        while (i < lines.length) {
            ColoredText.Line line = lines[i];
            int j = 0;
            while (j < line.getLineFragmentCount()) {
                ColoredText.LineFragment fragment = line.getLineFragmentAt(j);
                if (fragment instanceof ILinkedLineFragment && ((ILinkedLineFragment)((Object)fragment)).getURL().equals(url)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasLink(ColoredText.LineFragment[] fragments, String url) {
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i] instanceof ILinkedLineFragment && ((ILinkedLineFragment)((Object)fragments[i])).getURL().equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void unmarkNewResponse() {
        Response.unmarkNewResponse(this.header);
        int i = 0;
        while (i < this.body.length) {
            Response.unmarkNewResponse(this.body[i]);
            ++i;
        }
    }

    private static void unmarkNewResponse(ColoredText.Line line) {
        int j = line.getLineFragmentCount() - 1;
        while (j >= 0) {
            ColoredText.LineFragment f = line.getLineFragmentAt(j);
            if (f instanceof INewResponseLineFragment) {
                ((INewResponseLineFragment)((Object)f)).unmark();
            }
            --j;
        }
    }

    public class HeaderLine
    extends ColoredText.Line {
        private int responseNumber;
        private final /* synthetic */ Response this$0;

        public HeaderLine(Response response, int responseNumber) {
            Response response2 = response;
            response2.getClass();
            this.this$0 = response2;
            super(0);
            this.responseNumber = responseNumber;
        }

        public int getReponseNumber() {
            return this.responseNumber;
        }

        public Response getResponse() {
            return this.this$0;
        }

        private void addLineFragments(ColoredText.LineFragment[] fragments) {
            int i = 0;
            while (i < fragments.length) {
                this.addLineFragment(fragments[i]);
                ++i;
            }
        }
    }

    public static interface INewResponseLineFragment {
        public void unmark();
    }
}

