/*
 * Decompiled with CFR 0.152.
 */
package monalipse.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import monalipse.MonalipsePlugin;
import monalipse.actions.BookmarkAction;
import monalipse.bookmark.BookmarkManager;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.IBBSReference;
import monalipse.server.IBBSServer;
import monalipse.server.IBoardTreeNode;
import monalipse.server.nullserver.NullServer;
import monalipse.utils.CancelableRunner;
import monalipse.views.AbstractTreeView;
import monalipse.views.ThreadListView;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public class BoardListView
extends AbstractTreeView
implements SelectionListener,
IResourceChangeListener {
    public static final String ID_BOARD_LIST;
    private static final Logger logger;
    private TreeViewer viewer;
    private IBBSServer server;
    private BoardListContentProvider provider;
    private CancelableRunner cancelable;
    private IAction reloadAction;
    private IAction abortAction;
    private IAction doubleClickAction;
    private BookmarkAction bookmarkAction;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.BoardListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_BOARD_LIST = clazz.getName();
        logger = MonalipsePlugin.getLogger();
    }

    public BoardListView() {
        logger.finest("<init>");
    }

    protected ITreeContentProvider getContentProvider() {
        return this.provider;
    }

    protected ILabelProvider getLabelProvider() {
        return this.provider;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        logger.finest("begin");
        String target = this.getConfigurationElement().getAttribute("target");
        logger.finest("target: " + target);
        this.server = BBSServerManager.getInstanceOf(target);
        logger.finest("server: " + target);
        if (this.server == null) {
            this.server = new NullServer(target);
        }
        this.viewer = new TreeViewer(parent, 772);
        this.provider = new BoardListContentProvider(this);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.viewer.setInput((Object)this.getServer());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.viewer.getTree().addSelectionListener((SelectionListener)this);
        this.partCreated();
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(this){
            private final /* synthetic */ BoardListView this$0;
            {
                BoardListView boardListView2 = boardListView;
                ((Object)((Object)boardListView2)).getClass();
                this.this$0 = boardListView2;
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    this.this$0.reloadAction.run();
                }
            }
        });
        if (this.provider.getElements(this.viewer.getInput()).length == 0) {
            logger.finest("empty board tree");
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                private final /* synthetic */ BoardListView this$0;
                {
                    BoardListView boardListView2 = boardListView;
                    ((Object)((Object)boardListView2)).getClass();
                    this.this$0 = boardListView2;
                }

                public void run() {
                    logger.finest("activate");
                    this.this$0.getSite().getPage().activate((IWorkbenchPart)this.this$0);
                    this.this$0.reloadAction.run();
                }
            });
        }
        logger.finest("done");
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public IBBSServer getServer() {
        return this.server;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        logger.finest("begin");
        if (this.getServer().boardListChanged(event) || MonalipsePlugin.projectModified(event.getDelta())) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.views.BoardListView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)clazz.getName());
            this.saveState((IMemento)memento);
            logger.finest("reset input");
            this.viewer.setInput((Object)this.getServer());
            this.restoreState((IMemento)memento);
        }
        if (BookmarkManager.bookmarkChanged(event)) {
            this.viewer.refresh(true);
        }
        logger.finest("done");
    }

    public void widgetSelected(SelectionEvent e) {
        this.bookmarkAction.updateState(this.getSite().getWorkbenchWindow(), this.viewer.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(this){
            private final /* synthetic */ BoardListView this$0;
            {
                BoardListView boardListView2 = boardListView;
                ((Object)((Object)boardListView2)).getClass();
                this.this$0 = boardListView2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.this$0.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalStatusBar(bars.getStatusLineManager());
    }

    private void fillLocalStatusBar(IStatusLineManager manager) {
        this.cancelable = new CancelableRunner(manager, this.getSite().getShell().getDisplay(), this.abortAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.reloadAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.abortAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        this.bookmarkAction.updateState(this.getSite().getWorkbenchWindow(), this.viewer.getSelection());
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.bookmarkAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
    }

    private void makeActions() {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)"monalipse").getDescriptor().getInstallURL();
        this.reloadAction = new Action(this){
            private final /* synthetic */ BoardListView this$0;
            {
                BoardListView boardListView2 = boardListView;
                ((Object)((Object)boardListView2)).getClass();
                this.this$0 = boardListView2;
            }

            public void run() {
                this.this$0.cancelable.run(this.this$0.cancelable, new CancelableRunner.ICancelableRunnableWithProgress(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        4 v0 = var1_1;
                        ((Object)((Object)v0)).getClass();
                        this.this$1 = v0;
                    }

                    public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                        BoardListView.access$1().finest("refresh");
                        4.access$0(this.this$1).getServer().updateBoardList(4.access$0(this.this$1).getSite().getWorkbenchWindow());
                    }
                });
            }

            static /* synthetic */ BoardListView access$0(4 var0) {
                return var0.this$0;
            }
        };
        this.reloadAction.setText("Reload");
        this.reloadAction.setToolTipText("Reload board list");
        try {
            this.reloadAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "refresh_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.abortAction = new Action(this){
            private final /* synthetic */ BoardListView this$0;
            {
                BoardListView boardListView2 = boardListView;
                ((Object)((Object)boardListView2)).getClass();
                this.this$0 = boardListView2;
            }

            public void run() {
                this.this$0.cancelable.cancel();
            }
        };
        this.abortAction.setText("Abort");
        this.abortAction.setToolTipText("Abort downloading board list");
        this.abortAction.setEnabled(false);
        try {
            this.abortAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "stop_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.doubleClickAction = new Action(this){
            private final /* synthetic */ BoardListView this$0;
            {
                BoardListView boardListView2 = boardListView;
                ((Object)((Object)boardListView2)).getClass();
                this.this$0 = boardListView2;
            }

            public void run() {
                ISelection selection = this.this$0.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object first = ((IStructuredSelection)selection).getFirstElement();
                    if (first instanceof IBBSBoard) {
                        this.this$0.cancelable.run(this.this$0.cancelable, new CancelableRunner.ICancelableRunnableWithProgress(this, first){
                            private final /* synthetic */ Object val$first;
                            private final /* synthetic */ 7 this$1;
                            {
                                7 v0 = var1_1;
                                ((Object)((Object)v0)).getClass();
                                this.this$1 = v0;
                                this.val$first = object;
                            }

                            public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                                BoardListView.access$1().finest("begin");
                                ((IBBSBoard)this.val$first).updateThreadList(7.access$0(this.this$1).getSite().getWorkbenchWindow());
                                BoardListView.access$1().finest("done");
                            }
                        });
                        IWorkbenchPage page = this.this$0.getSite().getPage().getWorkbenchWindow().getActivePage();
                        try {
                            logger.finest("openView");
                            page.showView(ThreadListView.ID_THREAD_LIST);
                        }
                        catch (PartInitException ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        this.this$0.viewer.setExpandedState(first, !this.this$0.viewer.getExpandedState(first));
                    }
                }
            }

            static /* synthetic */ BoardListView access$0(7 var0) {
                return var0.this$0;
            }
        };
        this.bookmarkAction = new BookmarkAction();
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(this){
            private final /* synthetic */ BoardListView this$0;
            {
                BoardListView boardListView2 = boardListView;
                ((Object)((Object)boardListView2)).getClass();
                this.this$0 = boardListView2;
            }

            public void doubleClick(DoubleClickEvent event) {
                this.this$0.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private class NameSorter
    extends ViewerSorter {
        private final /* synthetic */ BoardListView this$0;

        NameSorter(BoardListView boardListView) {
            BoardListView boardListView2 = boardListView;
            ((Object)((Object)boardListView2)).getClass();
            this.this$0 = boardListView2;
        }
    }

    private class BoardListContentProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private final /* synthetic */ BoardListView this$0;

        BoardListContentProvider(BoardListView boardListView) {
            BoardListView boardListView2 = boardListView;
            ((Object)((Object)boardListView2)).getClass();
            this.this$0 = boardListView2;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IBBSServer) {
                return ((IBBSServer)inputElement).getBoardTree().getChildren();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IBoardTreeNode) {
                return ((IBoardTreeNode)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IBoardTreeNode) {
                return ((IBoardTreeNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IBoardTreeNode) {
                return ((IBoardTreeNode)element).hasChildren();
            }
            if (element instanceof IBBSServer) {
                return ((IBBSServer)element).getBoardTree().hasChildren();
            }
            return false;
        }

        public Image getImage(Object element) {
            if (this.hasChildren(element)) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (element instanceof IBBSReference) {
                return MonalipsePlugin.getDefault().getLabelImageOf((IBBSReference)element);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IBoardTreeNode) {
                return ((IBoardTreeNode)element).getName();
            }
            return "";
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

