/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ContentLengthInputStream
extends FilterInputStream {
    private int contentLength;
    private int pos = 0;

    public ContentLengthInputStream(InputStream in, int contentLength) {
        super(in);
        this.contentLength = contentLength;
    }

    public int read() throws IOException {
        if (this.pos >= this.contentLength) {
            return -1;
        }
        ++this.pos;
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.contentLength) {
            return -1;
        }
        if (this.pos + len > this.contentLength) {
            len = this.contentLength - this.pos;
        }
        int count = super.read(b, off, len);
        this.pos += count;
        return count;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

