/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.net.URL;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectMethod;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClient {
    private static final Log log;
    private HttpConnection connection = null;
    private HttpState state;
    private SSLSocketFactory sslSocketFactory = null;
    private int timeoutInMilliseconds = 0;
    private int connectionTimeout = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.HttpClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public HttpState getState() {
        if (this.state == null) {
            this.state = new HttpState();
        }
        return this.state;
    }

    public void setState(HttpState state) {
        this.state = state;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setTimeout(int newTimeoutInMilliseconds) {
        this.timeoutInMilliseconds = newTimeoutInMilliseconds;
    }

    public void setConnectionTimeout(int newTimeoutInMilliseconds) {
        this.connectionTimeout = newTimeoutInMilliseconds;
    }

    public void startSession(String host, int port) {
        log.trace((Object)"enter HttpClient.startSession(String, int)");
        this.startSession(host, port, false);
    }

    public void startSession(String host, int port, boolean https) {
        log.trace((Object)"enter HttpClient.startSession(String, int, boolean)");
        if (log.isDebugEnabled()) {
            log.debug((Object)("HttpClient.startSession(String,int,boolean): Host:" + host + " Port:" + port + " HTTPS:" + https));
        }
        this.connection = new HttpConnection(host, port, https);
    }

    public void startSession(String host, int port, Credentials creds) {
        log.trace((Object)"enter HttpClient.startSession(String, int, Credentials)");
        this.startSession(host, port, creds, false);
    }

    public void startSession(String host, int port, Credentials creds, boolean https) {
        log.trace((Object)"enter HttpClient.startSession(String, int, Credentials, boolean)");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting HttpClient session Host:" + host + " Port:" + port + " Credentials:" + creds + " HTTPS:" + https));
        }
        this.getState().setCredentials(null, creds);
        this.connection = new HttpConnection(host, port, https);
    }

    public void startSession(URI uri) throws URIException {
        String host;
        boolean secure;
        log.trace((Object)"enter HttpClient.startSession(URI)");
        String scheme = uri.getScheme();
        if (scheme == null) {
            log.error((Object)"no scheme to start a session");
            throw new IllegalStateException("no scheme to start a session");
        }
        boolean bl = secure = scheme.equalsIgnoreCase("https");
        if (!secure && !scheme.equalsIgnoreCase("http")) {
            log.error((Object)"http and https scheme only supported");
            throw new IllegalStateException("http and https scheme only supported");
        }
        String userinfo = uri.getUserinfo();
        if (userinfo != null) {
            this.getState().setCredentials(null, new UsernamePasswordCredentials(userinfo));
        }
        if ((host = uri.getHost()) == null || host.length() == 0) {
            log.error((Object)"no host to start a session");
            throw new IllegalStateException("no host to start a session");
        }
        int port = uri.getPort();
        if (port == -1) {
            log.error((Object)"HttpURL or HttpsURL instance required");
            throw new IllegalStateException("HttpURL or HttpsURL instance required");
        }
        this.connection = new HttpConnection(host, port, secure);
    }

    public void startSession(URL url) {
        log.trace((Object)"enter HttpClient.startSession(String, int, Credentials, boolean)");
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            this.startSession(url.getHost(), url.getPort() == -1 ? 443 : url.getPort(), true);
        } else if ("http".equalsIgnoreCase(url.getProtocol())) {
            this.startSession(url.getHost(), url.getPort() == -1 ? 80 : url.getPort(), false);
        } else {
            throw new IllegalArgumentException("Protocol " + url.getProtocol() + " not supported in URL " + url);
        }
    }

    public void startSession(URL url, Credentials creds) {
        log.trace((Object)"enter HttpClient.startSession(URL, Credentials)");
        this.getState().setCredentials(null, creds);
        this.startSession(url);
    }

    public void startSession(String host, int port, String proxyhost, int proxyport) {
        log.trace((Object)"enter HttpClient.startSession(String, int, String, int)");
        this.startSession(host, port, proxyhost, proxyport, false);
    }

    public void startSession(String host, int port, String proxyhost, int proxyport, boolean secure) {
        log.trace((Object)"enter HttpClient.startSession(String, int, String, int, boolean)");
        this.connection = new HttpConnection(proxyhost, proxyport, host, port, secure);
    }

    public synchronized int executeMethod(HttpMethod method) throws IOException, HttpException, IllegalStateException {
        log.trace((Object)"enter HttpClient.executeMethod(HttpMethod)");
        if (method == null) {
            throw new NullPointerException("HttpMethod parameter");
        }
        if (this.connection == null) {
            throw new IllegalStateException("The startSession method must be called before executeMethod");
        }
        if (!this.connection.isOpen()) {
            this.connection.setSSLSocketFactory(this.sslSocketFactory);
            this.connection.setSoTimeout(this.timeoutInMilliseconds);
            this.connection.setConnectionTimeout(this.connectionTimeout);
            this.connection.open();
            if (this.connection.isProxied() && this.connection.isSecure()) {
                method = new ConnectMethod(method);
            }
        }
        return method.execute(this.getState(), this.connection);
    }

    public void endSession() throws IOException {
        log.trace((Object)"enter HttpClient.endSession()");
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public String getHost() {
        return this.connection != null ? this.connection.getHost() : null;
    }

    public int getPort() {
        return this.connection != null ? this.connection.getPort() : -1;
    }
}

