/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpConnectionManager {
    private static final Log log;
    private Map mapHosts = new HashMap();
    private Map mapNumConnections = new HashMap();
    private int maxConnections = 2;
    private String proxyHost = null;
    private int proxyPort = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.HttpConnectionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setMaxConnectionsPerHost(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnections;
    }

    public HttpConnection getConnection(String sURL) throws HttpException, MalformedURLException {
        return this.getConnection(sURL, 0L);
    }

    private static int getPort(String protocol, int port) {
        log.trace((Object)"HttpConnectionManager.getPort(String, port)");
        int portForProtocol = port;
        if (portForProtocol == -1) {
            portForProtocol = protocol.equalsIgnoreCase("HTTPS") ? 443 : 80;
        }
        return portForProtocol;
    }

    public HttpConnection getConnection(String sURL, long timeout) throws HttpException, MalformedURLException {
        log.trace((Object)"enter HttpConnectionManager.getConnection(String, long)");
        if (sURL == null) {
            throw new MalformedURLException("URL is null");
        }
        URL url = new URL(sURL);
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = HttpConnectionManager.getPort(protocol, url.getPort());
        String hostAndPort = String.valueOf(host) + ":" + port;
        if (log.isDebugEnabled()) {
            log.debug((Object)("HttpConnectionManager.getConnection:  key = " + hostAndPort));
        }
        LinkedList listConnections = this.getConnections(hostAndPort);
        HttpConnection conn = null;
        LinkedList linkedList = listConnections;
        synchronized (linkedList) {
            if (listConnections.size() > 0) {
                conn = (HttpConnection)listConnections.removeFirst();
            } else {
                Integer numConnections = this.getConnectionsInUse(hostAndPort);
                if (numConnections < this.maxConnections) {
                    boolean isSecure = protocol.equalsIgnoreCase("HTTPS");
                    conn = new HttpConnection(this.proxyHost, this.proxyPort, host, port, isSecure);
                    numConnections = new Integer(numConnections + 1);
                    this.mapNumConnections.put(hostAndPort, numConnections);
                } else {
                    conn = this.waitForConnection(listConnections, timeout);
                }
            }
        }
        return conn;
    }

    private LinkedList getConnections(String hostAndPort) {
        log.trace((Object)"enter HttpConnectionManager.getConnections(String)");
        LinkedList listConnections = null;
        Map map = this.mapHosts;
        synchronized (map) {
            listConnections = (LinkedList)this.mapHosts.get(hostAndPort);
            if (listConnections == null) {
                listConnections = new LinkedList();
                this.mapHosts.put(hostAndPort, listConnections);
                this.mapNumConnections.put(hostAndPort, new Integer(0));
            }
        }
        return listConnections;
    }

    public Integer getConnectionsInUse(String hostAndPort) {
        log.trace((Object)"enter HttpConnectionManager.getConnectionsInUse(String)");
        Integer numConnections = (Integer)this.mapNumConnections.get(hostAndPort);
        if (numConnections == null) {
            log.error((Object)("HttpConnectionManager.getConnection:  No connection count for " + hostAndPort));
            numConnections = new Integer(0);
            this.mapNumConnections.put(hostAndPort, numConnections);
        }
        return numConnections;
    }

    private HttpConnection waitForConnection(LinkedList pool, long timeout) throws HttpException {
        log.trace((Object)"enter HttpConnectionManager.waitForConnection(LinkedList, long)");
        TimeoutThread threadTimeout = new TimeoutThread();
        threadTimeout.setTimeout(timeout);
        threadTimeout.setWakeupThread(Thread.currentThread());
        threadTimeout.start();
        HttpConnection conn = null;
        while (conn == null) {
            try {
                log.debug((Object)("HttpConnectionManager.getConnection:  waiting for connection from " + pool));
                pool.wait();
            }
            catch (InterruptedException e) {
                throw new HttpException("Timeout waiting for connection.");
            }
            if (pool.size() <= 0) continue;
            conn = (HttpConnection)pool.removeFirst();
            threadTimeout.interrupt();
        }
        return conn;
    }

    public void releaseConnection(HttpConnection conn) {
        log.trace((Object)"enter HttpConnectionManager.releaseConnection(HttpConnection)");
        String host = conn.getHost();
        int port = conn.getPort();
        String key = String.valueOf(host) + ":" + port;
        if (log.isDebugEnabled()) {
            log.debug((Object)("HttpConnectionManager.releaseConnection:  Release connection for " + host + ":" + port));
        }
        LinkedList<HttpConnection> listConnections = null;
        Object object = this.mapHosts;
        synchronized (object) {
            listConnections = (LinkedList<HttpConnection>)this.mapHosts.get(key);
            if (listConnections == null) {
                log.error((Object)("HttpConnectionManager.releaseConnection:  No connect list for " + key));
                listConnections = new LinkedList<HttpConnection>();
                this.mapHosts.put(key, listConnections);
                this.mapNumConnections.put(key, new Integer(1));
            }
        }
        object = listConnections;
        synchronized (object) {
            listConnections.addFirst(conn);
            listConnections.notify();
        }
    }

    private static class TimeoutThread
    extends Thread {
        private long timeout = 0L;
        private Thread thrdWakeup = null;

        TimeoutThread() {
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setWakeupThread(Thread thrdWakeup) {
            this.thrdWakeup = thrdWakeup;
        }

        public Thread getWakeupThread() {
            return this.thrdWakeup;
        }

        public void run() {
            log.trace((Object)"TimeoutThread.run()");
            if (this.timeout == 0L) {
                return;
            }
            if (this.thrdWakeup == null) {
                return;
            }
            try {
                Thread.sleep(this.timeout);
                this.thrdWakeup.interrupt();
            }
            catch (InterruptedException e) {
                log.debug((Object)"InterruptedException caught as expected");
            }
        }
    }
}

