/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Authenticator;
import org.apache.commons.httpclient.AutoCloseInputStream;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.WireLogInputStream;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HttpMethodBase
implements HttpMethod {
    private static int maxForwards = 100;
    private static final Log log;
    private static final Log wireLog;
    protected static final Header USER_AGENT;
    private Map requestHeaders = new HashMap();
    private StatusLine statusLine = null;
    private Map responseHeaders = new HashMap();
    private Map responseFooters = null;
    private Set realms = null;
    private Set proxyRealms = null;
    private String path = null;
    private String queryString = null;
    private InputStream responseStream = null;
    private byte[] responseBody = null;
    private boolean bodySent = false;
    private boolean followRedirects = false;
    private boolean doAuthentication = true;
    private boolean http11 = true;
    private boolean strictMode = false;
    private boolean used = false;
    private int maxRetries = 3;
    protected static final String DEFAULT_CHARSET = "ISO-8859-1";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.HttpMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        wireLog = LogFactory.getLog((String)"httpclient.wire");
        String agent = System.getProperties().getProperty("httpclient.useragent", "Jakarta Commons-HttpClient/2.0M1");
        USER_AGENT = new Header("User-Agent", agent);
    }

    public HttpMethodBase() {
    }

    public HttpMethodBase(String path) {
        int pa = path.indexOf("?");
        if (pa < 0) {
            this.setPath(path);
        } else {
            this.setPath(path.substring(0, pa));
            this.setQueryString(path.substring(pa + 1, path.length()));
        }
    }

    public abstract String getName();

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setHttp11(boolean http11) {
        this.http11 = http11;
    }

    public boolean getDoAuthentication() {
        return this.doAuthentication;
    }

    public void setDoAuthentication(boolean doAuthentication) {
        this.doAuthentication = doAuthentication;
    }

    public boolean isHttp11() {
        return this.http11;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addRequestHeader(Header header) {
        log.trace((Object)"HttpMethodBase.addRequestHeader(Header)");
        if (header == null) {
            log.debug((Object)"null header value ignored");
        } else {
            this.addRequestHeader(header.getName(), header.getValue());
        }
    }

    public void addResponseFooter(Header footer) {
        if (this.responseFooters == null) {
            this.responseFooters = new HashMap();
        }
        this.responseFooters.put(footer.getName().toLowerCase(), footer);
    }

    public String getPath() {
        return this.path == null || this.path.equals("") ? "/" : this.path;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setQueryString(NameValuePair[] params) {
        log.trace((Object)"enter HttpMethodBase.setQueryString(NameValuePair[])");
        StringBuffer buf = new StringBuffer();
        boolean needAmp = false;
        int i = 0;
        while (i < params.length) {
            if (params[i].getName() != null) {
                if (needAmp) {
                    buf.append("&");
                } else {
                    needAmp = true;
                }
                String queryName = null;
                try {
                    queryName = URIUtil.encodeWithinQuery(params[i].getName());
                }
                catch (URIException urie) {
                    log.error((Object)"encoding error within query name", (Throwable)urie);
                    queryName = params[i].getName();
                }
                buf.append(queryName).append("=");
                if (params[i].getValue() != null) {
                    String queryValue = null;
                    try {
                        queryValue = URIUtil.encodeWithinQuery(params[i].getValue());
                    }
                    catch (URIException urie) {
                        log.error((Object)"encoding error within query value", (Throwable)urie);
                        queryValue = params[i].getValue();
                    }
                    buf.append(queryValue);
                }
            }
            ++i;
        }
        this.queryString = buf.toString();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setRequestHeader(String headerName, String headerValue) {
        Header header = new Header(headerName, headerValue);
        this.setRequestHeader(header);
    }

    public void setRequestHeader(Header header) {
        this.requestHeaders.put(header.getName().toLowerCase(), header);
    }

    public Header getRequestHeader(String headerName) {
        return headerName == null ? null : (Header)this.requestHeaders.get(headerName.toLowerCase());
    }

    public Header[] getRequestHeaders() {
        return this.requestHeaders.values().toArray(new Header[this.requestHeaders.size()]);
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    private boolean responseAvailable() {
        return this.responseBody != null || this.responseStream != null;
    }

    public Header[] getResponseHeaders() {
        return this.responseHeaders.values().toArray(new Header[this.responseHeaders.size()]);
    }

    public Header getResponseHeader(String headerName) {
        return headerName == null ? null : (Header)this.responseHeaders.get(headerName.toLowerCase());
    }

    public byte[] getResponseBody() {
        if (this.responseBody == null) {
            try {
                int len;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                InputStream is = this.getResponseBodyAsStream();
                byte[] buffer = new byte[10000];
                while ((len = is.read(buffer)) > 0) {
                    os.write(buffer, 0, len);
                }
                this.responseBody = os.toByteArray();
                this.setResponseStream(null);
                log.debug((Object)"buffering response body");
            }
            catch (IOException e) {
                log.error((Object)"getResponseBody failed", (Throwable)e);
                this.responseBody = null;
            }
        }
        return this.responseBody;
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        if (this.responseStream != null) {
            return this.responseStream;
        }
        if (this.responseBody != null) {
            this.responseStream = new ByteArrayInputStream(this.responseBody);
            log.debug((Object)"re-creating response stream from byte array");
            return this.responseStream;
        }
        return null;
    }

    public String getResponseBodyAsString() {
        String body;
        if (!this.responseAvailable()) {
            return null;
        }
        try {
            body = new String(this.getResponseBody(), this.getResponseCharSet());
        }
        catch (UnsupportedEncodingException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unsupported request body charset: " + e.getMessage()));
            }
            body = new String(this.getResponseBody());
        }
        return body;
    }

    public Header[] getResponseFooters() {
        if (this.responseFooters == null) {
            return null;
        }
        return this.responseFooters.values().toArray(new Header[this.responseFooters.size()]);
    }

    public Header getResponseFooter(String footerName) {
        if (this.responseFooters == null) {
            return null;
        }
        return footerName == null ? null : (Header)this.responseFooters.get(footerName.toLowerCase());
    }

    protected void setResponseStream(InputStream responseStream) {
        this.responseStream = responseStream;
    }

    public String getStatusText() {
        return this.statusLine.getReasonPhrase();
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void addRequestHeader(String headerName, String headerValue) {
        Header header = this.getRequestHeader(headerName);
        if (header == null) {
            header = new Header(headerName, headerValue);
        } else {
            header.setValue(this.getNewHeaderValue(header, headerValue));
        }
        this.setRequestHeader(header);
    }

    private void closeConnection(HttpConnection connection) {
        if (this.shouldCloseConnection()) {
            connection.close();
        }
    }

    private boolean shouldCloseConnection() {
        if (!this.http11) {
            if (this.getName().equals("CONNECT") && this.statusLine.getStatusCode() == 200) {
                log.debug((Object)"Will leave connection open for tunneling");
                return false;
            }
            log.debug((Object)"Should close connection since using HTTP/1.0, ConnectMethod and status is OK");
            return true;
        }
        Header connectionHeader = this.getResponseHeader("connection");
        if (connectionHeader != null && "close".equalsIgnoreCase(connectionHeader.getValue())) {
            log.debug((Object)"Should close connection since \"Connection: close\" header found.");
            return true;
        }
        return false;
    }

    public int execute(HttpState state, HttpConnection conn) throws HttpException, IOException, NullPointerException {
        log.trace((Object)"enter HttpMethodBase.execute(HttpState, HttpConnection)");
        if (state == null) {
            throw new NullPointerException("HttpState parameter");
        }
        if (conn == null) {
            throw new NullPointerException("HttpConnection parameter");
        }
        if (this.hasBeenUsed()) {
            throw new HttpException("Already used, but not recycled.");
        }
        if (!this.validate()) {
            throw new HttpException("Not valid");
        }
        Authenticator.authenticate(this, state);
        if (conn.isProxied()) {
            Authenticator.authenticateProxy(this, state);
        }
        this.realms = new HashSet();
        this.proxyRealms = new HashSet();
        int forwardCount = 0;
        while (forwardCount++ < maxForwards) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Execute loop try " + forwardCount));
            }
            this.processRequest(state, conn);
            this.writeRemainingRequestBody(state, conn);
            int statusCode = this.statusLine.getStatusCode();
            switch (statusCode) {
                case 401: 
                case 407: {
                    log.debug((Object)"Authorization required");
                    if (this.doAuthentication) {
                        if (!this.processAuthenticationResponse(state, conn)) break;
                        return statusCode;
                    }
                    return statusCode;
                }
                case 301: 
                case 302: 
                case 307: {
                    log.debug((Object)"Redirect required");
                    if (this.processRedirectResponse(state, conn)) break;
                    return statusCode;
                }
                default: {
                    return statusCode;
                }
            }
            this.closeConnection(conn);
            if (!conn.isOpen()) continue;
            this.getResponseBodyAsString();
        }
        log.error((Object)"Narrowly avoided an infinite loop in execute");
        throw new HttpRecoverableException("Maximum redirects (" + maxForwards + ") exceeded");
    }

    private boolean processRedirectResponse(HttpState state, HttpConnection conn) {
        if (!this.getFollowRedirects()) {
            log.info((Object)"Redirect requested but followRedirects is disabled");
            return false;
        }
        Header locationHeader = this.getResponseHeader("location");
        if (locationHeader == null) {
            log.error((Object)("Received redirect response " + this.getStatusCode() + " but no location header"));
            return false;
        }
        String location = locationHeader.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirect requested to location '" + location + "'"));
        }
        URL redirectUrl = null;
        URL currentUrl = null;
        try {
            currentUrl = new URL(conn.getProtocol().toLowerCase(), conn.getHost(), conn.getPort(), "");
            redirectUrl = new URL(location);
        }
        catch (MalformedURLException e) {
            if (this.isStrictMode()) {
                log.warn((Object)("Redirected location '" + location + "' is not acceptable in strict mode"));
                return false;
            }
            try {
                log.debug((Object)"Redirect URL is not absolute - parsing as relative");
                redirectUrl = new URL(currentUrl, location);
            }
            catch (MalformedURLException ex) {
                log.warn((Object)("Redirected location '" + location + "' is malformed"));
                return false;
            }
        }
        try {
            HttpMethodBase.checkValidRedirect(currentUrl, redirectUrl);
        }
        catch (HttpException ex) {
            log.warn((Object)ex.getMessage());
            return false;
        }
        this.setPath(redirectUrl.getPath());
        this.setQueryString(redirectUrl.getQuery());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting from '" + currentUrl.toExternalForm() + "' to '" + redirectUrl.toExternalForm()));
        }
        return true;
    }

    private static void checkValidRedirect(URL currentUrl, URL redirectUrl) throws HttpException {
        int newPort;
        String newHost;
        log.trace((Object)"enter HttpMethodBase.checkValidRedirect(HttpConnection, URL)");
        String oldProtocol = currentUrl.getProtocol();
        String newProtocol = redirectUrl.getProtocol();
        if (!oldProtocol.equals(newProtocol)) {
            throw new HttpException("Redirect from protocol " + oldProtocol + " to " + newProtocol + " is not supported");
        }
        String oldHost = currentUrl.getHost();
        if (!oldHost.equalsIgnoreCase(newHost = redirectUrl.getHost())) {
            throw new HttpException("Redirect from host " + oldHost + " to " + newHost + " is not supported");
        }
        int oldPort = currentUrl.getPort();
        if (oldPort < 0) {
            oldPort = HttpMethodBase.getDefaultPort(oldProtocol);
        }
        if ((newPort = redirectUrl.getPort()) < 0) {
            newPort = HttpMethodBase.getDefaultPort(newProtocol);
        }
        if (oldPort != newPort) {
            throw new HttpException("Redirect from port " + oldPort + " to " + newPort + " is not supported");
        }
    }

    private static int getDefaultPort(String protocol) {
        String proto = protocol.toLowerCase().trim();
        if (proto.equals("http")) {
            return 80;
        }
        if (proto.equals("https")) {
            return 443;
        }
        return -1;
    }

    public boolean hasBeenUsed() {
        return this.used;
    }

    public void recycle() {
        log.trace((Object)"enter HttpMethodBase.recycle()");
        this.path = null;
        this.followRedirects = false;
        this.doAuthentication = true;
        this.queryString = null;
        this.requestHeaders.clear();
        this.responseHeaders.clear();
        this.statusLine = null;
        this.used = false;
        this.http11 = true;
        this.bodySent = false;
        this.responseBody = null;
    }

    public void removeRequestHeader(String headerName) {
        this.requestHeaders.remove(headerName.toLowerCase());
    }

    public boolean validate() {
        return true;
    }

    protected int getRequestContentLength() {
        return 0;
    }

    protected void addAuthorizationRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        Header wwwAuthenticateHeader;
        log.trace((Object)"enter HttpMethodBase.addAuthorizationRequestHeader(HttpState, HttpConnection)");
        if (this.getRequestHeader("Authorization") == null && (wwwAuthenticateHeader = this.getResponseHeader("WWW-Authenticate")) != null) {
            try {
                Authenticator.authenticate(this, state);
            }
            catch (HttpException httpException) {
                // empty catch block
            }
        }
    }

    protected void addContentLengthRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter HttpMethodBase.addContentLengthRequestHeader(HttpState, HttpConnection)");
        int len = this.getRequestContentLength();
        if (this.getRequestHeader("content-length") == null) {
            if (len > 0) {
                this.setRequestHeader("Content-Length", String.valueOf(len));
            } else if (this.http11 && len < 0) {
                this.setRequestHeader("Transfer-Encoding", "chunked");
            }
        }
    }

    protected void addCookieRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter HttpMethodBase.addCookieRequestHeader(HttpState, HttpConnection)");
        Header cookieHeader = Cookie.createCookieHeader(conn.getHost(), conn.getPort(), this.getPath(), conn.isSecure(), new Date(), state.getCookies());
        if (cookieHeader != null) {
            this.setRequestHeader(cookieHeader);
        }
    }

    protected void addHostRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter HttpMethodBase.addHostRequestHeader(HttpState, HttpConnection)");
        String host = conn.getHost();
        int port = conn.getPort();
        if (this.getRequestHeader("host") != null) {
            log.debug((Object)"Request to add Host header ignored: header already added");
            return;
        }
        if (HttpMethodBase.isIpAddress(host)) {
            log.debug((Object)"Adding empty Host request header: host is an ipaddress");
            this.setRequestHeader("Host", "");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding Host request header");
        }
        if (conn.isSecure()) {
            this.setRequestHeader("Host", port == 443 ? host : String.valueOf(host) + ':' + port);
        } else {
            this.setRequestHeader("Host", port == 80 ? host : String.valueOf(host) + ':' + port);
        }
    }

    protected void addProxyAuthorizationRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        Header wwwAuthenticateHeader;
        log.trace((Object)"enter HttpMethodBase.addProxyAuthorizationRequestHeader(HttpState, HttpConnection)");
        if (this.getRequestHeader("Proxy-Authorization") == null && (wwwAuthenticateHeader = this.getResponseHeader("Proxy-Authenticate")) != null) {
            try {
                Authenticator.authenticateProxy(this, state);
            }
            catch (HttpException httpException) {
                // empty catch block
            }
        }
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter HttpMethodBase.addRequestHeaders(HttpState, HttpConnection)");
        this.addUserAgentRequestHeader(state, conn);
        this.addHostRequestHeader(state, conn);
        this.addCookieRequestHeader(state, conn);
        this.addAuthorizationRequestHeader(state, conn);
        this.addProxyAuthorizationRequestHeader(state, conn);
        this.addContentLengthRequestHeader(state, conn);
    }

    protected void addUserAgentRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter HttpMethodBase.addUserAgentRequestHeaders(HttpState, HttpConnection)");
        if (this.getRequestHeader("user-agent") == null) {
            this.setRequestHeader(USER_AGENT);
        }
    }

    protected void checkNotUsed() throws IllegalStateException {
        if (this.used) {
            throw new IllegalStateException("Already used.");
        }
    }

    protected void checkUsed() throws IllegalStateException {
        if (!this.used) {
            throw new IllegalStateException("Not Used.");
        }
    }

    protected static String generateRequestLine(HttpConnection connection, String name, String requestPath, String query, String protocol) {
        log.trace((Object)"enter HttpMethodBase.generateRequestLine(HttpConnection, String, String, String, String)");
        StringBuffer buf = new StringBuffer();
        String path = null;
        try {
            path = requestPath == null ? "/" : URIUtil.encodePath(requestPath);
        }
        catch (URIException urie) {
            log.error((Object)"URI path encoding error");
            path = requestPath;
        }
        buf.append(path);
        if (query != null) {
            if (query.indexOf("?") != 0) {
                buf.append("?");
            }
            String queryString = null;
            queryString = query == null ? "/" : query;
            buf.append(queryString);
        }
        if (!connection.isProxied() || connection.isTransparent()) {
            return String.valueOf(name) + " " + buf.toString() + " " + protocol + "\r\n";
        }
        if (connection.isSecure()) {
            return String.valueOf(name) + " https://" + connection.getHost() + (443 == connection.getPort() || -1 == connection.getPort() ? "" : ":" + connection.getPort()) + buf.toString() + " " + protocol + "\r\n";
        }
        return String.valueOf(name) + " http://" + connection.getHost() + (80 == connection.getPort() || -1 == connection.getPort() ? "" : ":" + connection.getPort()) + buf.toString() + " " + protocol + "\r\n";
    }

    protected void processResponseBody(HttpState state, HttpConnection conn) {
    }

    protected void processResponseHeaders(HttpState state, HttpConnection conn) {
        block4: {
            log.trace((Object)"enter HttpMethodBase.processResponseHeaders(HttpState, HttpConnection)");
            Header setCookieHeader = this.getResponseHeader("set-cookie2");
            if (setCookieHeader == null) {
                setCookieHeader = this.getResponseHeader("set-cookie");
            }
            if (setCookieHeader != null) {
                try {
                    Cookie[] cookies = Cookie.parse(conn.getHost(), conn.getPort(), this.getPath(), conn.isSecure(), setCookieHeader);
                    state.addCookies(cookies);
                }
                catch (HttpException e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Cookie rejected: \"" + setCookieHeader.getValue() + "\". " + e.getMessage()));
                }
            }
        }
    }

    protected void processStatusLine(HttpState state, HttpConnection conn) {
    }

    protected void readResponse(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter HttpMethodBase.readResponse(HttpState, HttpConnection)");
        this.readStatusLine(state, conn);
        this.processStatusLine(state, conn);
        this.readResponseHeaders(state, conn);
        this.processResponseHeaders(state, conn);
        this.readResponseBody(state, conn);
        this.processResponseBody(state, conn);
    }

    protected void readResponseBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter HttpMethodBase.readResponseBody(HttpState, HttpConnection)");
        this.setResponseStream(this._readResponseBody(state, conn));
    }

    private InputStream _readResponseBody(HttpState state, HttpConnection conn) throws IOException {
        log.trace((Object)"enter HttpMethodBase.readResponseBody(HttpState, HttpConnection)");
        this.responseBody = null;
        Header lengthHeader = this.getResponseHeader("Content-Length");
        Header transferEncodingHeader = this.getResponseHeader("Transfer-Encoding");
        InputStream is = conn.getResponseInputStream(this);
        if (wireLog.isDebugEnabled()) {
            is = new WireLogInputStream(is);
        }
        InputStream result = null;
        if (transferEncodingHeader != null) {
            if ("chunked".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                result = new ChunkedInputStream(is, this);
            }
        } else if (lengthHeader != null) {
            HeaderElement[] lengthElements = lengthHeader.getValues();
            String lengthValue = null;
            lengthValue = lengthElements.length > 1 ? lengthElements[0].getName() : lengthHeader.getValue();
            try {
                int expectedLength = Integer.parseInt(lengthValue);
                result = new ContentLengthInputStream(is, expectedLength);
            }
            catch (NumberFormatException e) {
                throw new HttpException("Unable to parse server response content length: '" + lengthValue + "'");
            }
        } else if (HttpMethodBase.canResponseHaveBody(this.statusLine.getStatusCode()) && !this.getName().equals("CONNECT")) {
            result = is;
        }
        if (result == null) {
            return null;
        }
        if (this.shouldCloseConnection()) {
            result = new AutoCloseInputStream(result, conn);
        }
        return result;
    }

    protected void readResponseHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        String line;
        log.trace((Object)"enter HttpMethodBase.readResponseHeaders(HttpState,HttpConnection)");
        this.responseHeaders.clear();
        String name = null;
        String value = null;
        while ((line = conn.readLine()) != null && line.length() >= 1) {
            String oldvalue;
            boolean isFolded = false;
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                isFolded = true;
                value = line.substring(1).trim();
            } else {
                int colon = line.indexOf(":");
                if (colon < 0) {
                    throw new HttpException("Unable to parse header: " + line);
                }
                name = line.substring(0, colon).trim();
                value = line.substring(colon + 1).trim();
            }
            Header header = this.getResponseHeader(name);
            header = header == null ? new Header(name, value) : ((oldvalue = header.getValue()) != null ? (isFolded ? new Header(name, String.valueOf(oldvalue) + " " + value) : new Header(name, String.valueOf(oldvalue) + ", " + value)) : new Header(name, value));
            this.setResponseHeader(header);
        }
    }

    protected void readStatusLine(HttpState state, HttpConnection conn) throws IOException, HttpRecoverableException, HttpException {
        log.trace((Object)"enter HttpMethodBase.readStatusLine(HttpState, HttpConnection)");
        String statusString = conn.readLine();
        while (statusString != null && !statusString.startsWith("HTTP/")) {
            statusString = conn.readLine();
        }
        if (statusString == null) {
            throw new HttpRecoverableException("Error in parsing the status  line from the response: unable to find line starting with \"HTTP/\"");
        }
        this.statusLine = new StatusLine(statusString);
        String httpVersion = this.statusLine.getHttpVersion();
        if (httpVersion.equals("HTTP/1.0")) {
            this.http11 = false;
        } else if (httpVersion.equals("HTTP/1.1")) {
            this.http11 = true;
        } else {
            throw new HttpException("Unrecognized server protocol: '" + httpVersion + "'");
        }
    }

    protected void writeRequest(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter HttpMethodBase.writeRequest(HttpState, HttpConnection)");
        this.writeRequestLine(state, conn);
        this.writeRequestHeaders(state, conn);
        conn.writeLine();
        this.bodySent = this.writeRequestBody(state, conn);
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        return true;
    }

    protected void writeRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter HttpMethodBase.writeRequestHeaders(HttpState,HttpConnection)");
        this.addRequestHeaders(state, conn);
        Iterator it = this.requestHeaders.values().iterator();
        while (it.hasNext()) {
            conn.print(((Header)it.next()).toExternalForm());
        }
    }

    protected void writeRequestLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter HttpMethodBase.writeRequestLine(HttpState, HttpConnection)");
        String requestLine = this.getRequestLine(conn);
        conn.print(requestLine);
    }

    private String getRequestLine(HttpConnection conn) {
        return HttpMethodBase.generateRequestLine(conn, this.getName(), this.getPath(), this.getQueryString(), this.getHttpVersion());
    }

    private String getHttpVersion() {
        return this.http11 ? "HTTP/1.1" : "HTTP/1.0";
    }

    private static boolean isIpAddress(String value) {
        log.trace((Object)"enter HttpMethodBase.isIpAddress(String)");
        value = value.trim();
        if (value.startsWith(".") || value.endsWith(".")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ".");
        if (tokenizer.countTokens() == 4) {
            while (tokenizer.hasMoreTokens()) {
                try {
                    int i = Integer.parseInt(tokenizer.nextToken());
                    if (i >= 0 && i <= 255) continue;
                    return false;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private String getNewHeaderValue(Header existingHeader, String value) {
        String existingValue = existingHeader.getValue();
        if (existingValue == null) {
            existingValue = "";
        }
        String newValue = value;
        if (value == null) {
            newValue = "";
        }
        return String.valueOf(existingValue) + ", " + newValue;
    }

    private void setResponseHeader(Header header) {
        if (header == null) {
            return;
        }
        this.responseHeaders.put(header.getName().toLowerCase(), header);
    }

    private static boolean canResponseHaveBody(int status) {
        log.trace((Object)"enter HttpMethodBase.canResponseHaveBody(int)");
        boolean result = true;
        if (status >= 100 && status <= 199 || status == 204 || status == 304) {
            result = false;
        }
        return result;
    }

    private String generateVisitedKey(HttpConnection conn) {
        return String.valueOf(conn.getHost()) + ":" + conn.getPort() + "|" + HttpMethodBase.generateRequestLine(conn, this.getName(), this.getPath(), this.getQueryString(), this.getHttpVersion());
    }

    private boolean processAuthenticationResponse(HttpState state, HttpConnection connection) {
        log.trace((Object)"enter HttpMethodBase.processAuthenticationResponse(HttpState, HttpConnection)");
        int statusCode = this.statusLine.getStatusCode();
        Header wwwauth = null;
        Set realmsUsed = null;
        switch (statusCode) {
            case 401: {
                wwwauth = this.getResponseHeader("WWW-Authenticate");
                realmsUsed = this.realms;
                break;
            }
            case 407: {
                wwwauth = this.getResponseHeader("Proxy-Authenticate");
                realmsUsed = this.proxyRealms;
            }
        }
        boolean authenticated = false;
        if (wwwauth != null) {
            String pathAndCreds = String.valueOf(this.getPath()) + ":" + wwwauth.getValue();
            if (realmsUsed.contains(pathAndCreds)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Already tried to authenticate to \"" + wwwauth.getValue() + "\" but still receiving " + statusCode + "."));
                }
                return true;
            }
            realmsUsed.add(pathAndCreds);
            try {
                switch (statusCode) {
                    case 401: {
                        this.removeRequestHeader("Authorization");
                        authenticated = Authenticator.authenticate(this, state);
                        break;
                    }
                    case 407: {
                        this.removeRequestHeader("Proxy-Authorization");
                        authenticated = Authenticator.authenticateProxy(this, state);
                    }
                }
            }
            catch (HttpException httpe) {
                log.warn((Object)httpe.getMessage());
                return true;
            }
            catch (UnsupportedOperationException uoe) {
                log.warn((Object)uoe.getMessage());
            }
            if (!authenticated) {
                log.debug((Object)"HttpMethodBase.execute(): Server demands authentication credentials, but none are available, so aborting.");
            } else {
                log.debug((Object)"HttpMethodBase.execute(): Server demanded authentication credentials, will try again.");
            }
        }
        return !authenticated;
    }

    private void processRequest(HttpState state, HttpConnection connection) throws HttpException, IOException {
        log.trace((Object)"enter HttpMethodBase.processRequest(HttpState, HttpConnection)");
        int retryCount = 0;
        while (true) {
            ++retryCount;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Attempt number " + retryCount + " to write request"));
            }
            try {
                if (!connection.isOpen()) {
                    log.debug((Object)"Opening the connection.");
                    connection.open();
                }
                this.writeRequest(state, connection);
                this.used = true;
            }
            catch (HttpRecoverableException httpre) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Closing the connection.");
                }
                connection.close();
                log.info((Object)"Recoverable exception caught when writing request");
                if (retryCount != this.maxRetries) continue;
                log.warn((Object)("Attempt to write request has reached max retries: " + this.maxRetries));
                throw httpre;
                if (retryCount <= this.maxRetries) continue;
            }
            break;
        }
        try {
            this.readResponse(state, connection);
        }
        catch (HttpRecoverableException httpre) {
            log.warn((Object)"Recoverable exception caught when reading response");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing the connection.");
            }
            connection.close();
            throw httpre;
        }
    }

    private void writeRemainingRequestBody(HttpState state, HttpConnection connection) throws HttpException, IOException {
        log.trace((Object)"enter writeRemainingRequestBody(HttpState, HttpConnection)");
        if (100 == this.statusLine.getStatusCode()) {
            if (!this.bodySent) {
                this.bodySent = this.writeRequestBody(state, connection);
            } else {
                log.warn((Object)"Received status CONTINUE but the body has already been sent");
            }
            this.readResponse(state, connection);
        }
    }

    protected static String getContentCharSet(Header contentheader) {
        log.trace((Object)"enter getContentCharSet( Header contentheader )");
        String charset = null;
        if (contentheader != null) {
            try {
                NameValuePair param;
                HeaderElement[] values = contentheader.getValues();
                if (values.length == 1 && (param = values[0].getParameterByName("charset")) != null) {
                    charset = param.getValue();
                }
            }
            catch (HttpException e) {
                log.error((Object)e);
            }
        }
        if (charset == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Default charset used: ISO-8859-1");
            }
            charset = DEFAULT_CHARSET;
        }
        return charset;
    }

    public String getRequestCharSet() {
        return HttpMethodBase.getContentCharSet(this.getRequestHeader("Content-Type"));
    }

    public String getResponseCharSet() {
        return HttpMethodBase.getContentCharSet(this.getResponseHeader("Content-Type"));
    }
}

