/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpSharedState;
import org.apache.commons.httpclient.HttpUrlMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpMultiClient {
    private static final Log log;
    private HttpSharedState state = null;
    private HttpConnectionManager mgr = new HttpConnectionManager();
    private boolean strictMode = false;
    private int timeoutConnection = 0;
    private int timeoutRequest = 0;
    private SSLSocketFactory sslSocketFactory = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.HttpMultiClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public HttpMultiClient() {
    }

    public HttpMultiClient(String proxyHost, int proxyPort) {
        this();
        this.mgr.setProxyHost(proxyHost);
        this.mgr.setProxyPort(proxyPort);
    }

    public void setState(HttpSharedState state) {
        this.state = state;
    }

    public HttpSharedState getState() {
        if (this.state == null) {
            this.state = new HttpSharedState();
        }
        return this.state;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setConnectionTimeout(int timeout) {
        this.timeoutConnection = timeout;
    }

    public int getConnectionTimeout() {
        return this.timeoutConnection;
    }

    public void setRequestTimeout(int timeout) {
        this.timeoutRequest = timeout;
    }

    public int getRequestTimeout() {
        return this.timeoutRequest;
    }

    public void setProxyHost(String host) {
        this.mgr.setProxyHost(host);
    }

    public String getProxyHost() {
        return this.mgr.getProxyHost();
    }

    public void setProxyPort(int port) {
        this.mgr.setProxyPort(port);
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public int getProxyPort() {
        return this.mgr.getProxyPort();
    }

    public int executeMethod(HttpUrlMethod method) throws IOException, HttpException {
        log.trace((Object)"enter executeMethod(HttpUrlMethod)");
        if (method == null) {
            throw new NullPointerException("method parameter");
        }
        HttpConnection connection = this.mgr.getConnection(method.getUrl(), this.timeoutConnection);
        connection.setSoTimeout(this.timeoutRequest);
        if (!connection.isOpen()) {
            connection.setSSLSocketFactory(this.sslSocketFactory);
        }
        int status = 0;
        method.setStrictMode(this.strictMode);
        try {
            status = method.execute(this.getState(), connection);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.mgr.releaseConnection(connection);
            throw throwable;
        }
        Object var5_8 = null;
        this.mgr.releaseConnection(connection);
        if (status == 301 || status == 302 || status == 303 || status == 307) {
            Header header = method.getResponseHeader("Location");
            String url = header.getValue();
            if (url == null) {
                log.error((Object)"HttpMultiClient.executeMethod:  Received redirect without Location header.");
                throw new HttpException("Received redirect without Location header.");
            }
            method.recycle();
            method.setUrl(url);
            return this.executeMethod(method);
        }
        return status;
    }
}

