/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.httpclient.Base64;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NTLM {
    private byte[] currResponse;
    private int pos = 0;
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.NTLM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        String secProviderName = System.getProperty("httpclient.security.provider", "com.sun.crypto.provider.SunJCE");
        try {
            Provider secProvider = (Provider)Class.forName(secProviderName).newInstance();
            Security.addProvider(secProvider);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Specified security provider " + secProviderName + " could not be found by the class loader"), (Throwable)e);
        }
        catch (ClassCastException e) {
            log.error((Object)("Specified security provider " + secProviderName + " is not of type java.security.Provider"), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)("Specified security provider " + secProviderName + " could not be instantiated"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Specified security provider " + secProviderName + " does not allow access to the constructor"), (Throwable)e);
        }
    }

    public final String getResponseFor(String message, String username, String password, String host, String domain) throws UnsupportedEncodingException, HttpException {
        String response = null;
        response = message == null || message.trim().equals("") ? this.getType1Message(host, domain) : this.getType3Message(username, password, host, domain, this.parseType2Message(message));
        return response;
    }

    private Cipher getCipher(byte[] key) throws HttpException {
        try {
            Cipher ecipher = Cipher.getInstance("DES/ECB/NoPadding");
            key = this.setupKey(key);
            ecipher.init(1, new SecretKeySpec(key, "DES"));
            return ecipher;
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpException("DES encryption is not available.");
        }
        catch (InvalidKeyException e) {
            throw new HttpException("Invalid key for DES encryption.");
        }
        catch (NoSuchPaddingException e) {
            throw new HttpException("NoPadding option for DES is not available.");
        }
    }

    private byte[] setupKey(byte[] key56) {
        byte[] key = new byte[]{(byte)(key56[0] >> 1 & 0xFF), (byte)(((key56[0] & 1) << 6 | (key56[1] & 0xFF) >> 2 & 0xFF) & 0xFF), (byte)(((key56[1] & 3) << 5 | (key56[2] & 0xFF) >> 3 & 0xFF) & 0xFF), (byte)(((key56[2] & 7) << 4 | (key56[3] & 0xFF) >> 4 & 0xFF) & 0xFF), (byte)(((key56[3] & 0xF) << 3 | (key56[4] & 0xFF) >> 5 & 0xFF) & 0xFF), (byte)(((key56[4] & 0x1F) << 2 | (key56[5] & 0xFF) >> 6 & 0xFF) & 0xFF), (byte)(((key56[5] & 0x3F) << 1 | (key56[6] & 0xFF) >> 7 & 0xFF) & 0xFF), (byte)(key56[6] & 0x7F)};
        int i = 0;
        while (i < key.length) {
            key[i] = (byte)(key[i] << 1);
            ++i;
        }
        return key;
    }

    private byte[] encrypt(byte[] key, byte[] bytes) throws HttpException {
        Cipher ecipher = this.getCipher(key);
        try {
            byte[] enc = ecipher.doFinal(bytes);
            return enc;
        }
        catch (IllegalBlockSizeException e) {
            throw new HttpException("Invalid block size for DES encryption.");
        }
        catch (BadPaddingException e) {
            throw new HttpException("Data not padded correctly for DES encryption.");
        }
    }

    private void prepareResponse(int length) {
        this.currResponse = new byte[length];
        this.pos = 0;
    }

    private void addByte(byte b) {
        this.currResponse[this.pos] = b;
        ++this.pos;
    }

    private void addBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            this.currResponse[this.pos] = bytes[i];
            ++this.pos;
            ++i;
        }
    }

    private String getResponse() throws UnsupportedEncodingException {
        byte[] resp;
        if (this.currResponse.length > this.pos) {
            byte[] tmp = new byte[this.pos];
            int i = 0;
            while (i < this.pos) {
                tmp[i] = this.currResponse[i];
                ++i;
            }
            resp = tmp;
        } else {
            resp = this.currResponse;
        }
        return new String(Base64.encode(resp), "ASCII");
    }

    private String getType1Message(String host, String domain) throws UnsupportedEncodingException {
        host = host.toUpperCase();
        domain = domain.toUpperCase();
        byte[] hostBytes = host.getBytes("ASCII");
        byte[] domainBytes = domain.getBytes("ASCII");
        int finalLength = 32 + hostBytes.length + domainBytes.length;
        this.prepareResponse(finalLength);
        byte[] msg = new byte[finalLength];
        byte[] protocol = "NTLMSSP".getBytes("ASCII");
        this.addBytes(protocol);
        this.addByte((byte)0);
        this.addByte((byte)1);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)6);
        this.addByte((byte)82);
        this.addByte((byte)0);
        this.addByte((byte)0);
        int iDomLen = domainBytes.length;
        byte[] domLen = this.convertShort(iDomLen);
        this.addByte(domLen[0]);
        this.addByte(domLen[1]);
        this.addByte(domLen[0]);
        this.addByte(domLen[1]);
        byte[] domOff = this.convertShort(hostBytes.length + 32);
        this.addByte(domOff[0]);
        this.addByte(domOff[1]);
        this.addByte((byte)0);
        this.addByte((byte)0);
        byte[] hostLen = this.convertShort(hostBytes.length);
        this.addByte(hostLen[0]);
        this.addByte(hostLen[1]);
        this.addByte(hostLen[0]);
        this.addByte(hostLen[1]);
        byte[] hostOff = this.convertShort(32);
        this.addByte(hostOff[0]);
        this.addByte(hostOff[1]);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(hostBytes);
        this.addBytes(domainBytes);
        return this.getResponse();
    }

    private byte[] parseType2Message(String sMsg) throws UnsupportedEncodingException {
        byte[] msg = Base64.decode(sMsg.getBytes("ASCII"));
        byte[] nonce = new byte[8];
        int i = 0;
        while (i < 8) {
            nonce[i] = msg[i + 24];
            ++i;
        }
        return nonce;
    }

    private String getType3Message(String user, String password, String host, String domain, byte[] nonce) throws UnsupportedEncodingException, HttpException {
        int nt_resp_len = 0;
        int lm_resp_len = 24;
        domain = domain.toUpperCase();
        host = host.toUpperCase();
        user = user.toUpperCase();
        byte[] domainBytes = domain.getBytes("ASCII");
        byte[] hostBytes = host.getBytes("ASCII");
        byte[] userBytes = user.getBytes("ASCII");
        int domainLen = domainBytes.length;
        int hostLen = hostBytes.length;
        int userLen = userBytes.length;
        int finalLength = 64 + nt_resp_len + lm_resp_len + domainLen + userLen + hostLen;
        this.prepareResponse(finalLength);
        byte[] ntlmssp = "NTLMSSP".getBytes("ASCII");
        this.addBytes(ntlmssp);
        this.addByte((byte)0);
        this.addByte((byte)3);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(24));
        this.addBytes(this.convertShort(24));
        this.addBytes(this.convertShort(finalLength - 24));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(0));
        this.addBytes(this.convertShort(0));
        this.addBytes(this.convertShort(finalLength));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(domainLen));
        this.addBytes(this.convertShort(domainLen));
        this.addBytes(this.convertShort(64));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(userLen));
        this.addBytes(this.convertShort(userLen));
        this.addBytes(this.convertShort(64 + domainLen));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(hostLen));
        this.addBytes(this.convertShort(hostLen));
        this.addBytes(this.convertShort(64 + domainLen + userLen));
        int i = 0;
        while (i < 6) {
            this.addByte((byte)0);
            ++i;
        }
        this.addBytes(this.convertShort(finalLength));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)6);
        this.addByte((byte)82);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(domainBytes);
        this.addBytes(userBytes);
        this.addBytes(hostBytes);
        this.addBytes(this.hashPassword(password, nonce));
        return this.getResponse();
    }

    private byte[] hashPassword(String password, byte[] nonce) throws UnsupportedEncodingException, HttpException {
        byte[] passw = password.toUpperCase().getBytes("ASCII");
        byte[] lm_pw1 = new byte[7];
        byte[] lm_pw2 = new byte[7];
        int len = passw.length;
        if (len > 7) {
            len = 7;
        }
        int idx = 0;
        while (idx < len) {
            lm_pw1[idx] = passw[idx];
            ++idx;
        }
        while (idx < 7) {
            lm_pw1[idx] = 0;
            ++idx;
        }
        len = passw.length;
        if (len > 14) {
            len = 14;
        }
        idx = 7;
        while (idx < len) {
            lm_pw2[idx - 7] = passw[idx];
            ++idx;
        }
        while (idx < 14) {
            lm_pw2[idx - 7] = 0;
            ++idx;
        }
        byte[] magic = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
        byte[] lm_hpw1 = this.encrypt(lm_pw1, magic);
        byte[] lm_hpw2 = this.encrypt(lm_pw2, magic);
        byte[] lm_hpw = new byte[21];
        int i = 0;
        while (i < lm_hpw1.length) {
            lm_hpw[i] = lm_hpw1[i];
            ++i;
        }
        i = 0;
        while (i < lm_hpw2.length) {
            lm_hpw[i + 8] = lm_hpw2[i];
            ++i;
        }
        i = 0;
        while (i < 5) {
            lm_hpw[i + 16] = 0;
            ++i;
        }
        byte[] lm_resp = new byte[24];
        this.calc_resp(lm_hpw, nonce, lm_resp);
        return lm_resp;
    }

    private void calc_resp(byte[] keys, byte[] plaintext, byte[] results) throws HttpException {
        byte[] keys1 = new byte[7];
        byte[] keys2 = new byte[7];
        byte[] keys3 = new byte[7];
        int i = 0;
        while (i < 7) {
            keys1[i] = keys[i];
            ++i;
        }
        i = 0;
        while (i < 7) {
            keys2[i] = keys[i + 7];
            ++i;
        }
        i = 0;
        while (i < 7) {
            keys3[i] = keys[i + 14];
            ++i;
        }
        byte[] results1 = this.encrypt(keys1, plaintext);
        byte[] results2 = this.encrypt(keys2, plaintext);
        byte[] results3 = this.encrypt(keys3, plaintext);
        int i2 = 0;
        while (i2 < 8) {
            results[i2] = results1[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            results[i2 + 8] = results2[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            results[i2 + 16] = results3[i2];
            ++i2;
        }
    }

    private byte[] convertShort(int num) {
        byte[] val = new byte[2];
        String hex = Integer.toString(num, 16);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        String low = hex.substring(2, 4);
        String high = hex.substring(0, 2);
        val[0] = (byte)Integer.parseInt(low, 16);
        val[1] = (byte)Integer.parseInt(high, 16);
        return val;
    }
}

