/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class URIUtil {
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final BitSet alpha = new BitSet(256);
    private static final BitSet alphanum;
    private static final BitSet reserved;
    private static final BitSet mark;
    private static final BitSet unreserved;
    private static final BitSet delims;
    private static final BitSet unwise;
    private static final BitSet pathReserved;
    private static final BitSet pathSafe;
    private static final BitSet queryStringValueSafe;
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        int i = 97;
        while (i <= 122) {
            alpha.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            alpha.set(i);
            ++i;
        }
        alphanum = new BitSet(256);
        alphanum.or(alpha);
        i = 48;
        while (i <= 57) {
            alphanum.set(i);
            ++i;
        }
        reserved = new BitSet(256);
        reserved.set(59);
        reserved.set(47);
        reserved.set(63);
        reserved.set(58);
        reserved.set(64);
        reserved.set(38);
        reserved.set(61);
        reserved.set(43);
        reserved.set(36);
        reserved.set(44);
        mark = new BitSet(256);
        mark.set(45);
        mark.set(95);
        mark.set(46);
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        unreserved = new BitSet(256);
        unreserved.or(alphanum);
        unreserved.or(mark);
        delims = new BitSet(256);
        delims.set(60);
        delims.set(62);
        delims.set(35);
        delims.set(37);
        delims.set(34);
        unwise = new BitSet(256);
        unwise.set(123);
        unwise.set(125);
        unwise.set(124);
        unwise.set(92);
        unwise.set(94);
        unwise.set(91);
        unwise.set(93);
        unwise.set(96);
        pathReserved = new BitSet(256);
        pathReserved.set(47);
        pathReserved.set(59);
        pathReserved.set(61);
        pathReserved.set(63);
        pathSafe = new BitSet(256);
        pathSafe.or(unreserved);
        pathSafe.or(pathReserved);
        queryStringValueSafe = new BitSet(256);
        queryStringValueSafe.or(unreserved);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.URIUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    private URIUtil() {
    }

    public static final String decode(String str) {
        return URIUtil.decode(str, false);
    }

    public static final String decode(String str, boolean plusIsSpace) {
        try {
            return str == null ? null : URIUtil.decode(str.getBytes(), null, plusIsSpace);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Default encoding not supported !?!");
        }
    }

    public static final String decode(byte[] bytes) {
        try {
            return URIUtil.decode(bytes, null, false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Default encoding not supported !?!");
        }
    }

    public static final String decode(byte[] bytes, boolean plusIsSpace) {
        try {
            return URIUtil.decode(bytes, null, plusIsSpace);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Default encoding not supported !?!");
        }
    }

    public static final String decode(byte[] bytes, int off, int len) {
        try {
            return URIUtil.decode(bytes, off, len, null, false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Default encoding not supported !?!");
        }
    }

    public static final String decode(byte[] bytes, int off, int len, boolean plusIsSpace) {
        try {
            return URIUtil.decode(bytes, off, len, null, plusIsSpace);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Default encoding not supported !?!");
        }
    }

    public static final String decode(byte[] bytes, String enc) throws UnsupportedEncodingException {
        return URIUtil.decode(bytes, 0, bytes.length, enc, false);
    }

    public static final String decode(byte[] bytes, String enc, boolean plusIsSpace) throws UnsupportedEncodingException {
        return URIUtil.decode(bytes, 0, bytes.length, enc, plusIsSpace);
    }

    public static final String decode(byte[] bytes, int off, int len, String enc) throws UnsupportedEncodingException {
        return URIUtil.decode(bytes, 0, bytes.length, enc, false);
    }

    public static final String decode(byte[] bytes, int off, int len, String enc, boolean plusIsSpace) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        int end = off + len;
        int ix = off;
        int ox = off;
        while (ix < end) {
            int b = bytes[ix++];
            if (plusIsSpace && b == 43) {
                b = 32;
            } else if (b == 37) {
                b = (byte)((URIUtil.convertHexDigit(bytes[ix++]) << 4) + URIUtil.convertHexDigit(bytes[ix++]));
            }
            bytes[ox++] = b;
        }
        if (enc != null) {
            return new String(bytes, off, ox, enc);
        }
        return new String(bytes, off, ox);
    }

    public static final String encode(String str) {
        return URIUtil.encode(str, null, false);
    }

    public static final String encode(String str, boolean spaceAsPlus) {
        return URIUtil.encode(str, null, spaceAsPlus);
    }

    public static final String encode(String str, BitSet safe) {
        return str == null ? null : URIUtil.encode(str.getBytes(), safe, false);
    }

    public static final String encode(String str, BitSet safe, boolean spaceAsPlus) {
        return str == null ? null : URIUtil.encode(str.getBytes(), safe, spaceAsPlus);
    }

    public static final String encode(byte[] bytes, BitSet safe) {
        return bytes == null ? null : URIUtil.encode(bytes, 0, bytes.length, safe, false);
    }

    public static final String encode(byte[] bytes, BitSet safe, boolean spaceAsPlus) {
        return bytes == null ? null : URIUtil.encode(bytes, 0, bytes.length, safe, spaceAsPlus);
    }

    public static final String encode(byte[] bytes, int off, int len, BitSet safe) {
        return bytes == null ? null : URIUtil.encode(bytes, 0, bytes.length, safe, false);
    }

    public static final String encode(byte[] bytes, int off, int len, BitSet safe, boolean spaceAsPlus) {
        if (bytes == null) {
            return null;
        }
        if (safe == null) {
            safe = unreserved;
        }
        StringBuffer rewrittenStr = new StringBuffer(len);
        int i = off;
        while (i < len) {
            char c = (char)bytes[i];
            if (safe.get(c)) {
                rewrittenStr.append(c);
            } else if (spaceAsPlus && ' ' == c) {
                rewrittenStr.append('+');
            } else {
                byte toEscape = bytes[i];
                rewrittenStr.append('%');
                int low = toEscape & 0xF;
                int high = (toEscape & 0xF0) >> 4;
                rewrittenStr.append(hexadecimal[high]);
                rewrittenStr.append(hexadecimal[low]);
            }
            ++i;
        }
        return rewrittenStr.toString();
    }

    public static final String encode(String str, BitSet safe, String enc) {
        return URIUtil.encode(str, safe, enc, false);
    }

    public static final String encode(String str, BitSet safe, String enc, boolean spaceAsPlus) {
        try {
            return URIUtil.encode(str.getBytes(enc), safe, spaceAsPlus);
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)("Unsupported encoding " + enc + " requested, using default"));
            return URIUtil.encode(str.getBytes(), safe, spaceAsPlus);
        }
    }

    public static final String getPath(String url) {
        String path = null;
        int startIndex = url.indexOf("//");
        if (startIndex >= 0) {
            startIndex += 2;
        }
        if ((startIndex = url.indexOf("/", startIndex)) >= 0) {
            int endIndex = url.lastIndexOf("#");
            if (endIndex < 0) {
                endIndex = url.lastIndexOf("?");
            }
            path = endIndex < 0 ? url.substring(startIndex) : url.substring(startIndex, endIndex);
        }
        if (path == null || path.length() == 0) {
            path = "/";
        }
        return path;
    }

    public static final String getQueryString(String url) {
        String query = null;
        int index = url.lastIndexOf("?");
        if (index >= 0) {
            query = url.substring(index + 1);
        }
        return query;
    }

    public static final BitSet unreserved() {
        return unreserved;
    }

    public static final BitSet pathSafe() {
        return pathSafe;
    }

    public static final BitSet queryStringValueSafe() {
        return queryStringValueSafe;
    }

    private static final byte convertHexDigit(byte b) {
        switch (b) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return (byte)(b - 48);
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return (byte)(b - 97 + 10);
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return (byte)(b - 65 + 10);
            }
        }
        throw new IllegalArgumentException(String.valueOf(b) + " is not a hex value");
    }
}

