/*
 * Decompiled with CFR 0.152.
 */
package monalipse.utils;

import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;

public class CancelableRunner {
    private IStatusLineManager manager;
    private Display display;
    private IAction cancelAction;
    private int runCount;
    private List connections = new ArrayList();

    public CancelableRunner(IStatusLineManager manager, Display display, IAction cancelAction) {
        this.manager = manager;
        this.display = display;
        this.cancelAction = cancelAction;
        manager.setCancelEnabled(false);
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public ICancelableProgressMonitor getProgressMonitor() {
        return new CancelableProgressMonitor(this, this.manager.getProgressMonitor());
    }

    public ICancelableProgressMonitor getSubProgressMonitor(IProgressMonitor monitor, int ticks) {
        return new CancelableSubProgressMonitor(this, monitor, ticks, 4);
    }

    public void cancel() {
        List list = this.connections;
        synchronized (list) {
            int i = 0;
            while (i < this.connections.size()) {
                ((HttpURLConnection)this.connections.get(i)).disconnect();
                ++i;
            }
            this.connections.clear();
        }
    }

    public void openConnection(HttpURLConnection conn) {
        List list = this.connections;
        synchronized (list) {
            this.connections.add(conn);
        }
    }

    public void closeConnection(HttpURLConnection conn) {
        List list = this.connections;
        synchronized (list) {
            this.connections.remove(conn);
            conn.disconnect();
        }
    }

    public void runAndJoin(Object serializeKey, ICancelableRunnableWithProgress run) {
        try {
            this.run(serializeKey, run).join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public Thread run(Object serializeKey, ICancelableRunnableWithProgress run) {
        Thread thread = new Thread(new Runnable(this, serializeKey, run){
            private final /* synthetic */ Object val$serializeKey;
            private final /* synthetic */ ICancelableRunnableWithProgress val$run;
            private final /* synthetic */ CancelableRunner this$0;
            {
                CancelableRunner cancelableRunner2 = cancelableRunner;
                cancelableRunner2.getClass();
                this.this$0 = cancelableRunner2;
                this.val$serializeKey = object;
                this.val$run = iCancelableRunnableWithProgress;
            }

            public void run() {
                if (this.val$serializeKey == null) {
                    this.this$0.runDirect(this.val$run);
                } else {
                    Object object = this.val$serializeKey;
                    synchronized (object) {
                        this.this$0.runDirect(this.val$run);
                    }
                }
            }
        });
        thread.start();
        return thread;
    }

    public void runDirect(ICancelableRunnableWithProgress run) {
        try {
            CancelableRunner cancelableRunner = this;
            synchronized (cancelableRunner) {
                this.cancelAction.setEnabled(true);
                ++this.runCount;
            }
            run.run(this.getProgressMonitor());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            CancelableRunner cancelableRunner = this;
            synchronized (cancelableRunner) {
                --this.runCount;
                this.cancelAction.setEnabled(this.runCount != 0);
            }
            throw throwable;
        }
        Object var3_5 = null;
        CancelableRunner cancelableRunner = this;
        synchronized (cancelableRunner) {
            --this.runCount;
            this.cancelAction.setEnabled(this.runCount != 0);
        }
    }

    public interface ICancelableRunnableWithProgress {
        public void run(ICancelableProgressMonitor var1);
    }

    public interface ICancelableProgressMonitor
    extends IProgressMonitor {
        public CancelableRunner getRunner();
    }

    public class CancelableProgressMonitor
    implements ICancelableProgressMonitor {
        private IProgressMonitor monitor;
        private final /* synthetic */ CancelableRunner this$0;

        public CancelableProgressMonitor(CancelableRunner cancelableRunner, IProgressMonitor monitor) {
            CancelableRunner cancelableRunner2 = cancelableRunner;
            cancelableRunner2.getClass();
            this.this$0 = cancelableRunner2;
            this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        }

        public CancelableRunner getRunner() {
            return this.this$0;
        }

        public void beginTask(String name, int totalWork) {
            this.this$0.display.syncExec(new Runnable(this, name, totalWork){
                private final /* synthetic */ CancelableProgressMonitor this$1;
                private final /* synthetic */ String val$name;
                private final /* synthetic */ int val$totalWork;
                {
                    CancelableProgressMonitor cancelableProgressMonitor2 = cancelableProgressMonitor;
                    cancelableProgressMonitor2.getClass();
                    this.this$1 = cancelableProgressMonitor2;
                    this.val$name = string;
                    this.val$totalWork = n;
                }

                public void run() {
                    CancelableProgressMonitor.access$0(this.this$1).beginTask(this.val$name, this.val$totalWork);
                }
            });
        }

        public void done() {
            this.this$0.display.syncExec(new Runnable(this){
                private final /* synthetic */ CancelableProgressMonitor this$1;
                {
                    CancelableProgressMonitor cancelableProgressMonitor2 = cancelableProgressMonitor;
                    cancelableProgressMonitor2.getClass();
                    this.this$1 = cancelableProgressMonitor2;
                }

                public void run() {
                    CancelableProgressMonitor.access$0(this.this$1).done();
                }
            });
        }

        public void internalWorked(double work) {
            this.this$0.display.syncExec(new Runnable(this, work){
                private final /* synthetic */ CancelableProgressMonitor this$1;
                private final /* synthetic */ double val$work;
                {
                    CancelableProgressMonitor cancelableProgressMonitor2 = cancelableProgressMonitor;
                    cancelableProgressMonitor2.getClass();
                    this.this$1 = cancelableProgressMonitor2;
                    this.val$work = d;
                }

                public void run() {
                    CancelableProgressMonitor.access$0(this.this$1).internalWorked(this.val$work);
                }
            });
        }

        public boolean isCanceled() {
            return !this.this$0.cancelAction.isEnabled();
        }

        public void setCanceled(boolean b) {
            if (b) {
                this.this$0.cancel();
            }
        }

        public void setTaskName(String name) {
            this.this$0.display.syncExec(new Runnable(this, name){
                private final /* synthetic */ CancelableProgressMonitor this$1;
                private final /* synthetic */ String val$name;
                {
                    CancelableProgressMonitor cancelableProgressMonitor2 = cancelableProgressMonitor;
                    cancelableProgressMonitor2.getClass();
                    this.this$1 = cancelableProgressMonitor2;
                    this.val$name = string;
                }

                public void run() {
                    CancelableProgressMonitor.access$0(this.this$1).setTaskName(this.val$name);
                }
            });
        }

        public void subTask(String name) {
            this.this$0.display.syncExec(new Runnable(this, name){
                private final /* synthetic */ CancelableProgressMonitor this$1;
                private final /* synthetic */ String val$name;
                {
                    CancelableProgressMonitor cancelableProgressMonitor2 = cancelableProgressMonitor;
                    cancelableProgressMonitor2.getClass();
                    this.this$1 = cancelableProgressMonitor2;
                    this.val$name = string;
                }

                public void run() {
                    CancelableProgressMonitor.access$0(this.this$1).subTask(this.val$name);
                }
            });
        }

        public void worked(int work) {
            this.this$0.display.syncExec(new Runnable(this, work){
                private final /* synthetic */ CancelableProgressMonitor this$1;
                private final /* synthetic */ int val$work;
                {
                    CancelableProgressMonitor cancelableProgressMonitor2 = cancelableProgressMonitor;
                    cancelableProgressMonitor2.getClass();
                    this.this$1 = cancelableProgressMonitor2;
                    this.val$work = n;
                }

                public void run() {
                    CancelableProgressMonitor.access$0(this.this$1).worked(this.val$work);
                }
            });
        }

        static /* synthetic */ IProgressMonitor access$0(CancelableProgressMonitor cancelableProgressMonitor) {
            return cancelableProgressMonitor.monitor;
        }
    }

    private class CancelableSubProgressMonitor
    extends SubProgressMonitor
    implements ICancelableProgressMonitor {
        private final /* synthetic */ CancelableRunner this$0;

        public CancelableSubProgressMonitor(CancelableRunner cancelableRunner, IProgressMonitor monitor, int ticks, int style) {
            CancelableRunner cancelableRunner2 = cancelableRunner;
            cancelableRunner2.getClass();
            this.this$0 = cancelableRunner2;
            super(monitor, ticks, style);
        }

        public CancelableRunner getRunner() {
            return this.this$0;
        }
    }
}

