/*
 * Decompiled with CFR 0.152.
 */
package monalipse.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import monalipse.MonalipsePlugin;
import monalipse.actions.BookmarkAction;
import monalipse.bookmark.BookmarkManager;
import monalipse.bookmark.IBookmarkTreeNode;
import monalipse.editors.ThreadEditorInput;
import monalipse.editors.ThreadViewerEditor;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.IBBSReference;
import monalipse.server.IThreadContentProvider;
import monalipse.utils.CancelableRunner;
import monalipse.views.AbstractTreeView;
import monalipse.views.ThreadListView;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class BookmarksView
extends AbstractTreeView
implements SelectionListener,
IResourceChangeListener {
    public static final String ID_BOOKMARKS;
    private static final Logger logger;
    private MappedTreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private IAction checkAction;
    private IAction abortAction;
    private IAction createFolderAction;
    private IAction removeFolderAction;
    private IAction doubleClickAction;
    private BookmarkAction bookmarkAction;
    private BookmarksContentProvider provider;
    private CancelableRunner cancelable;
    private TreeEditor treeEditor;
    private Text treeEditorText;
    private TreeItem treeEditItem;
    private IBookmarkTreeNode treeEditTarget;
    private Object lastSelected;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.BookmarksView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_BOOKMARKS = clazz.getName();
        logger = MonalipsePlugin.getLogger();
    }

    protected ITreeContentProvider getContentProvider() {
        return this.provider;
    }

    protected ILabelProvider getLabelProvider() {
        return this.provider;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new MappedTreeViewer(this, parent, 770);
        this.drillDownAdapter = new DrillDownAdapter((TreeViewer)this.viewer);
        this.provider = new BookmarksContentProvider(this);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.viewer.setInput(BookmarkManager.getBookmarks());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getTree().addSelectionListener((SelectionListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.hookDragAndDrop();
        this.partCreated();
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(this){
            private final /* synthetic */ BookmarksView this$0;
            {
                BookmarksView bookmarksView2 = bookmarksView;
                ((Object)((Object)bookmarksView2)).getClass();
                this.this$0 = bookmarksView2;
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    this.this$0.checkAction.run();
                }
            }
        });
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        boolean update;
        logger.finest("begin");
        boolean refresh = BookmarkManager.bookmarkChanged(event) || MonalipsePlugin.projectModified(event.getDelta());
        boolean bl = update = !refresh && MonalipsePlugin.resourceModified(7, event.getDelta(), (IResource)MonalipsePlugin.getProject());
        if (refresh) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.views.BookmarksView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)clazz.getName());
            this.saveState((IMemento)memento);
            logger.finest("refresh");
            this.viewer.setInput(BookmarkManager.getBookmarks());
            this.restoreState((IMemento)memento);
        }
        if (update) {
            logger.finest("update");
            Object[] nodes = BookmarkManager.getChangedNodes(BookmarkManager.getBookmarks(), event);
            if (nodes != null) {
                this.viewer.update(nodes, null);
            }
        }
        logger.finest("done");
    }

    public void widgetSelected(SelectionEvent e) {
        IThreadContentProvider thread;
        this.finishTreeEditor();
        logger.finest("begin");
        IBBSReference ref = this.bookmarkAction.updateState(this.getSite().getWorkbenchWindow(), this.viewer.getSelection());
        if (ref != null && (thread = BBSServerManager.getThreadContentProviderOf(ref.getURL())) != null) {
            ThreadViewerEditor.activateEditor(this.getSite(), thread);
        }
        logger.finest("done");
        if (this.viewer.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)this.viewer.getSelection()).size() == 1) {
            Object first = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            if (this.lastSelected == first && this.lastSelected instanceof IBookmarkTreeNode) {
                this.treeEditItem = (TreeItem)e.item;
                this.getSite().getShell().getDisplay().timerExec(300, new Runnable(this){
                    private final /* synthetic */ BookmarksView this$0;
                    {
                        BookmarksView bookmarksView2 = bookmarksView;
                        ((Object)((Object)bookmarksView2)).getClass();
                        this.this$0 = bookmarksView2;
                    }

                    public void run() {
                        if (this.this$0.treeEditItem == null) {
                            return;
                        }
                        logger.finest("begin");
                        this.this$0.treeEditTarget = (IBookmarkTreeNode)this.this$0.lastSelected;
                        this.this$0.treeEditorText = new Text((Composite)this.this$0.viewer.getTree(), 2052);
                        this.this$0.treeEditor = new TreeEditor(this.this$0.viewer.getTree());
                        ((BookmarksView)this.this$0).treeEditor.horizontalAlignment = 16384;
                        ((BookmarksView)this.this$0).treeEditor.grabHorizontal = true;
                        ((BookmarksView)this.this$0).treeEditor.minimumWidth = 50;
                        this.this$0.treeEditor.setEditor((Control)this.this$0.treeEditorText, this.this$0.treeEditItem);
                        this.this$0.treeEditorText.setText(this.this$0.treeEditTarget.getName());
                        this.this$0.treeEditorText.selectAll();
                        this.this$0.treeEditorText.addFocusListener((FocusListener)new FocusAdapter(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                2 v0 = var1_1;
                                v0.getClass();
                                this.this$1 = v0;
                            }

                            public void focusLost(FocusEvent e) {
                                BookmarksView.access$11(2.access$0(this.this$1));
                            }
                        });
                        this.this$0.treeEditorText.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                2 v0 = var1_1;
                                v0.getClass();
                                this.this$1 = v0;
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                                BookmarksView.access$11(2.access$0(this.this$1));
                            }
                        });
                        this.this$0.treeEditorText.setFocus();
                        logger.finest("end");
                    }

                    static /* synthetic */ BookmarksView access$0(2 var0) {
                        return var0.this$0;
                    }
                });
            } else {
                this.lastSelected = first;
            }
        } else {
            this.lastSelected = null;
        }
    }

    private void finishTreeEditor() {
        logger.finest("begin");
        this.treeEditItem = null;
        if (this.treeEditorText != null) {
            logger.finest("closing");
            String name = this.treeEditorText.getText().trim();
            logger.finest("result: " + name);
            if (name.length() > 0 && !this.treeEditTarget.getName().equals(name)) {
                logger.finest("save");
                this.treeEditTarget.setName(name);
                BookmarkManager.setBookmarks(this.getSite().getWorkbenchWindow(), this.treeEditTarget.getRoot());
            }
            logger.finest("disposeText");
            this.treeEditorText.dispose();
            this.treeEditorText = null;
        }
        if (this.treeEditor != null) {
            logger.finest("disposeEditor");
            this.treeEditor.dispose();
        }
        this.treeEditor = null;
        logger.finest("done");
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(this){
            private final /* synthetic */ BookmarksView this$0;
            {
                BookmarksView bookmarksView2 = bookmarksView;
                ((Object)((Object)bookmarksView2)).getClass();
                this.this$0 = bookmarksView2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.this$0.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalStatusBar(bars.getStatusLineManager());
    }

    private void fillLocalStatusBar(IStatusLineManager manager) {
        this.cancelable = new CancelableRunner(manager, this.getSite().getShell().getDisplay(), this.abortAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.checkAction);
        manager.add(this.abortAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        this.bookmarkAction.updateState(this.getSite().getWorkbenchWindow(), this.viewer.getSelection());
        manager.add(this.checkAction);
        manager.add(this.abortAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createFolderAction);
        manager.add((IContributionItem)new Separator());
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        if (sel.getFirstElement() instanceof IBookmarkTreeNode && ((IBookmarkTreeNode)sel.getFirstElement()).hasChildren()) {
            manager.add(this.removeFolderAction);
        } else {
            manager.add((IAction)this.bookmarkAction);
        }
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.checkAction);
        manager.add(this.abortAction);
    }

    private void makeActions() {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)"monalipse").getDescriptor().getInstallURL();
        this.checkAction = new Action(this){
            private final /* synthetic */ BookmarksView this$0;
            {
                BookmarksView bookmarksView2 = bookmarksView;
                ((Object)((Object)bookmarksView2)).getClass();
                this.this$0 = bookmarksView2;
            }

            public void run() {
                this.this$0.cancelable.run(this.this$0.cancelable, new CancelableRunner.ICancelableRunnableWithProgress(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        6 v0 = var1_1;
                        ((Object)((Object)v0)).getClass();
                        this.this$1 = v0;
                    }

                    public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                        IBookmarkTreeNode node = BookmarkManager.getBookmarks();
                        ArrayList<E> list = new ArrayList<E>();
                        6.access$0(this.this$1, node, list);
                        monitor.beginTask("", list.size() + 1);
                        monitor.setTaskName("Checking Updates...");
                        int i = 0;
                        while (i < list.size()) {
                            monitor.worked(1);
                            IBBSBoard board = (IBBSBoard)list.get(i);
                            board.updateThreadList(6.access$1(this.this$1).getSite().getWorkbenchWindow());
                            ++i;
                        }
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }

            private void getBoards(IBookmarkTreeNode node, List list) {
                IBBSBoard board;
                if (node instanceof IBBSReference && !list.contains(board = BBSServerManager.getBoardOf(((IBBSReference)((Object)node)).getURL()))) {
                    list.add(board);
                }
                if (node.hasChildren()) {
                    IBookmarkTreeNode[] nodes = node.getChildren();
                    int i = 0;
                    while (i < nodes.length) {
                        this.getBoards(nodes[i], list);
                        ++i;
                    }
                }
            }

            static /* synthetic */ void access$0(6 var0, IBookmarkTreeNode iBookmarkTreeNode, List list) {
                var0.getBoards(iBookmarkTreeNode, list);
            }

            static /* synthetic */ BookmarksView access$1(6 var0) {
                return var0.this$0;
            }
        };
        this.checkAction.setText("Check Updated");
        this.checkAction.setToolTipText("Check Updated");
        try {
            this.checkAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "refresh_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.abortAction = new Action(this){
            private final /* synthetic */ BookmarksView this$0;
            {
                BookmarksView bookmarksView2 = bookmarksView;
                ((Object)((Object)bookmarksView2)).getClass();
                this.this$0 = bookmarksView2;
            }

            public void run() {
                this.this$0.cancelable.cancel();
            }
        };
        this.abortAction.setText("Abort");
        this.abortAction.setToolTipText("Abort checking updated");
        this.abortAction.setEnabled(false);
        try {
            this.abortAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "stop_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.createFolderAction = new Action(this){
            private final /* synthetic */ BookmarksView this$0;
            {
                BookmarksView bookmarksView2 = bookmarksView;
                ((Object)((Object)bookmarksView2)).getClass();
                this.this$0 = bookmarksView2;
            }

            public void run() {
                if (this.this$0.viewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)this.this$0.viewer.getSelection();
                    IBookmarkTreeNode node = sel.size() > 0 ? (IBookmarkTreeNode)sel.getFirstElement() : BookmarkManager.getBookmarks();
                    node.createFolder("New Folder", node.hasChildren() ? 3 : 2);
                    BookmarkManager.setBookmarks(this.this$0.getSite().getWorkbenchWindow(), BookmarkManager.getBookmarks());
                }
            }
        };
        this.createFolderAction.setText("Create New Folder");
        this.createFolderAction.setToolTipText("Create New Folder");
        this.createFolderAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.removeFolderAction = new Action(this){
            private final /* synthetic */ BookmarksView this$0;
            {
                BookmarksView bookmarksView2 = bookmarksView;
                ((Object)((Object)bookmarksView2)).getClass();
                this.this$0 = bookmarksView2;
            }

            public void run() {
                IStructuredSelection sel;
                if (this.this$0.viewer.getSelection() instanceof IStructuredSelection && (sel = (IStructuredSelection)this.this$0.viewer.getSelection()).size() > 0) {
                    ((IBookmarkTreeNode)sel.getFirstElement()).remove();
                    BookmarkManager.setBookmarks(this.this$0.getSite().getWorkbenchWindow(), BookmarkManager.getBookmarks());
                }
            }
        };
        this.removeFolderAction.setText("Remove Folder");
        this.removeFolderAction.setToolTipText("Remove Folder");
        this.doubleClickAction = new Action(this){
            private final /* synthetic */ BookmarksView this$0;
            {
                BookmarksView bookmarksView2 = bookmarksView;
                ((Object)((Object)bookmarksView2)).getClass();
                this.this$0 = bookmarksView2;
            }

            public void run() {
                this.this$0.treeEditItem = null;
                ISelection selection = this.this$0.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object first = ((IStructuredSelection)selection).getFirstElement();
                    if (first instanceof IBBSReference) {
                        block12: {
                            logger.finest("begin");
                            IBBSReference ref = (IBBSReference)first;
                            IWorkbenchPage page = this.this$0.getSite().getPage().getWorkbenchWindow().getActivePage();
                            IThreadContentProvider thread = BBSServerManager.getThreadContentProviderOf(ref.getURL());
                            try {
                                if (thread != null) {
                                    IEditorPart part;
                                    logger.finest("openEditor");
                                    ThreadEditorInput threadEditorInput = new ThreadEditorInput(thread);
                                    Class<?> clazz = class$1;
                                    if (clazz == null) {
                                        try {
                                            clazz = class$1 = Class.forName("monalipse.editors.ThreadViewerEditor");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if ((part = page.openEditor((IEditorInput)threadEditorInput, clazz.getName())) instanceof ThreadViewerEditor) {
                                        logger.finest("updateThread");
                                        ((ThreadViewerEditor)part).updateThread(-1);
                                    }
                                    break block12;
                                }
                                IBBSBoard board = BBSServerManager.getBoardOf(ref.getURL());
                                if (board != null) {
                                    this.this$0.cancelable.run(this.this$0.cancelable, new CancelableRunner.ICancelableRunnableWithProgress(this, board){
                                        private final /* synthetic */ IBBSBoard val$board;
                                        private final /* synthetic */ 11 this$1;
                                        {
                                            11 v0 = var1_1;
                                            ((Object)((Object)v0)).getClass();
                                            this.this$1 = v0;
                                            this.val$board = iBBSBoard;
                                        }

                                        public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                                            this.val$board.updateThreadList(11.access$0(this.this$1).getSite().getWorkbenchWindow());
                                        }
                                    });
                                    logger.finest("openView");
                                    page.showView(ThreadListView.ID_THREAD_LIST);
                                }
                            }
                            catch (PartInitException ex) {
                                ex.printStackTrace();
                            }
                        }
                        logger.finest("done");
                    } else {
                        this.this$0.viewer.setExpandedState(first, !this.this$0.viewer.getExpandedState(first));
                    }
                }
            }

            static /* synthetic */ BookmarksView access$0(11 var0) {
                return var0.this$0;
            }
        };
        this.bookmarkAction = new BookmarkAction();
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(this){
            private final /* synthetic */ BookmarksView this$0;
            {
                BookmarksView bookmarksView2 = bookmarksView;
                ((Object)((Object)bookmarksView2)).getClass();
                this.this$0 = bookmarksView2;
            }

            public void doubleClick(DoubleClickEvent event) {
                this.this$0.doubleClickAction.run();
            }
        });
    }

    private void hookDragAndDrop() {
        this.viewer.addDragSupport(3, new Transfer[]{PluginTransfer.getInstance()}, new DragSourceListener(this){
            private IBookmarkTreeNode[] lastData;
            private final /* synthetic */ BookmarksView this$0;
            {
                BookmarksView bookmarksView2 = bookmarksView;
                ((Object)((Object)bookmarksView2)).getClass();
                this.this$0 = bookmarksView2;
            }

            public void dragStart(DragSourceEvent event) {
                logger.finest("begin");
                this.this$0.lastSelected = null;
                this.this$0.finishTreeEditor();
                event.doit = this.this$0.viewer.getSelection() instanceof IStructuredSelection ? ((IStructuredSelection)this.this$0.viewer.getSelection()).size() > 0 : false;
                logger.finest("done " + event.doit);
            }

            public void dragSetData(DragSourceEvent event) {
                logger.finest("begin");
                this.this$0.lastSelected = null;
                this.this$0.finishTreeEditor();
                if (this.this$0.viewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)this.this$0.viewer.getSelection();
                    ArrayList<IBookmarkTreeNode> list = new ArrayList<IBookmarkTreeNode>();
                    Object[] nodes = sel.toArray();
                    int i = 0;
                    while (i < nodes.length) {
                        boolean skip = false;
                        IBookmarkTreeNode node = (IBookmarkTreeNode)nodes[i];
                        int j = 0;
                        while (j < nodes.length) {
                            if (i != j && ((IBookmarkTreeNode)nodes[j]).isAncestorOf(node)) {
                                skip = true;
                                break;
                            }
                            ++j;
                        }
                        if (!skip) {
                            list.add(node);
                        }
                        ++i;
                    }
                    this.lastData = new IBookmarkTreeNode[list.size()];
                    list.toArray(this.lastData);
                    event.data = BookmarkManager.getTransferData(this.lastData);
                }
                if (event.data == null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("monalipse.views.BookmarksView");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    event.data = new PluginTransferData(String.valueOf(clazz.getName()) + ".invalid", new byte[0]);
                    this.lastData = null;
                }
                logger.finest("done");
            }

            public void dragFinished(DragSourceEvent event) {
                logger.finest("begin");
                this.this$0.lastSelected = null;
                this.this$0.finishTreeEditor();
                if (event.doit) {
                    if (event.detail == 2 && this.lastData != null) {
                        int i = 0;
                        while (i < this.lastData.length) {
                            this.lastData[i].remove();
                            ++i;
                        }
                    }
                    if (event.detail == 2 || event.detail == 1) {
                        BookmarkManager.setBookmarks(this.this$0.getSite().getWorkbenchWindow(), BookmarkManager.getBookmarks());
                    }
                }
                logger.finest("done");
            }
        });
        this.viewer.addDropSupport(3, new Transfer[]{PluginTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter(this, (Viewer)this.viewer){
            private final /* synthetic */ BookmarksView this$0;
            {
                BookmarksView bookmarksView2 = bookmarksView;
                ((Object)((Object)bookmarksView2)).getClass();
                this.this$0 = bookmarksView2;
                super($anonymous0);
            }

            protected int determineLocation(DropTargetEvent event) {
                if (event.item instanceof TreeItem && ((Item)event.item).getData() instanceof IBookmarkTreeNode) {
                    Item item = (Item)event.item;
                    Point pt = this.this$0.viewer.getControl().toControl(new Point(event.x, event.y));
                    if (item != null) {
                        Rectangle bounds = this.getBounds(item);
                        if (bounds == null) {
                            return 4;
                        }
                        int border = ((IBookmarkTreeNode)item.getData()).hasChildren() ? 4 : bounds.height / 2;
                        if (pt.y - bounds.y <= border) {
                            this.this$0.viewer.getTree().setInsertMark((TreeItem)event.item, true);
                            return 1;
                        }
                        if (bounds.y + bounds.height - pt.y <= border) {
                            this.this$0.viewer.getTree().setInsertMark((TreeItem)event.item, false);
                            return 2;
                        }
                        this.this$0.viewer.getTree().setInsertMark(null, false);
                        return 3;
                    }
                }
                return 4;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                this.this$0.lastSelected = null;
                this.this$0.finishTreeEditor();
                try {
                    return target instanceof IBookmarkTreeNode && PluginTransfer.getInstance().isSupportedType(transferType);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    return false;
                }
            }

            public boolean performDrop(Object data) {
                IBookmarkTreeNode[] nodes;
                int location;
                this.this$0.lastSelected = null;
                this.this$0.finishTreeEditor();
                this.this$0.viewer.getTree().setInsertMark(null, false);
                switch (this.getCurrentLocation()) {
                    case 1: {
                        location = 1;
                        break;
                    }
                    case 2: {
                        location = 2;
                        break;
                    }
                    case 3: {
                        location = 3;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (data instanceof PluginTransferData && this.getCurrentTarget() instanceof IBookmarkTreeNode && (nodes = BookmarkManager.getBookmarks((PluginTransferData)data)) != null) {
                    IBookmarkTreeNode target = (IBookmarkTreeNode)this.getCurrentTarget();
                    int i = 0;
                    while (i < nodes.length) {
                        if (target == nodes[i] || nodes[i].isAncestorOf(target)) {
                            return false;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < nodes.length) {
                        this.cloneNode(nodes[i], target, location);
                        ++i;
                    }
                    if (location == 3) {
                        this.this$0.viewer.setExpandedState(target, true);
                    }
                    return true;
                }
                return false;
            }

            private void cloneNode(IBookmarkTreeNode src, IBookmarkTreeNode refChild, int location) {
                if (src instanceof IBBSReference) {
                    refChild.createLink(src.getName(), ((IBBSReference)((Object)src)).getURL(), location);
                } else {
                    IBookmarkTreeNode target = refChild.createFolder(src.getName(), location);
                    IBookmarkTreeNode[] nodes = src.getChildren();
                    int i = 0;
                    while (i < nodes.length) {
                        this.cloneNode(nodes[i], target, 3);
                        ++i;
                    }
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        private final /* synthetic */ BookmarksView this$0;

        NameSorter(BookmarksView bookmarksView) {
            BookmarksView bookmarksView2 = bookmarksView;
            ((Object)((Object)bookmarksView2)).getClass();
            this.this$0 = bookmarksView2;
        }
    }

    private class BookmarksContentProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private final /* synthetic */ BookmarksView this$0;

        BookmarksContentProvider(BookmarksView bookmarksView) {
            BookmarksView bookmarksView2 = bookmarksView;
            ((Object)((Object)bookmarksView2)).getClass();
            this.this$0 = bookmarksView2;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IBookmarkTreeNode) {
                return ((IBookmarkTreeNode)inputElement).getChildren();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IBookmarkTreeNode) {
                return ((IBookmarkTreeNode)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IBookmarkTreeNode) {
                return ((IBookmarkTreeNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IBookmarkTreeNode) {
                return ((IBookmarkTreeNode)element).hasChildren();
            }
            return false;
        }

        public Image getImage(Object element) {
            if (element instanceof IBBSReference) {
                return MonalipsePlugin.getDefault().getLabelImageOf((IBBSReference)element);
            }
            boolean updated = element instanceof IBookmarkTreeNode && ((IBookmarkTreeNode)element).hasNewResponses();
            return MonalipsePlugin.getDefault().getOverlayImage(MonalipsePlugin.IMG_OBJ_FOLDER, false, updated, false);
        }

        public String getText(Object element) {
            if (element instanceof IBookmarkTreeNode) {
                return ((IBookmarkTreeNode)element).getName();
            }
            return "";
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MappedTreeViewer
    extends TreeViewer {
        private final /* synthetic */ BookmarksView this$0;

        public MappedTreeViewer(BookmarksView bookmarksView, Composite parent, int style) {
            BookmarksView bookmarksView2 = bookmarksView;
            ((Object)((Object)bookmarksView2)).getClass();
            this.this$0 = bookmarksView2;
            super(parent, style);
        }

        public Widget getWidgetOf(Object element) {
            return this.findItem(element);
        }
    }
}

