/*
 * Decompiled with CFR 0.152.
 */
package monalipse.views;

import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import monalipse.MonalipsePlugin;
import monalipse.editors.ThreadViewerEditor;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSReference;
import monalipse.server.IThreadContentProvider;
import monalipse.server.LinkedObject;
import monalipse.utils.CancelableRunner;
import monalipse.views.LinkedImagesView;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.threadpool.DefaultThreadPool;
import org.apache.commons.threadpool.ThreadPool;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class LinkedImagesView
extends ViewPart
implements SelectionListener,
ISelectionListener,
IResourceChangeListener,
IPartListener {
    public static final String ID_LINKED_IMAGES;
    private static final Logger logger;
    private TableViewer viewer;
    private IAction downloadAction;
    private IAction abortAction;
    private IAction doubleClickAction;
    private LinkedImagesContentProvider provider;
    private IThreadContentProvider thread;
    private CancelableRunner cancelable;
    private TreeEditor treeEditor;
    private boolean loading;
    private boolean active;
    private ArrayList loadQueue = new ArrayList();
    private ThreadPool downloadThreadPool = new DefaultThreadPool(4);
    private ThreadViewerEditor editor;
    private int textOffset;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.LinkedImagesView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_LINKED_IMAGES = clazz.getName();
        logger = MonalipsePlugin.getLogger();
    }

    public void createPartControl(Composite parent) {
        logger.finest("begin");
        this.viewer = new TableViewer(parent, 66306);
        this.provider = new LinkedImagesContentProvider(this);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.viewer.setInput((Object)this);
        FontData font = this.viewer.getTable().getFont().getFontData()[0];
        this.viewer.getTable().setFont(new Font((Device)this.getSite().getShell().getDisplay(), font.getName(), 47, font.getStyle()));
        this.makeColumns();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getTable().addSelectionListener((SelectionListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
        this.hookDragAndDrop();
        this.viewer.getTable().addPaintListener(new PaintListener(this){
            private final /* synthetic */ LinkedImagesView this$0;
            {
                LinkedImagesView linkedImagesView2 = linkedImagesView;
                ((Object)((Object)linkedImagesView2)).getClass();
                this.this$0 = linkedImagesView2;
            }

            public void paintControl(PaintEvent e) {
                if (this.this$0.viewer.getInput() instanceof LinkedObject[]) {
                    int itemHeight = this.this$0.viewer.getTable().getItemHeight();
                    int ox = 0;
                    if (this.this$0.viewer.getTable().getHorizontalBar() != null) {
                        ox = this.this$0.viewer.getTable().getHorizontalBar().getSelection();
                    }
                    int oy = 0;
                    if (this.this$0.viewer.getTable().getVerticalBar() != null) {
                        oy = this.this$0.viewer.getTable().getVerticalBar().getSelection() * itemHeight;
                    }
                    e.gc.setFont(this.this$0.getSite().getShell().getDisplay().getSystemFont());
                    LinkedObject[] nodes = (LinkedObject[])this.this$0.viewer.getInput();
                    int yoff = (itemHeight - e.gc.textExtent((String)"").y) / 2;
                    this.drawNodes(e, nodes, ox, oy, 0, yoff, -1);
                }
            }

            private int drawNodes(PaintEvent e, LinkedObject[] nodes, int ox, int oy, int y, int yoff, int responseNumber) {
                int i = 0;
                while (i < nodes.length) {
                    int itemHeight = this.this$0.viewer.getTable().getItemHeight();
                    if (responseNumber != nodes[i].getResponseNumber()) {
                        responseNumber = nodes[i].getResponseNumber();
                        e.gc.drawString(">>" + responseNumber, 1 - ox, 1 + y - oy, false);
                    }
                    e.gc.drawString(nodes[i].getName(), this.this$0.textOffset + 2 - ox, y + yoff - oy, true);
                    y += itemHeight;
                    ++i;
                }
                return y;
            }
        });
        this.viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(this){
            private final /* synthetic */ LinkedImagesView this$0;
            {
                LinkedImagesView linkedImagesView2 = linkedImagesView;
                ((Object)((Object)linkedImagesView2)).getClass();
                this.this$0 = linkedImagesView2;
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    this.this$0.downloadAction.run();
                }
            }
        });
        this.loading = true;
        Thread imageLoader = new Thread(new Runnable(this){
            private final /* synthetic */ LinkedImagesView this$0;
            {
                LinkedImagesView linkedImagesView2 = linkedImagesView;
                ((Object)((Object)linkedImagesView2)).getClass();
                this.this$0 = linkedImagesView2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                while (true) {
                    LinkedObject obj;
                    ArrayList arrayList = this.this$0.loadQueue;
                    synchronized (arrayList) {
                        while (true) {
                            if (!this.this$0.loading || !this.this$0.loadQueue.isEmpty()) {
                                if (!this.this$0.loadQueue.isEmpty()) break;
                                return;
                            }
                            this.this$0.loadQueue.trimToSize();
                            try {
                                this.this$0.loadQueue.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        obj = (LinkedObject)this.this$0.loadQueue.remove(0);
                    }
                    try {
                        if (!obj.loadImage()) continue;
                        this.this$0.getSite().getShell().getDisplay().asyncExec(new Runnable(this, obj){
                            private final /* synthetic */ LinkedObject val$obj;
                            private final /* synthetic */ 3 this$1;
                            {
                                3 v0 = var1_1;
                                v0.getClass();
                                this.this$1 = v0;
                                this.val$obj = linkedObject;
                            }

                            public void run() {
                                LinkedImagesView.access$5(3.access$0(this.this$1), this.val$obj);
                                LinkedImagesView.access$6(3.access$0(this.this$1));
                            }
                        });
                        continue;
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }

            static /* synthetic */ LinkedImagesView access$0(3 var0) {
                return var0.this$0;
            }
        });
        imageLoader.setPriority(1);
        imageLoader.start();
        logger.finest("done");
    }

    public void partActivated(IWorkbenchPart part) {
        this.update(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.update(part);
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this) {
            ArrayList arrayList = this.loadQueue;
            synchronized (arrayList) {
                this.loading = false;
                this.loadQueue.notify();
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part == this) {
            this.active = false;
        }
    }

    public void partOpened(IWorkbenchPart part) {
        this.update(part);
    }

    private void update(IWorkbenchPart part) {
        if (part instanceof ThreadViewerEditor) {
            LinkedObject[] linked;
            IThreadContentProvider cp = ((ThreadViewerEditor)part).getContentProvider();
            if (!(this.thread != null && cp != null && this.thread.equals(cp) || (linked = ((ThreadViewerEditor)part).getLinkedObjects()) == null)) {
                this.selectionChanged(linked);
                this.thread = cp;
                this.editor = (ThreadViewerEditor)part;
            }
        }
        if (part == this) {
            ArrayList arrayList = this.loadQueue;
            synchronized (arrayList) {
                this.active = true;
                this.loadQueue.notify();
            }
        }
    }

    private void update(LinkedObject obj) {
        logger.finest("begin");
        this.viewer.update((Object)obj, null);
        List<LinkedObject> list = Arrays.asList((LinkedObject[])this.viewer.getInput());
        int i = list.indexOf(obj);
        if (i != -1) {
            int oy = 0;
            if (this.viewer.getTable().getVerticalBar() != null) {
                oy = this.viewer.getTable().getVerticalBar().getSelection();
            }
            int itemHeight = this.viewer.getTable().getItemHeight();
            this.viewer.getTable().redraw(0, (i - oy) * itemHeight, this.viewer.getTable().getSize().x, itemHeight, true);
        }
        logger.finest("done");
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        logger.finest("begin");
        if (this.thread != null) {
            if (this.thread.threadChanged(event) && this.editor != null) {
                int scroll = 0;
                if (this.viewer.getTable().getVerticalBar() != null) {
                    scroll = this.viewer.getTable().getVerticalBar().getSelection();
                }
                ISelection sel = this.viewer.getSelection();
                this.selectionChanged(this.editor.getLinkedObjects());
                this.viewer.setSelection(sel);
                if (this.viewer.getTable().getVerticalBar() != null) {
                    this.viewer.getTable().getVerticalBar().setSelection(scroll);
                }
                this.textOffset = 0;
                this.packColumns();
            } else {
                LinkedObject[] nodes = LinkedObject.getChangedNodes((LinkedObject[])this.viewer.getInput(), event);
                if (nodes != null) {
                    ArrayList arrayList = this.loadQueue;
                    synchronized (arrayList) {
                        this.loadQueue.addAll(0, Arrays.asList(nodes));
                        this.loadQueue.notify();
                    }
                }
            }
        }
        logger.finest("done");
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IThreadContentProvider thread;
        int itemHeight;
        logger.finest("begin");
        if (!this.viewer.getTable().isDisposed() && selection instanceof IBBSReference && ((IBBSReference)selection).getResponseNumber() != -1 && LinkedObject.IMAGE_SIZE < (itemHeight = this.viewer.getTable().getItemHeight()) && (thread = BBSServerManager.getThreadContentProviderOf(((IBBSReference)selection).getURL())) != null && this.thread != null && this.thread.equals(thread)) {
            int sel = ((IBBSReference)selection).getResponseNumber();
            Object[] objs = this.provider.getElements(this.viewer.getInput());
            if (objs.length > 0) {
                int row = objs.length - 1;
                int i = 0;
                while (i < objs.length) {
                    if (sel <= ((LinkedObject)objs[i]).getResponseNumber()) {
                        row = i;
                        break;
                    }
                    ++i;
                }
                if (row >= 0 && row < objs.length) {
                    this.viewer.reveal(objs[row]);
                }
            }
        }
        logger.finest("done");
    }

    private void selectionChanged(LinkedObject[] linked) {
        logger.finest("begin");
        this.viewer.setInput((Object)linked);
        this.textOffset = 0;
        this.packColumns();
        logger.finest("done");
    }

    public void widgetSelected(SelectionEvent e) {
        Object first;
        logger.finest("begin");
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof LinkedObject) {
            LinkedObject node = (LinkedObject)first;
            if (this.editor != null) {
                this.editor.scrollTo(node.getResponseNumber());
            }
        }
        logger.finest("done");
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(this){
            private final /* synthetic */ LinkedImagesView this$0;
            {
                LinkedImagesView linkedImagesView2 = linkedImagesView;
                ((Object)((Object)linkedImagesView2)).getClass();
                this.this$0 = linkedImagesView2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.this$0.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalStatusBar(bars.getStatusLineManager());
    }

    private void fillLocalStatusBar(IStatusLineManager manager) {
        this.cancelable = new CancelableRunner(manager, this.getSite().getShell().getDisplay(), this.abortAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.downloadAction);
        manager.add(this.abortAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(this.downloadAction);
        manager.add(this.abortAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.downloadAction);
        manager.add(this.abortAction);
    }

    private void packColumns() {
        if (this.textOffset != this.viewer.getTable().getItemHeight()) {
            this.textOffset = this.viewer.getTable().getItemHeight();
            TableColumn[] columns = this.viewer.getTable().getColumns();
            columns[0].setWidth(this.textOffset);
            this.viewer.getTable().redraw();
        }
    }

    private void makeColumns() {
        Table table = this.viewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableColumn col = new TableColumn(table, 16384);
        col = new TableColumn(table, 16384);
        col.setWidth(200);
    }

    private void makeActions() {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)"monalipse").getDescriptor().getInstallURL();
        this.downloadAction = new Action(this){
            private final /* synthetic */ LinkedImagesView this$0;
            {
                LinkedImagesView linkedImagesView2 = linkedImagesView;
                ((Object)((Object)linkedImagesView2)).getClass();
                this.this$0 = linkedImagesView2;
            }

            public void run() {
                this.this$0.cancelable.run(null, new CancelableRunner.ICancelableRunnableWithProgress(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        6 v0 = var1_1;
                        ((Object)((Object)v0)).getClass();
                        this.this$1 = v0;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                        if (!(LinkedImagesView.access$1(6.access$0(this.this$1)).getInput() instanceof LinkedObject[])) return;
                        LinkedObject[] objects = (LinkedObject[])LinkedImagesView.access$1(6.access$0(this.this$1)).getInput();
                        monitor.beginTask("", objects.length);
                        monitor.subTask("downloading...");
                        SequencedHashMap map = new SequencedHashMap();
                        int i = 0;
                        while (i < objects.length) {
                            if (objects[i].isImage()) {
                                this.addWork((Map)map, objects[i]);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < objects.length) {
                            if (!objects[i].isImage()) {
                                this.addWork((Map)map, objects[i]);
                            }
                            ++i;
                        }
                        int[] remain = new int[]{objects.length};
                        List lists = map.sequence();
                        int i2 = 0;
                        while (i2 < lists.size()) {
                            List list = (List)map.get(lists.get(i2));
                            LinkedImagesView.access$9(6.access$0(this.this$1)).invokeLater(new Runnable(this, remain, list, monitor){
                                private final /* synthetic */ int[] val$remain;
                                private final /* synthetic */ List val$list;
                                private final /* synthetic */ CancelableRunner.ICancelableProgressMonitor val$monitor;
                                private final /* synthetic */ 7 this$2;
                                {
                                    7 v0 = var1_1;
                                    v0.getClass();
                                    this.this$2 = v0;
                                    this.val$remain = nArray;
                                    this.val$list = list;
                                    this.val$monitor = iCancelableProgressMonitor;
                                }

                                public void run() {
                                    try {
                                        int i = 0;
                                        while (i < this.val$list.size() && !this.val$monitor.isCanceled()) {
                                            LinkedObject obj = (LinkedObject)this.val$list.get(i);
                                            LinkedImagesView.access$10(6.access$0(7.access$0(this.this$2)), obj, false);
                                            this.val$monitor.worked(1);
                                            ++i;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_4 = null;
                                        int[] nArray = this.val$remain;
                                        synchronized (this.val$remain) {
                                            this.val$remain[0] = this.val$remain[0] - this.val$list.size();
                                            this.val$remain.notify();
                                            // ** MonitorExit[var5_6] (shouldn't be in output)
                                            throw throwable;
                                        }
                                    }
                                    Object var3_5 = null;
                                    int[] nArray = this.val$remain;
                                    synchronized (this.val$remain) {
                                        this.val$remain[0] = this.val$remain[0] - this.val$list.size();
                                        this.val$remain.notify();
                                        // ** MonitorExit[var5_7] (shouldn't be in output)
                                        return;
                                    }
                                }
                            });
                            ++i2;
                        }
                        int[] nArray = remain;
                        synchronized (remain) {
                            try {
                                while (remain[0] > 0 && !monitor.isCanceled()) {
                                    remain.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {}
                            monitor.done();
                            return;
                        }
                    }

                    public void addWork(Map map, LinkedObject node) {
                        ArrayList<LinkedObject> list = (ArrayList<LinkedObject>)map.get(node.getURL().getHost());
                        if (list == null) {
                            list = new ArrayList<LinkedObject>();
                            map.put(node.getURL().getHost(), list);
                        }
                        list.add(node);
                    }

                    static /* synthetic */ 6 access$0(7 var0) {
                        return var0.this$1;
                    }
                });
            }

            static /* synthetic */ LinkedImagesView access$0(6 var0) {
                return var0.this$0;
            }
        };
        this.downloadAction.setText("Download Images");
        this.downloadAction.setToolTipText("Download Images");
        try {
            this.downloadAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "refresh_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.abortAction = new Action(this){
            private final /* synthetic */ LinkedImagesView this$0;
            {
                LinkedImagesView linkedImagesView2 = linkedImagesView;
                ((Object)((Object)linkedImagesView2)).getClass();
                this.this$0 = linkedImagesView2;
            }

            public void run() {
                this.this$0.cancelable.cancel();
            }
        };
        this.abortAction.setText("Abort");
        this.abortAction.setToolTipText("Abort downloading images");
        this.abortAction.setEnabled(false);
        try {
            this.abortAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "stop_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.doubleClickAction = new Action(this){
            private final /* synthetic */ LinkedImagesView this$0;
            {
                LinkedImagesView linkedImagesView2 = linkedImagesView;
                ((Object)((Object)linkedImagesView2)).getClass();
                this.this$0 = linkedImagesView2;
            }

            public void run() {
                Object first;
                ISelection selection = this.this$0.viewer.getSelection();
                if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof LinkedObject) {
                    LinkedObject obj = (LinkedObject)first;
                    IFile file = obj.getCachedFile();
                    try {
                        MonalipsePlugin.ensureSynchronized(file);
                        if (file.exists()) {
                            Program.launch((String)file.getLocation().toOSString());
                        } else {
                            this.this$0.cancelable.run(null, new CancelableRunner.ICancelableRunnableWithProgress(this, obj){
                                private final /* synthetic */ LinkedObject val$obj;
                                private final /* synthetic */ 10 this$1;
                                {
                                    10 v0 = var1_1;
                                    ((Object)((Object)v0)).getClass();
                                    this.this$1 = v0;
                                    this.val$obj = linkedObject;
                                }

                                public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                                    monitor.beginTask("", 2);
                                    monitor.subTask("downloading...");
                                    monitor.worked(1);
                                    LinkedImagesView.access$10(10.access$0(this.this$1), this.val$obj, true);
                                    monitor.worked(1);
                                    monitor.done();
                                }
                            });
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }

            static /* synthetic */ LinkedImagesView access$0(10 var0) {
                return var0.this$0;
            }
        };
    }

    private void fetchImage(LinkedObject obj, boolean force) {
        block12: {
            boolean success = false;
            try {
                try {
                    success = obj.fetchObject(this.getSite().getWorkbenchWindow(), force);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Object var4_4 = null;
                    if (!success && obj.loadImage()) {
                        this.getSite().getShell().getDisplay().asyncExec(new Runnable(this, obj){
                            private final /* synthetic */ LinkedObject val$obj;
                            private final /* synthetic */ LinkedImagesView this$0;
                            {
                                LinkedImagesView linkedImagesView2 = linkedImagesView;
                                ((Object)((Object)linkedImagesView2)).getClass();
                                this.this$0 = linkedImagesView2;
                                this.val$obj = linkedObject;
                            }

                            public void run() {
                                this.this$0.update(this.val$obj);
                                this.this$0.packColumns();
                            }
                        });
                    }
                    return;
                }
                catch (ConnectException connectException) {
                    Object var4_5 = null;
                    if (!success && obj.loadImage()) {
                        this.getSite().getShell().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                    return;
                }
                catch (UnknownHostException unknownHostException) {
                    Object var4_6 = null;
                    if (!success && obj.loadImage()) {
                        this.getSite().getShell().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                    return;
                }
                catch (Exception exception) {
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                if (!success && obj.loadImage()) {
                    this.getSite().getShell().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                }
                throw throwable;
            }
            Object var4_8 = null;
            if (success || !obj.loadImage()) break block12;
            this.getSite().getShell().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(this){
            private final /* synthetic */ LinkedImagesView this$0;
            {
                LinkedImagesView linkedImagesView2 = linkedImagesView;
                ((Object)((Object)linkedImagesView2)).getClass();
                this.this$0 = linkedImagesView2;
            }

            public void doubleClick(DoubleClickEvent event) {
                this.this$0.doubleClickAction.run();
            }
        });
    }

    private void hookDragAndDrop() {
        DragSource dragSource = new DragSource((Control)this.viewer.getTable(), 1);
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(this){
            private final /* synthetic */ LinkedImagesView this$0;
            {
                LinkedImagesView linkedImagesView2 = linkedImagesView;
                ((Object)((Object)linkedImagesView2)).getClass();
                this.this$0 = linkedImagesView2;
            }

            public void dragStart(DragSourceEvent event) {
                Object first;
                ISelection selection = this.this$0.viewer.getSelection();
                if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof LinkedObject) {
                    Object[] nodes = ((IStructuredSelection)selection).toArray();
                    int i = 0;
                    while (i < nodes.length) {
                        IFile file = ((LinkedObject)nodes[i]).getCachedFile();
                        try {
                            MonalipsePlugin.ensureSynchronized(file);
                            if (file.exists()) {
                                event.doit = true;
                                return;
                            }
                        }
                        catch (CoreException coreException) {}
                        ++i;
                    }
                }
                event.doit = false;
            }

            public void dragSetData(DragSourceEvent event) {
                Object first;
                ISelection selection = this.this$0.viewer.getSelection();
                if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof LinkedObject) {
                    Object[] nodes = ((IStructuredSelection)selection).toArray();
                    ArrayList<String> list = new ArrayList<String>();
                    int i = 0;
                    while (i < nodes.length) {
                        IFile file = ((LinkedObject)nodes[i]).getCachedFile();
                        try {
                            MonalipsePlugin.ensureSynchronized(file);
                            if (file.exists()) {
                                list.add(file.getLocation().toOSString());
                            }
                        }
                        catch (CoreException coreException) {}
                        ++i;
                    }
                    String[] files = new String[list.size()];
                    list.toArray(files);
                    event.data = files;
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    static /* synthetic */ ThreadPool access$9(LinkedImagesView linkedImagesView) {
        return linkedImagesView.downloadThreadPool;
    }

    static /* synthetic */ void access$10(LinkedImagesView linkedImagesView, LinkedObject linkedObject, boolean bl) {
        linkedImagesView.fetchImage(linkedObject, bl);
    }

    class NameSorter
    extends ViewerSorter {
        private final /* synthetic */ LinkedImagesView this$0;

        NameSorter(LinkedImagesView linkedImagesView) {
            LinkedImagesView linkedImagesView2 = linkedImagesView;
            ((Object)((Object)linkedImagesView2)).getClass();
            this.this$0 = linkedImagesView2;
        }
    }

    private class LinkedImagesContentProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private Map imageMap;
        private Device device;
        private final /* synthetic */ LinkedImagesView this$0;

        LinkedImagesContentProvider(LinkedImagesView linkedImagesView) {
            LinkedImagesView linkedImagesView2 = linkedImagesView;
            ((Object)((Object)linkedImagesView2)).getClass();
            this.this$0 = linkedImagesView2;
            this.imageMap = new HashMap();
            this.device = linkedImagesView.getSite().getShell().getDisplay();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof LinkedObject[]) {
                return (LinkedObject[])inputElement;
            }
            return new Object[0];
        }

        public Image getImage(Object element) {
            if (element instanceof LinkedObject) {
                return ((LinkedObject)element).getImage(this.device);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof LinkedObject) {
                return ((LinkedObject)element).getName();
            }
            return element.toString();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            int reuse = 0;
            if (oldInput instanceof LinkedObject[] && newInput instanceof LinkedObject[]) {
                LinkedObject[] oi = (LinkedObject[])oldInput;
                LinkedObject[] ni = (LinkedObject[])newInput;
                int i = 0;
                while (i < oi.length && i < ni.length) {
                    if (!oi[i].equals(ni[i])) break;
                    ++reuse;
                    ni[i] = oi[i];
                    ++i;
                }
            }
            if (oldInput instanceof LinkedObject[]) {
                LinkedObject[] objs = (LinkedObject[])oldInput;
                int i = reuse;
                while (i < objs.length) {
                    objs[i].dispose();
                    ++i;
                }
            }
            ArrayList arrayList = this.this$0.loadQueue;
            synchronized (arrayList) {
                this.this$0.loadQueue.clear();
                if (newInput instanceof LinkedObject[]) {
                    this.this$0.loadQueue.addAll(Arrays.asList((LinkedObject[])newInput));
                }
                this.this$0.loadQueue.notify();
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return "";
        }
    }
}

