/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NTLM;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Authenticator {
    private static final Log log;
    public static final String PREEMPTIVE_PROPERTY = "httpclient.authentication.preemptive";
    public static final String PREEMPTIVE_DEFAULT = "false";
    public static final String WWW_AUTH = "WWW-Authenticate";
    public static final String WWW_AUTH_RESP = "Authorization";
    public static final String PROXY_AUTH = "Proxy-Authenticate";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";
    private static final char[] HEXADECIMAL;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.Authenticator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public static String createDigest(String uname, String pwd, Map mapCredentials) throws HttpException {
        MessageDigest md5Helper;
        log.trace((Object)"enter Authenticator.createDigest(String, String, Map)");
        String digAlg = "MD5";
        String uri = Authenticator.removeQuotes((String)mapCredentials.get("uri"));
        String realm = Authenticator.removeQuotes((String)mapCredentials.get("realm"));
        String nonce = Authenticator.removeQuotes((String)mapCredentials.get("nonce"));
        String nc = Authenticator.removeQuotes((String)mapCredentials.get("nc"));
        String cnonce = Authenticator.removeQuotes((String)mapCredentials.get("cnonce"));
        String qop = Authenticator.removeQuotes((String)mapCredentials.get("qop"));
        String method = (String)mapCredentials.get("methodname");
        if (qop != null) {
            qop = "auth";
        }
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            log.error((Object)"ERROR! Unsupported algorithm in HTTP Digest authentication: MD5", (Throwable)e);
            throw new HttpException("Unsupported algorithm in HTTP Digest authentication: MD5");
        }
        String a2 = String.valueOf(method) + ":" + uri;
        String md5a2 = Authenticator.encode(md5Helper.digest(a2.getBytes()));
        String digestValue = String.valueOf(uname) + ":" + realm + ":" + pwd;
        String md5a1 = Authenticator.encode(md5Helper.digest(digestValue.getBytes()));
        String serverDigestValue = qop == null ? String.valueOf(md5a1) + ":" + nonce + ":" + md5a2 : String.valueOf(md5a1) + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        String serverDigest = Authenticator.encode(md5Helper.digest(serverDigestValue.getBytes()));
        return serverDigest;
    }

    public static boolean authenticate(HttpMethod method, HttpState state) throws HttpException, UnsupportedOperationException {
        log.trace((Object)"enter Authenticator.authenticate(HttpMethod, HttpState)");
        Header challengeHeader = method.getResponseHeader(WWW_AUTH);
        return Authenticator.authenticate(method, state, challengeHeader, WWW_AUTH_RESP);
    }

    public static boolean authenticateProxy(HttpMethod method, HttpState state) throws HttpException, UnsupportedOperationException {
        log.trace((Object)"enter Authenticator.authenticateProxy(HttpMethod, HttpState)");
        Header challengeHeader = method.getResponseHeader(PROXY_AUTH);
        return Authenticator.authenticate(method, state, challengeHeader, PROXY_AUTH_RESP);
    }

    private static String basic(UsernamePasswordCredentials credentials) {
        log.trace((Object)"enter Authenticator.basic(UsernamePasswordCredentials)");
        String authString = String.valueOf(credentials.getUserName()) + ":" + credentials.getPassword();
        return "Basic " + new String(Base64.encode(authString.getBytes()));
    }

    private static Header basic(String realm, HttpState state, String responseHeader) throws HttpException {
        log.trace((Object)"enter Authenticator.basic(String, HttpState, String)");
        boolean proxy = PROXY_AUTH_RESP.equals(responseHeader);
        UsernamePasswordCredentials credentials = null;
        try {
            credentials = (UsernamePasswordCredentials)(proxy ? state.getProxyCredentials(realm) : state.getCredentials(realm));
        }
        catch (ClassCastException e) {
            throw new HttpException("UsernamePasswordCredentials required for Basic authentication.");
        }
        if (credentials == null) {
            throw new HttpException("No credentials available for the Basic authentication realm '" + realm + "'");
        }
        return new Header(responseHeader, Authenticator.basic(credentials));
    }

    private static Header ntlm(String challenge, HttpMethod method, HttpState state, String responseHeader) throws HttpException {
        log.trace((Object)"enter Authenticator.ntlm(String, HttpMethod, HttpState, String)");
        boolean proxy = PROXY_AUTH_RESP.equals(responseHeader);
        NTCredentials credentials = null;
        if (method.getRequestHeader("Host") != null) {
            String host = method.getRequestHeader("Host").getValue();
            try {
                credentials = (NTCredentials)(proxy ? state.getProxyCredentials(host) : state.getCredentials(host));
            }
            catch (ClassCastException e) {
                throw new HttpException("NTCredentials required for NTLM authentication.");
            }
        }
        if (credentials == null) {
            log.info((Object)"No credentials for specific host, attempting to use default credentials.");
            try {
                credentials = (NTCredentials)(proxy ? state.getProxyCredentials(null) : state.getCredentials(null));
            }
            catch (ClassCastException e) {
                throw new HttpException("NTCredentials required for NTLM authentication.");
            }
        }
        try {
            challenge = challenge.substring(challenge.toLowerCase().indexOf("ntlm") + "ntlm".length()).trim();
        }
        catch (IndexOutOfBoundsException e) {
            throw new HttpException("Invalid NTLM challenge.");
        }
        if (credentials == null) {
            throw new HttpException("No credentials available for NTLM authentication.");
        }
        try {
            NTLM ntlm = new NTLM();
            String response = "NTLM " + ntlm.getResponseFor(challenge, credentials.getUserName(), credentials.getPassword(), credentials.getHost(), credentials.getDomain());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replying to challenge with: " + response));
            }
            return new Header(responseHeader, response);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpException("NTLM requires ASCII support.");
        }
    }

    private static Header digest(String realm, HttpMethod method, HttpState state, String responseHeader) throws HttpException {
        log.trace((Object)"enter Authenticator.digest(String, HttpMethod, HttpState, String)");
        boolean proxy = PROXY_AUTH_RESP.equals(responseHeader);
        UsernamePasswordCredentials credentials = null;
        try {
            credentials = (UsernamePasswordCredentials)(proxy ? state.getProxyCredentials(realm) : state.getCredentials(realm));
        }
        catch (ClassCastException e) {
            throw new HttpException("UsernamePasswordCredentials required for Digest authentication.");
        }
        if (credentials == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No credentials found for realm \"" + realm + "\", " + "attempting to use default credentials."));
            }
            try {
                credentials = (UsernamePasswordCredentials)(proxy ? state.getProxyCredentials(null) : state.getCredentials(null));
            }
            catch (ClassCastException e) {
                throw new HttpException("UsernamePasswordCredentials required for Digest authentication.");
            }
        }
        if (credentials == null) {
            throw new HttpException("No credentials available for the Digest authentication realm \"" + realm + "\"/");
        }
        Map headers = Authenticator.getHTTPDigestCredentials(method, proxy);
        headers.put("cnonce", "\"" + Authenticator.createCnonce() + "\"");
        headers.put("nc", "00000001");
        headers.put("uri", method.getPath());
        headers.put("methodname", method.getName());
        return new Header(responseHeader, Authenticator.digest(credentials, headers));
    }

    private static String digest(UsernamePasswordCredentials credentials, Map mapHeaders) throws HttpException {
        log.trace((Object)"enter Authenticator.digest(UsernamePasswordCredentials, Map)");
        String digest = Authenticator.createDigest(credentials.getUserName(), credentials.getPassword(), mapHeaders);
        return "Digest " + Authenticator.createDigestHeader(credentials.getUserName(), mapHeaders, digest);
    }

    private static Map getHTTPDigestCredentials(HttpMethod method, boolean proxy) {
        log.trace((Object)"enter Authenticator.getHTTPDigestCredentials(HttpMethod, boolean)");
        String authName = proxy ? PROXY_AUTH : WWW_AUTH;
        String authHeader = null;
        try {
            authHeader = method.getResponseHeader(authName).getValue();
            authHeader = authHeader.substring(7).trim();
        }
        catch (NullPointerException npe) {
            return new Hashtable(0);
        }
        Hashtable mapTokens = new Hashtable(17);
        int i = 0;
        int j = authHeader.indexOf(",");
        while (j >= 0) {
            Authenticator.processDigestToken(authHeader.substring(i, j), mapTokens);
            i = j + 1;
            j = authHeader.indexOf(",", i);
        }
        if (i < authHeader.length()) {
            Authenticator.processDigestToken(authHeader.substring(i), mapTokens);
        }
        return mapTokens;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map parseAuthenticateHeader(Header authHeader) {
        log.trace((Object)"enter parseAuthenticateHeader(Header)");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to parse authenticate header: '" + authHeader + "'"));
        }
        if (authHeader == null) return new Hashtable(0);
        if (authHeader.getValue() == null) {
            return new Hashtable(0);
        }
        String authValue = authHeader.getValue().trim();
        Hashtable<String, String> challengeMap = new Hashtable<String, String>(7);
        int authValueLength = authValue.length();
        int atStart = authValueLength > 0 ? 0 : -1;
        int atQuote1 = 0;
        int atQuote2 = 0;
        String challenge = null;
        String scheme = null;
        try {
            block4: while (true) {
                if (atStart < 0) return challengeMap;
                if (atStart >= authValueLength) {
                    return challengeMap;
                }
                atQuote1 = authValue.indexOf(34, atStart);
                atQuote2 = authValue.indexOf(34, atQuote1 + 1);
                int atComma = authValue.indexOf(44, atStart);
                while (true) {
                    if (atComma <= atQuote1 || atComma >= atQuote2 || atComma <= 0) {
                        if (atComma < 0) {
                            atComma = authValueLength;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("atStart =" + atStart + ", atQuote1 =" + atQuote1 + ", atQuote2=" + atQuote2 + ", atComma =" + atComma));
                        }
                        try {
                            challenge = authValue.substring(atStart, atComma).trim();
                            atStart = atComma + 1;
                            int atSpace = challenge.indexOf(32);
                            scheme = atSpace > 0 ? challenge.substring(0, atSpace).trim() : challenge;
                            challengeMap.put(scheme.toLowerCase(), challenge);
                            if (!log.isDebugEnabled()) continue block4;
                            log.debug((Object)(String.valueOf(scheme.toLowerCase()) + "=>" + challenge));
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            log.warn((Object)("Parsing authorization challenge'" + challenge + "' failed"), (Throwable)e);
                        }
                        continue block4;
                    }
                    atComma = authValue.indexOf(44, atComma + 1);
                }
                break;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            log.warn((Object)("Parsing authorization header value'" + authValue + "' failed"), (Throwable)e);
        }
        return challengeMap;
    }

    private static boolean authenticate(HttpMethod method, HttpState state, Header authenticateHeader, String responseHeader) throws HttpException, UnsupportedOperationException {
        log.trace((Object)"enter Authenticator.authenticate(HttpMethod, HttpState, Header, String)");
        String preemptiveDefault = System.getProperties().getProperty(PREEMPTIVE_PROPERTY, PREEMPTIVE_DEFAULT);
        preemptiveDefault = preemptiveDefault.trim().toLowerCase();
        if (!preemptiveDefault.equals("true") && !preemptiveDefault.equals(PREEMPTIVE_DEFAULT)) {
            log.warn((Object)"Configuration property httpclient.authentication.preemptive must be either true or false.  Using default: false");
            preemptiveDefault = PREEMPTIVE_DEFAULT;
        }
        boolean preemptive = "true".equals(preemptiveDefault);
        if (authenticateHeader == null) {
            if (preemptive) {
                log.debug((Object)"Preemptively sending default basic credentials");
                try {
                    Header requestHeader = Authenticator.basic(null, state, responseHeader);
                    method.addRequestHeader(requestHeader);
                    return true;
                }
                catch (HttpException httpe) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No default credentials to preemptively send");
                    }
                    return false;
                }
            }
            return false;
        }
        Map challengeMap = Authenticator.parseAuthenticateHeader(authenticateHeader);
        Header requestHeader = null;
        if (challengeMap.containsKey("ntlm")) {
            String challenge = (String)challengeMap.get("ntlm");
            requestHeader = Authenticator.ntlm(challenge, method, state, responseHeader);
        } else if (challengeMap.containsKey("digest")) {
            String challenge = (String)challengeMap.get("digest");
            String realm = Authenticator.parseRealmFromChallenge(challenge);
            requestHeader = Authenticator.digest(realm, method, state, responseHeader);
        } else if (challengeMap.containsKey("basic")) {
            String challenge = (String)challengeMap.get("basic");
            String realm = Authenticator.parseRealmFromChallenge(challenge);
            requestHeader = Authenticator.basic(realm, state, responseHeader);
        } else {
            if (challengeMap.size() == 0) {
                throw new HttpException("No authentication scheme found in '" + authenticateHeader + "'");
            }
            throw new UnsupportedOperationException("Requested authentication scheme " + challengeMap.keySet() + " is unsupported");
        }
        if (requestHeader != null) {
            method.addRequestHeader(requestHeader);
            return true;
        }
        return false;
    }

    private static String createCnonce() throws HttpException {
        MessageDigest md5Helper;
        log.trace((Object)"enter Authenticator.createCnonce()");
        String digAlg = "MD5";
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            log.error((Object)"ERROR! Unsupported algorithm in HTTP Digest authentication: MD5");
            throw new HttpException("Unsupported algorithm in HTTP Digest authentication: MD5");
        }
        String cnonce = Long.toString(System.currentTimeMillis());
        cnonce = Authenticator.encode(md5Helper.digest(cnonce.getBytes()));
        return cnonce;
    }

    private static String createDigestHeader(String uname, Map mapCredentials, String digest) {
        log.trace((Object)"enter Authenticator.createDigestHeader(String, Map, String)");
        StringBuffer sb = new StringBuffer();
        String uri = Authenticator.removeQuotes((String)mapCredentials.get("uri"));
        String realm = Authenticator.removeQuotes((String)mapCredentials.get("realm"));
        String nonce = Authenticator.removeQuotes((String)mapCredentials.get("nonce"));
        String nc = Authenticator.removeQuotes((String)mapCredentials.get("nc"));
        String cnonce = Authenticator.removeQuotes((String)mapCredentials.get("cnonce"));
        String opaque = Authenticator.removeQuotes((String)mapCredentials.get("opaque"));
        String response = digest;
        String qop = Authenticator.removeQuotes((String)mapCredentials.get("qop"));
        if (qop != null) {
            qop = "auth";
        }
        String algorithm = "MD5";
        sb.append("username=\"" + uname + "\"").append(", realm=\"" + realm + "\"").append(", nonce=\"" + nonce + "\"").append(", uri=\"" + uri + "\"").append(qop == null ? "" : ", qop=\"" + qop + "\"").append(", algorithm=\"" + algorithm + "\"").append(qop == null ? "" : ", nc=" + nc).append(qop == null ? "" : ", cnonce=\"" + cnonce + "\"").append(", response=\"" + response + "\"").append(opaque == null ? "" : ", opaque=\"" + opaque + "\"");
        return sb.toString();
    }

    private static String encode(byte[] binaryData) {
        log.trace((Object)"enter Authenticator.encode(byte[])");
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        int i = 0;
        while (i < 16) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
            ++i;
        }
        return new String(buffer);
    }

    private static String parseRealmFromChallenge(String challenge) throws HttpException {
        try {
            StringTokenizer strtok = new StringTokenizer(challenge, "=");
            String realmName = strtok.nextToken().trim();
            String realm = strtok.nextToken().trim();
            int atFirst = realm.indexOf(34);
            int atLast = realm.lastIndexOf(34);
            if (atFirst + 1 < atLast) {
                realm = realm.substring(atFirst + 1, atLast);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsed realm '" + realm + "' from challenge '" + challenge + "'"));
            }
            return realm;
        }
        catch (Exception ex) {
            throw new HttpException("Failed to parse realm from challenge '" + challenge + "'");
        }
    }

    private static void processDigestToken(String token, Map tokens) {
        log.trace((Object)"enter Authenticator.processDigestToken(String, Map)");
        int atEqual = token.indexOf("=");
        if (atEqual > 0 && atEqual < token.length() - 1) {
            tokens.put(token.substring(0, atEqual).trim(), token.substring(atEqual + 1).trim());
        }
    }

    private static String removeQuotes(String str) {
        log.trace((Object)"enter Authenticator.removeQuotes(String)");
        if (str == null) {
            return null;
        }
        int atFirst = str.indexOf("\"") + 1;
        int atLast = str.lastIndexOf("\"");
        return atFirst > 0 && atLast > atFirst ? str.substring(atFirst, atLast) : str;
    }
}

