/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.Serializable;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cookie
extends NameValuePair
implements Serializable,
Comparator {
    private String _comment;
    private String _domain;
    private Date _expiryDate;
    private String _path;
    private boolean _secure;
    private boolean _hasPathAttribute = false;
    private boolean _hasDomainAttribute = false;
    private int _version = 1;
    private static final DateFormat[] expiryFormats = new DateFormat[]{new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE dd-MMM-yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE dd-MMM-yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE dd MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE dd MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd-MMM-yyyy HH-mm-ss z", Locale.US), new SimpleDateFormat("EEE dd-MMM-yyyy HH-mm-ss z", Locale.US)};
    private static final RuleBasedCollator stringCollator = (RuleBasedCollator)Collator.getInstance(new Locale("en", "US", ""));
    private static final String PATH_DELIM = "/";
    private static final char PATH_DELIM_CHAR = "/".charAt(0);
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.Cookie");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Cookie() {
        this(null, "noname", null, null, null, false);
    }

    public Cookie(String domain, String name, String value) {
        this(domain, name, value, null, null, false);
    }

    public Cookie(String domain, String name, String value, String path, Date expires, boolean secure) {
        super(name, value);
        log.trace((Object)"enter Cookie(String, String, String, String, Date, boolean)");
        if (name == null) {
            throw new IllegalArgumentException("Cookie name may not be null");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Cookie name may not be blank");
        }
        this.setPath(path);
        this.setDomain(domain);
        this.setExpiryDate(expires);
        this.setSecure(secure);
    }

    public Cookie(String domain, String name, String value, String path, int maxAge, boolean secure) {
        this(domain, name, value, path, new Date(System.currentTimeMillis() + (long)maxAge * 1000L), secure);
    }

    public String getComment() {
        return this._comment;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public Date getExpiryDate() {
        return this._expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this._expiryDate = expiryDate;
    }

    public boolean isPersistent() {
        return this._expiryDate != null;
    }

    public String getDomain() {
        return this._domain;
    }

    public void setDomain(String domain) {
        if (domain != null) {
            int ndx = domain.indexOf(":");
            if (ndx != -1) {
                domain = domain.substring(0, ndx);
            }
            this._domain = domain.toLowerCase();
        }
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public boolean getSecure() {
        return this._secure;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public boolean isExpired() {
        return this._expiryDate != null && this._expiryDate.getTime() <= System.currentTimeMillis();
    }

    public boolean isExpired(Date now) {
        return this._expiryDate != null && this._expiryDate.getTime() <= now.getTime();
    }

    public void setPathAttributeSpecified(boolean value) {
        this._hasPathAttribute = value;
    }

    public boolean isPathAttributeSpecified() {
        return this._hasPathAttribute;
    }

    public void setDomainAttributeSpecified(boolean value) {
        this._hasDomainAttribute = value;
    }

    public boolean isDomainAttributeSpecified() {
        return this._hasDomainAttribute;
    }

    public int hashCode() {
        return super.hashCode() ^ (this._path == null ? 0 : this._path.hashCode()) ^ (this._domain == null ? 0 : this._domain.hashCode());
    }

    public boolean equals(Object obj) {
        log.trace((Object)"enter Cookie.equals(Object)");
        if (obj != null && obj instanceof Cookie) {
            Cookie that = (Cookie)obj;
            return (this.getName() == null ? that.getName() == null : this.getName().equals(that.getName())) && (this.getPath() == null ? that.getPath() == null : this.getPath().equals(that.getPath())) && (this.getDomain() == null ? that.getDomain() == null : this.getDomain().equals(that.getDomain()));
        }
        return false;
    }

    public String toExternalForm() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append("=").append(this.getValue());
        if (this._path != null && this.isPathAttributeSpecified()) {
            buf.append("; $Path=");
            buf.append(this._path);
        }
        if (this._domain != null && this.isDomainAttributeSpecified()) {
            buf.append("; $Domain=");
            buf.append(this._domain);
        }
        return buf.toString();
    }

    public boolean matches(String domain, int port, String path, boolean secure, Date date) {
        log.trace((Object)"enter Cookie.matches(Strinng, int, String, boolean, Date");
        if (domain == null) {
            throw new IllegalArgumentException("domain parameter may not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path parameter may not be null");
        }
        if (date == null) {
            throw new IllegalArgumentException("date parameter may not be null");
        }
        if (this.getDomain() == null) {
            log.warn((Object)"Invalid cookie state: domain not specified");
            return false;
        }
        if (this.getPath() == null) {
            log.warn((Object)"Invalid cookie state: path not specified");
            return false;
        }
        domain = domain.toLowerCase();
        return !(this.getExpiryDate() != null && !this.getExpiryDate().after(date) || !Cookie.domainMatch(domain, this.getDomain()) || !Cookie.pathMatch(path, this.getPath()) || this.getSecure() && !secure);
    }

    public boolean matches(String domain, int port, String path, boolean secure) {
        log.trace((Object)"enter Cookie.matches(String, int, String, boolean");
        return this.matches(domain, port, path, secure, new Date());
    }

    public static Header createCookieHeader(String domain, String path, Cookie[] cookies) {
        log.trace((Object)"enter Cookie.createCookieHeader(String, String, Cookie[])");
        return Cookie.createCookieHeader(domain, path, false, cookies);
    }

    public static Header createCookieHeader(String domain, String path, boolean secure, Cookie[] cookies) throws IllegalArgumentException {
        log.trace((Object)"enter Cookie.createCookieHeader(String, String, boolean, Cookie[])");
        if (domain == null) {
            throw new IllegalArgumentException("null domain in createCookieHeader.");
        }
        int port = secure ? 443 : 80;
        int ndx = domain.indexOf(":");
        if (ndx != -1) {
            try {
                port = Integer.parseInt(domain.substring(ndx + 1, domain.length()));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Cookie.createCookieHeader():  Invalid port number in domain " + domain));
            }
        }
        return Cookie.createCookieHeader(domain, port, path, secure, cookies);
    }

    public static Header createCookieHeader(String domain, int port, String path, boolean secure, Cookie[] cookies) throws IllegalArgumentException {
        log.trace((Object)"enter Cookie.createCookieHeader(String, int, String, boolean, Cookie[])");
        return Cookie.createCookieHeader(domain, port, path, secure, new Date(), cookies);
    }

    public static Header createCookieHeader(String domain, int port, String path, boolean secure, Date now, Cookie[] cookies) throws IllegalArgumentException {
        log.trace((Object)"enter Cookie.createCookieHeader(String, int, String, boolean, Date, Cookie[])");
        if (domain == null) {
            throw new IllegalArgumentException("null domain in createCookieHeader.");
        }
        if (path == null) {
            throw new IllegalArgumentException("null path in createCookieHeader.");
        }
        boolean added = false;
        StringBuffer value = new StringBuffer();
        if (cookies.length <= 0) {
            return null;
        }
        LinkedList addedCookies = new LinkedList();
        int i = 0;
        while (i < cookies.length) {
            if (cookies[i].matches(domain, port, path, secure, now)) {
                Cookie.addInPathOrder(addedCookies, cookies[i]);
                added = true;
            }
            ++i;
        }
        if (added) {
            value.append("$Version=");
            value.append(((Cookie)addedCookies.get(0)).getVersion());
            Iterator itr = addedCookies.iterator();
            while (itr.hasNext()) {
                Cookie cookie = (Cookie)itr.next();
                value.append("; ");
                value.append(cookie.toExternalForm());
            }
            return new Header("Cookie", value.toString());
        }
        return null;
    }

    public int compare(Object o1, Object o2) {
        log.trace((Object)"enter Cookie.compare(Object, Object)");
        if (!(o1 instanceof Cookie)) {
            throw new ClassCastException(o1.getClass().getName());
        }
        if (!(o2 instanceof Cookie)) {
            throw new ClassCastException(o2.getClass().getName());
        }
        Cookie c1 = (Cookie)o1;
        Cookie c2 = (Cookie)o2;
        if (c1.getPath() == null && c2.getPath() == null) {
            return 0;
        }
        if (c1.getPath() == null) {
            if (c2.getPath().equals(PATH_DELIM)) {
                return 0;
            }
            return -1;
        }
        if (c2.getPath() == null) {
            if (c1.getPath().equals(PATH_DELIM)) {
                return 0;
            }
            return 1;
        }
        return stringCollator.compare(c1.getPath(), c2.getPath());
    }

    public String toString() {
        return this.toExternalForm();
    }

    public static Cookie[] parse(String domain, int port, String path, Header setCookie) throws HttpException, IllegalArgumentException {
        log.trace((Object)"enter Cookie.parse(String, int, String, Header)");
        return Cookie.parse(domain, port, path, false, setCookie);
    }

    public static Cookie[] parse(String domain, String path, Header setCookie) throws HttpException, IllegalArgumentException {
        log.trace((Object)"enter Cookie.parse(String, String, Header)");
        return Cookie.parse(domain, 80, path, false, setCookie);
    }

    public static Cookie[] parse(String domain, String path, boolean secure, Header setCookie) throws HttpException {
        log.trace((Object)"enter Cookie.parse(String, String, boolean, Header)");
        return Cookie.parse(domain, secure ? 443 : 80, path, secure, setCookie);
    }

    public static Cookie[] parse(String domain, int port, String path, boolean secure, Header setCookie) throws HttpException, IllegalArgumentException {
        log.trace((Object)"enter Cookie.parse(String, int, String, boolean, Header)");
        if (domain == null) {
            throw new IllegalArgumentException("domain may not be null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("path may not be null.");
        }
        if (setCookie == null) {
            throw new IllegalArgumentException("set-cookie header may not be null.");
        }
        domain = domain.toLowerCase();
        if (path.length() == 0) {
            log.debug((Object)"Fixing up empty request path.");
            path = PATH_DELIM;
        }
        String defaultPath = null;
        int lastSlashIndex = path.lastIndexOf(PATH_DELIM);
        defaultPath = lastSlashIndex == 0 ? PATH_DELIM : (lastSlashIndex > 0 ? path.substring(0, lastSlashIndex) : path);
        HeaderElement[] headerElements = HeaderElement.parse(setCookie.getValue());
        Cookie[] cookies = new Cookie[headerElements.length];
        int index = 0;
        int i = 0;
        while (i < headerElements.length) {
            HeaderElement headerelement = headerElements[i];
            Cookie cookie = new Cookie(domain, headerelement.getName(), headerelement.getValue(), defaultPath, null, false);
            NameValuePair[] parameters = headerelement.getParameters();
            if (parameters != null) {
                int j = 0;
                while (j < parameters.length) {
                    String param_name = parameters[j].getName().toLowerCase();
                    String param_value = parameters[j].getValue();
                    if (param_name.equals("version")) {
                        if (param_value == null) {
                            throw new HttpException("Missing value for version attribute");
                        }
                        try {
                            cookie.setVersion(Integer.parseInt(param_value));
                        }
                        catch (NumberFormatException e) {
                            throw new HttpException("Invalid version attribute: " + e.getMessage());
                        }
                    }
                    if (param_name.equals("path")) {
                        if (param_value == null) {
                            throw new HttpException("Missing value for path attribute");
                        }
                        cookie.setPath(param_value);
                        cookie.setPathAttributeSpecified(true);
                    } else if (param_name.equals("domain")) {
                        if (param_value == null) {
                            throw new HttpException("Missing value for domain attribute");
                        }
                        cookie.setDomain(param_value);
                        cookie.setDomainAttributeSpecified(true);
                    } else if (param_name.equals("max-age")) {
                        int age;
                        if (param_value == null) {
                            throw new HttpException("Missing value for max-age attribute");
                        }
                        try {
                            age = Integer.parseInt(param_value);
                        }
                        catch (NumberFormatException e) {
                            throw new HttpException("Invalid max-age attribute: " + e.getMessage());
                        }
                        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
                    } else if (param_name.equals("secure")) {
                        cookie.setSecure(true);
                    } else if (param_name.equals("comment")) {
                        cookie.setComment(param_value);
                    } else if (param_name.equals("expires")) {
                        if (param_value == null) {
                            throw new HttpException("Missing value for expires attribute");
                        }
                        boolean set = false;
                        if (param_value.length() > 1 && param_value.startsWith("'") && param_value.endsWith("'")) {
                            param_value = param_value.substring(1, param_value.length() - 1);
                        }
                        int k = 0;
                        while (k < expiryFormats.length) {
                            try {
                                Date date = expiryFormats[k].parse(param_value);
                                cookie.setExpiryDate(date);
                                set = true;
                                break;
                            }
                            catch (ParseException parseException) {
                                ++k;
                            }
                        }
                        if (!set) {
                            throw new HttpException("Unable to parse expiration date parameter: " + param_value);
                        }
                    }
                    ++j;
                }
            }
            if (cookie.getDomain() == null) {
                cookie.setDomain(domain);
                cookie.setDomainAttributeSpecified(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Domain attribute not explicitly set. Default applied: \"" + domain + "\""));
                }
            }
            if (cookie.getPath() == null) {
                cookie.setPath(defaultPath);
                cookie.setPathAttributeSpecified(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Path attribute not explicitly set. Default applied: \"" + defaultPath + "\""));
                }
            }
            Cookie.validate(cookie, domain, port, path, secure);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cookie accepted: \"" + cookie.toString() + "\""));
            }
            cookies[index++] = cookie;
            ++i;
        }
        return cookies;
    }

    private static void validate(Cookie cookie, String domain, int port, String path, boolean secure) throws HttpException {
        log.trace((Object)"enter Cookie.validate(String, int, String, boolean)");
        if (cookie.getVersion() < 0) {
            throw new HttpException("Illegal version number " + cookie.getValue());
        }
        if (!cookie.getDomain().equals("localhost") && domain.indexOf(".") >= 0) {
            if (!domain.endsWith(cookie.getDomain())) {
                throw new HttpException("Illegal domain attribute \"" + cookie.getDomain() + "\". Domain of origin: \"" + domain + "\"");
            }
            switch (cookie.getVersion()) {
                case 0: {
                    Cookie.validateDomainAttribVer0(cookie, domain);
                    break;
                }
                default: {
                    Cookie.validateDomainAttribVer1(cookie, domain);
                }
            }
        }
        if (!path.startsWith(cookie.getPath())) {
            throw new HttpException("Illegal path attribute \"" + cookie.getPath() + "\". Path of origin: \"" + path + "\"");
        }
    }

    private static void validateDomainAttribVer0(Cookie cookie, String domain) throws HttpException {
        log.trace((Object)"enter Cookie.validateDomainAttribVer0()");
        int domainParts = new StringTokenizer(cookie.getDomain(), ".").countTokens();
        if (Cookie.isSpecialDomain(cookie.getDomain())) {
            if (domainParts < 2) {
                throw new HttpException("Domain attribute \"" + cookie.getDomain() + "\" violates the Netscape cookie specification for special domains");
            }
        } else if (domainParts < 3) {
            throw new HttpException("Domain attribute \"" + cookie.getDomain() + "\" violates the Netscape cookie specification");
        }
    }

    private static void validateDomainAttribVer1(Cookie cookie, String domain) throws HttpException {
        log.trace((Object)"enter Cookie.validateDomainAttribVer1()");
        int dotIndex = cookie.getDomain().indexOf(46, 1);
        if (dotIndex < 0 || dotIndex == cookie.getDomain().length() - 1) {
            throw new HttpException("Illegal domain attribute \"" + cookie.getDomain() + "\"");
        }
        if (domain.substring(0, domain.length() - cookie.getDomain().length()).indexOf(46) != -1) {
            throw new HttpException("Illegal domain attribute \"" + cookie.getDomain() + "\"");
        }
    }

    private static boolean isSpecialDomain(String domain) {
        String ucDomain = domain.toUpperCase();
        return ucDomain.endsWith(".COM") || ucDomain.endsWith(".EDU") || ucDomain.endsWith(".NET") || ucDomain.endsWith(".GOV") || ucDomain.endsWith(".MIL") || ucDomain.endsWith(".ORG") || ucDomain.endsWith(".INT");
    }

    private static boolean domainMatch(String host, String domain) {
        boolean match = host.equals(domain) || domain.startsWith(".") && host.endsWith(domain);
        return match;
    }

    private static boolean pathMatch(String path, String topmostPath) {
        boolean match = path.startsWith(topmostPath);
        if (match && !topmostPath.endsWith(PATH_DELIM)) {
            match = path.charAt(topmostPath.length()) == PATH_DELIM_CHAR;
        }
        return match;
    }

    private static void addInPathOrder(List list, Cookie addCookie) {
        int i = 0;
        i = 0;
        while (i < list.size()) {
            Cookie c = (Cookie)list.get(i);
            if (addCookie.compare(addCookie, c) > 0) break;
            ++i;
        }
        list.add(i, addCookie);
    }
}

