/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;

public class HttpsURL
extends HttpURL {
    public static final char[] _default_scheme = new char[]{'h', 't', 't', 'p', 's'};
    public static final int _default_port = 443;
    static final long serialVersionUID = 887844277028676648L;

    protected HttpsURL() {
    }

    public HttpsURL(char[] escaped) throws URIException {
        this.parseUriReference(new String(escaped), true);
        this.checkValid();
    }

    public HttpsURL(String original) throws URIException {
        this.parseUriReference(original, false);
        this.checkValid();
    }

    public HttpsURL(String host, String path) throws URIException {
        this(null, host, -1, path, null, null);
        this.checkValid();
    }

    public HttpsURL(String host, int port, String path) throws URIException {
        this(null, host, port, path, null, null);
        this.checkValid();
    }

    public HttpsURL(String host, int port, String path, String query) throws URIException {
        this(null, host, port, path, query, null);
        this.checkValid();
    }

    public HttpsURL(String user, String password, String host) throws URIException {
        this(user == null ? null : String.valueOf(user) + (password == null ? "" : String.valueOf(':') + password), host, -1, null, null, null);
        this.checkValid();
    }

    public HttpsURL(String user, String password, String host, int port) throws URIException {
        this(user == null ? null : String.valueOf(user) + (password == null ? "" : String.valueOf(':') + password), host, port, null, null, null);
        this.checkValid();
    }

    public HttpsURL(String user, String password, String host, int port, String path) throws URIException {
        this(user == null ? null : String.valueOf(user) + (password == null ? "" : String.valueOf(':') + password), host, port, path, null, null);
        this.checkValid();
    }

    public HttpsURL(String user, String password, String host, int port, String path, String query) throws URIException {
        this(user == null ? null : String.valueOf(user) + (password == null ? "" : String.valueOf(':') + password), host, port, path, query, null);
        this.checkValid();
    }

    public HttpsURL(String host, String path, String query, String fragment) throws URIException {
        this(null, host, -1, path, query, fragment);
        this.checkValid();
    }

    public HttpsURL(String userinfo, String host, String path, String query, String fragment) throws URIException {
        this(userinfo, host, -1, path, query, fragment);
        this.checkValid();
    }

    public HttpsURL(String userinfo, String host, int port, String path) throws URIException {
        this(userinfo, host, port, path, null, null);
        this.checkValid();
    }

    public HttpsURL(String userinfo, String host, int port, String path, String query) throws URIException {
        this(userinfo, host, port, path, query, null);
        this.checkValid();
    }

    public HttpsURL(String userinfo, String host, int port, String path, String query, String fragment) throws URIException {
        StringBuffer buff = new StringBuffer();
        if (userinfo != null || host != null || port != -1) {
            this._scheme = _default_scheme;
            buff.append(_default_scheme);
            buff.append("://");
            if (userinfo != null) {
                buff.append(userinfo);
                buff.append('@');
            }
            if (host != null) {
                buff.append(host);
                if (port != -1 || port != 443) {
                    buff.append(':');
                    buff.append(port);
                }
            }
        }
        if (path != null) {
            if (URI.scheme != null && !path.startsWith("/")) {
                throw new URIException(1, "abs_path requested");
            }
            buff.append(path);
        }
        if (query != null) {
            buff.append('?');
            buff.append(query);
        }
        if (fragment != null) {
            buff.append('#');
            buff.append(fragment);
        }
        this.parseUriReference(buff.toString(), false);
        this.checkValid();
    }

    public HttpsURL(HttpsURL base, String relative) throws URIException {
        this(base, new HttpsURL(relative));
    }

    public HttpsURL(HttpsURL base, HttpsURL relative) throws URIException {
        super((HttpURL)base, relative);
        this.checkValid();
    }

    protected void checkValid() throws URIException {
        if (!this.equals(this._scheme, _default_scheme) && this._scheme != null) {
            throw new URIException(1, "wrong class use");
        }
    }
}

