/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipartPostMethod
extends GetMethod {
    private static final Log log;
    private List parameters = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.methods.MultipartPostMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public MultipartPostMethod() {
    }

    public MultipartPostMethod(String path) {
        super(path);
    }

    public MultipartPostMethod(String path, String tempDir) {
        super(path, tempDir);
    }

    public MultipartPostMethod(String path, String tempDir, String tempFile) {
        super(path, tempDir, tempFile);
    }

    public String getName() {
        return "POST";
    }

    public void recycle() {
        log.trace((Object)"enter recycle()");
        super.recycle();
        this.parameters.clear();
    }

    public void addParameter(String parameterName, String parameterValue) {
        log.trace((Object)"enter addParameter(String parameterName, String parameterValue)");
        StringPart param = new StringPart(parameterName, parameterValue);
        this.parameters.add(param);
    }

    public void addParameter(String parameterName, File parameterFile) throws FileNotFoundException {
        log.trace((Object)"enter addParameter(String parameterName, File parameterFile)");
        FilePart param = new FilePart(parameterName, parameterFile);
        this.parameters.add(param);
    }

    public void addParameter(String parameterName, String fileName, File parameterFile) throws FileNotFoundException {
        log.trace((Object)"enter addParameter(String parameterName, String fileName, File parameterFile)");
        FilePart param = new FilePart(parameterName, fileName, parameterFile);
        this.parameters.add(param);
    }

    public void addPart(Part part) {
        log.trace((Object)"enter addPart(Part part)");
        this.parameters.add(part);
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter addRequestHeaders(HttpState state, HttpConnection conn)");
        super.addRequestHeaders(state, conn);
        if (!this.parameters.isEmpty()) {
            this.setRequestHeader("Content-Type", "multipart/form-data; boundary=" + Part.getBoundary());
        }
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.trace((Object)"enter writeRequestBody(HttpState state, HttpConnection conn)");
        OutputStream out = conn.getRequestOutputStream();
        Iterator it = this.parameters.iterator();
        while (it.hasNext()) {
            Part part = (Part)it.next();
            part.send(out);
        }
        Part.sendLastBoundary(out);
        out.flush();
        return true;
    }

    protected int getRequestContentLength() {
        log.trace((Object)"enter getRequestContentLength()");
        long length = 0L;
        try {
            Iterator it = this.parameters.iterator();
            while (it.hasNext()) {
                Part part = (Part)it.next();
                length += part.length();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        if ((length += (long)Part.lengthOfLastBoundary()) <= Integer.MAX_VALUE) {
            return new Long(length).intValue();
        }
        return Integer.MAX_VALUE;
    }
}

