/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class CLabel
extends Canvas {
    private static final int GAP = 5;
    private static final int INDENT = 3;
    private static final String ELLIPSIS = "...";
    private int align = 16384;
    private int hIndent = 3;
    private int vIndent = 3;
    private String text;
    private Image image;
    private String appToolTipText;
    private Image backgroundImage;
    private Color[] gradientColors;
    private int[] gradientPercents;
    private boolean gradientVertical;

    public CLabel(Composite parent, int style) {
        super(parent, CLabel.checkStyle(style));
        if ((style & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((style & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((style & 0x4000) != 0) {
            this.align = 16384;
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                CLabel.this.onPaint(event);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CLabel.this.onDispose(event);
            }
        });
        this.initAccessible();
    }

    private static int checkStyle(int style) {
        String platform;
        if ((style & 0x800) != 0) {
            style |= 4;
        }
        int mask = 100663340;
        style &= mask;
        if (((style |= 0x80000) & 0x1020000) == 0) {
            style |= 0x4000;
        }
        if ("carbon".equals(platform = SWT.getPlatform()) || "gtk".equals(platform)) {
            return style;
        }
        return style | 0x40000;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point e = this.getTotalSize(this.image, this.text);
        e.x = wHint == -1 ? (e.x += 2 * this.hIndent) : wHint;
        e.y = hHint == -1 ? (e.y += 2 * this.vIndent) : hHint;
        return e;
    }

    private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
    }

    public int getAlignment() {
        return this.align;
    }

    public Image getImage() {
        return this.image;
    }

    private Point getTotalSize(Image image, String text) {
        Point size = new Point(0, 0);
        if (image != null) {
            Rectangle r = image.getBounds();
            size.x += r.width;
            size.y += r.height;
        }
        GC gc = new GC(this);
        if (text != null && text.length() > 0) {
            Point e = gc.textExtent(text);
            size.x += e.x;
            size.y = Math.max(size.y, e.y);
            if (image != null) {
                size.x += 5;
            }
        } else {
            size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
        }
        gc.dispose();
        return size;
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    private void paintBorder(GC gc, Rectangle r) {
        Display disp = this.getDisplay();
        Color c1 = null;
        Color c2 = null;
        int style = this.getStyle();
        if ((style & 4) != 0) {
            c1 = disp.getSystemColor(18);
            c2 = disp.getSystemColor(20);
        }
        if ((style & 8) != 0) {
            c1 = disp.getSystemColor(19);
            c2 = disp.getSystemColor(18);
        }
        if (c1 != null && c2 != null) {
            gc.setLineWidth(1);
            this.drawBevelRect(gc, r.x, r.y, r.width - 1, r.height - 1, c1, c2);
        }
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = CLabel.this.getText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = CLabel.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = CLabel.this.toControl(new Point(e.x, e.y));
                e.childID = CLabel.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = CLabel.this.getBounds();
                Point pt = CLabel.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = CLabel.this.getText();
            }
        });
    }

    void onDispose(DisposeEvent event) {
        this.gradientColors = null;
        this.gradientPercents = null;
        this.backgroundImage = null;
        this.text = null;
        this.image = null;
        this.appToolTipText = null;
    }

    void onPaint(PaintEvent event) {
        int x;
        GC gc;
        Image img;
        String t;
        Rectangle rect;
        block30: {
            rect = this.getClientArea();
            if (rect.width == 0 || rect.height == 0) {
                return;
            }
            boolean shortenText = false;
            t = this.text;
            img = this.image;
            int availableWidth = rect.width - 2 * this.hIndent;
            Point extent = this.getTotalSize(img, t);
            if (extent.x > availableWidth) {
                img = null;
                extent = this.getTotalSize(img, t);
                if (extent.x > availableWidth) {
                    shortenText = true;
                }
            }
            gc = event.gc;
            if (shortenText) {
                t = this.shortenText(gc, this.text, availableWidth);
                extent = this.getTotalSize(img, t);
                if (this.appToolTipText == null) {
                    super.setToolTipText(this.text);
                }
            } else {
                super.setToolTipText(this.appToolTipText);
            }
            x = rect.x + this.hIndent;
            if (this.align == 0x1000000) {
                x = (rect.width - extent.x) / 2;
            }
            if (this.align == 131072) {
                x = rect.width - extent.x - this.hIndent;
            }
            try {
                if (this.backgroundImage != null) {
                    Rectangle imageRect = this.backgroundImage.getBounds();
                    gc.setBackground(this.getBackground());
                    gc.fillRectangle(rect);
                    int xPos = 0;
                    while (xPos < rect.width) {
                        int yPos = 0;
                        while (yPos < rect.height) {
                            gc.drawImage(this.backgroundImage, xPos, yPos);
                            yPos += imageRect.height;
                        }
                        xPos += imageRect.width;
                    }
                } else if (this.gradientColors != null) {
                    Color oldBackground = gc.getBackground();
                    if (this.gradientColors.length == 1) {
                        if (this.gradientColors[0] != null) {
                            gc.setBackground(this.gradientColors[0]);
                        }
                        gc.fillRectangle(0, 0, rect.width, rect.height);
                    } else {
                        Color oldForeground = gc.getForeground();
                        Color lastColor = this.gradientColors[0];
                        if (lastColor == null) {
                            lastColor = oldBackground;
                        }
                        int pos = 0;
                        int i = 0;
                        while (i < this.gradientPercents.length) {
                            gc.setForeground(lastColor);
                            lastColor = this.gradientColors[i + 1];
                            if (lastColor == null) {
                                lastColor = oldBackground;
                            }
                            gc.setBackground(lastColor);
                            if (this.gradientVertical) {
                                int gradientHeight = this.gradientPercents[i] * rect.height / 100 - pos;
                                gc.fillGradientRectangle(0, pos, rect.width, gradientHeight, true);
                                pos += gradientHeight;
                            } else {
                                int gradientWidth = this.gradientPercents[i] * rect.width / 100 - pos;
                                gc.fillGradientRectangle(pos, 0, gradientWidth, rect.height, false);
                                pos += gradientWidth;
                            }
                            ++i;
                        }
                        if (this.gradientVertical && pos < rect.height) {
                            gc.setBackground(this.getBackground());
                            gc.fillRectangle(0, pos, rect.width, rect.height - pos);
                        }
                        if (!this.gradientVertical && pos < rect.width) {
                            gc.setBackground(this.getBackground());
                            gc.fillRectangle(pos, 0, rect.width - pos, rect.height);
                        }
                        gc.setForeground(oldForeground);
                    }
                    gc.setBackground(oldBackground);
                } else if ((this.getStyle() & 0x40000) != 0) {
                    gc.setBackground(this.getBackground());
                    gc.fillRectangle(rect);
                }
            }
            catch (SWTException e) {
                if ((this.getStyle() & 0x40000) == 0) break block30;
                gc.setBackground(this.getBackground());
                gc.fillRectangle(rect);
            }
        }
        int style = this.getStyle();
        if ((style & 4) != 0 || (style & 8) != 0) {
            this.paintBorder(gc, rect);
        }
        if (img != null) {
            Rectangle imageRect = img.getBounds();
            gc.drawImage(img, 0, 0, imageRect.width, imageRect.height, x, (rect.height - imageRect.height) / 2, imageRect.width, imageRect.height);
            x += imageRect.width + 5;
        }
        if (t != null) {
            int textHeight = gc.getFontMetrics().getHeight();
            gc.setForeground(this.getForeground());
            gc.drawText(t, x, rect.y + (rect.height - textHeight) / 2, true);
        }
    }

    public void setAlignment(int align) {
        this.checkWidget();
        if (align != 16384 && align != 131072 && align != 0x1000000) {
            SWT.error(5);
        }
        if (this.align != align) {
            this.align = align;
            this.redraw();
        }
    }

    public void setBackground(Color color) {
        Color background;
        super.setBackground(color);
        if (color != null && this.backgroundImage == null && this.gradientColors == null && this.gradientPercents == null && color.equals(background = this.getBackground())) {
            return;
        }
        this.backgroundImage = null;
        this.gradientColors = null;
        this.gradientPercents = null;
        this.redraw();
    }

    public void setBackground(Color[] colors, int[] percents) {
        this.setBackground(colors, percents, false);
    }

    public void setBackground(Color[] colors, int[] percents, boolean vertical) {
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error(5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colors.length - 1]};
                percents = new int[]{};
            }
            int i = 0;
            while (i < percents.length) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error(5);
                }
                if (i > 0 && percents[i] < percents[i - 1]) {
                    SWT.error(5);
                }
                ++i;
            }
        }
        Color background = this.getBackground();
        if (this.backgroundImage == null) {
            if (this.gradientColors != null && colors != null && this.gradientColors.length == colors.length) {
                boolean same = false;
                int i = 0;
                while (i < this.gradientColors.length) {
                    boolean bl = same = this.gradientColors[i] == colors[i] || this.gradientColors[i] == null && colors[i] == background || this.gradientColors[i] == background && colors[i] == null;
                    if (!same) break;
                    ++i;
                }
                if (same) {
                    i = 0;
                    while (i < this.gradientPercents.length) {
                        boolean bl = same = this.gradientPercents[i] == percents[i];
                        if (!same) break;
                        ++i;
                    }
                }
                if (same && this.gradientVertical == vertical) {
                    return;
                }
            }
        } else {
            this.backgroundImage = null;
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
        } else {
            this.gradientColors = new Color[colors.length];
            int i = 0;
            while (i < colors.length) {
                this.gradientColors[i] = colors[i] != null ? colors[i] : background;
                ++i;
            }
            this.gradientPercents = new int[percents.length];
            i = 0;
            while (i < percents.length) {
                this.gradientPercents[i] = percents[i];
                ++i;
            }
            this.gradientVertical = vertical;
        }
        this.redraw();
    }

    public void setBackground(Image image) {
        this.checkWidget();
        if (image == this.backgroundImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.backgroundImage = image;
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.image) {
            this.image = image;
            this.redraw();
        }
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.text)) {
            this.text = text;
            this.redraw();
        }
    }

    protected String shortenText(GC gc, String t, int width) {
        int pivot;
        if (t == null) {
            return null;
        }
        int w = gc.textExtent((String)ELLIPSIS).x;
        int l = t.length();
        int s = pivot = l / 2;
        int e = pivot + 1;
        while (s >= 0 && e < l) {
            String s1 = t.substring(0, s);
            String s2 = t.substring(e, l);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + w + l2 < width) {
                t = String.valueOf(s1) + ELLIPSIS + s2;
                break;
            }
            --s;
            ++e;
        }
        return t;
    }
}

