<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * 必要なファイルを全て読み込み
 */
require_once 'Moony/Action.php';
require_once 'Moony/Config.php';
require_once 'Moony/Controller.php';
require_once 'Moony/Downloader.php';
require_once 'Moony/Error.php';
require_once 'Moony/Filter.php';
require_once 'Moony/Logger.php';
require_once 'Moony/Messages.php';
require_once 'Moony/Request.php';
require_once 'Moony/Response.php';
require_once 'Moony/Router.php';
require_once 'Moony/Session.php';
require_once 'Moony/SmartyPlugin.php';
require_once 'Moony/Token.php';
require_once 'Moony/Uploader.php';
require_once 'Moony/Utils.php';
require_once 'Moony/Validator.php';
require_once 'Moony/View.php';

/**
 * ルータの起動を行うためのクラスです。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 */
class Moony
{
    /**
     * コンストラクタです。
     * 必要な初期設定を行います。
     * 
     * @access public
     */
    function Moony()
    {
        // mbstring設定
        mb_language('ja');
        mb_internal_encoding(MOONY_INTERNAL_ENCODING);
        mb_http_output(MOONY_OUTPUT_ENCODING);

        // エラーハンドラ設定
        if (MOONY_USE_ERROR_HANDLER) {
            set_error_handler(array('Moony_Error', 'handle'));
        }
    }

    /**
     * コントローラを起動します。
     * 動作設定条件を設定した連想配列を引数として要求します。
     * 
     * @access public
     * @param array $options Moonyの動作設定を記述した連想配列
     */
    function activate($options)
    {
        // 必須オプションチェック
        if (is_null($options) || !is_array($options) ||
            !isset($options['action_dir']) ||
            !isset($options['template_dir']) ||
            !isset($options['work_dir']) ||
            !isset($options['log_dir'])) {
            trigger_error('Moony configuration failed.', E_USER_ERROR);
        }

        // 定義
        define('MOONY_ACTION_DIR', $options['action_dir']);
        define('MOONY_SMARTY_TEMPLATE_DIR', $options['template_dir']);
        define('MOONY_SMARTY_WORK_DIR', $options['work_dir']);
        define('MOONY_LOG_DIR', $options['log_dir']);

        if (isset($options['use_db']) && $options['use_db'] === true) {
            // Moony_DBを使用する場合
            include_once('Moony/DB.php');
        }

        // NULLバイト文字列をパラメータから除去
        $_POST = Moony_Utils::removeNullString($_POST);
        $_GET = Moony_Utils::removeNullString($_GET);
        $_FILES = Moony_Utils::removeNullString($_FILES);
        $_COOKIE = Moony_Utils::removeNullString($_COOKIE);
        $_SERVER = Moony_Utils::removeNullString($_SERVER);

        // コントローラ生成
        $controller =& new Moony_Controller();

        // ルータ生成、コントローラを渡す
        $rooter =& new Moony_Router();
        $rooter->route($controller);
    }
}
?>
