<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * アクションクラスの基底クラスです。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 * @abstract
 */
class Moony_Action
{
    /**
     * コンストラクタです。
     * 
     * @access public
     */
    function Moony_Action()
    {}

    /**
     * 入力パラメータの変換処理を行います。
     * 必要に応じてオーバーライドしてください。
     *
     * @access public
     * @param object $request Moony_Requestのインスタンス
     */
    function filter($request)
    {}

    /**
     * 入力パラメータの妥当性チェックを行います。
     * 必要に応じてオーバーライドしてください。
     *
     * @access public
     * @param object $request Moony_Requestのインスタンス
     * @param object $errors Moony_Messagesのインスタンス
     * @return boolean エラーが存在する場合false、存在しない場合true
     */
    function validate($request, $errors)
    {
        return true;
    }

    /**
     * 実際の処理を行います。
     * 必ずオーバーライドしてください。
     * 
     * @access public
     * @abstract
     * @param object $request Moony_Requestのインスタンス
     * @param object $response Moony_Responseのインスタンス
     */
    function execute($request, $response)
    {
        Moony_Error::raise('Moony_Action::execute not overridden', __FILE__, __LINE__);
    }
}
?>