<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

// Moonyのバージョン
define('MOONY_VERSION', '0.9.0');

// ログ出力レベルの定義
define('MOONY_LOG_LEVEL_FATAL', 5);
define('MOONY_LOG_LEVEL_ERROR', 4);
define('MOONY_LOG_LEVEL_WARN',  3);
define('MOONY_LOG_LEVEL_INFO',  2);
define('MOONY_LOG_LEVEL_DEBUG', 1);
define('MOONY_LOG_LEVEL_NONE',  0);

// Moonyの内部エンコーディング
define('MOONY_INTERNAL_ENCODING', 'UTF-8');

// Moonyの出力エンコーディング
define('MOONY_OUTPUT_ENCODING', 'SJIS');

// テンプレートファイルのエンコーディング
define('MOONY_TEMPLATE_ENCODING', 'UTF-8');

// リクエストパラメータのエンコーディング変換を行うかどうか
if (ini_get('mbstring.encoding_translation')) {
    define('MOONY_REQUEST_PARAMETER_CONVERT_ENCODING', false);
} else {
    define('MOONY_REQUEST_PARAMETER_CONVERT_ENCODING', true);
}

// テンプレート表示時にHTMLのエンコーディングに関するヘッダ送出を行うかどうか
define('MOONY_SENDING_HEADER_ABOUT_ENCODING', true);

// XHTMLとしてのヘッダ（application/xhtml+xml）を使用するかどうか
define('MOONY_USE_XHTML_HEADER', false);

// URLの何階層目までをアクション設定として解釈するか
define('MOONY_EVAL_AS_ACTION_SETTING', 2);

// セッション名称
define('MOONY_SESSION_NAME', 'MOONY_SESSID');

// セッションを自動的に開始するかどうか
define('MOONY_SESSION_AUTO_START', true);

// セッションIDの再生成を行う間隔（秒）
// （0に設定すると常に再生成を行います）
define('MOONY_SESSION_REGENERATE_TIME', 3600);

// トランザクショントークンの項目名
define('MOONY_TRANSACTION_TOKEN_NAME', 'moony_token');

// エラーメッセージの設定キー
define('MOONY_VALIDATION_ERROR_KEY', 'moony_validation_error');

// エラーハンドラを使用するかどうか
define('MOONY_USE_ERROR_HANDLER', true);

// Moonyのログファイル名称
define('MOONY_LOG_FILE', 'moony.log');

// ログファイルに出力する日付の形式（date関数を利用）
define('MOONY_LOG_DATE_FORMAT', 'Y/m/d H:i:s');

// ログ出力を行うログレベルの閾値
define('MOONY_LOG_CATEGORY', MOONY_LOG_LEVEL_INFO);

// ログのローテートを行うかどうか
define('MOONY_LOG_ROTATE', true);

// アクションクラスの拡張子
define('MOONY_ACTION_EXT', 'php');

// Smartyのテンプレートファイルの拡張子
define('MOONY_SMARTY_TEMPLATE_EXT', 'tpl');

if (!defined('PATH_SEPARATOR')) {
    if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
        define('PATH_SEPARATOR', ';');
    } else {
        define('PATH_SEPARATOR', ':');
    }
}

if (!defined('DIRECTORY_SEPARATOR')) {
    if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
        define('DIRECTORY_SEPARATOR', '\\');
    } else {
        define('DIRECTORY_SEPARATOR', '/');
    }
}

if (!defined('E_STRICT')) {
    define('E_STRICT', 2048);
}
?>
