<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * ファイルのダウンロードを行うためのクラスです。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 */
class Moony_Downloader
{
    /**
     * 指定されたファイルをHTTPレスポンスに添付します。
     * $nameが指定されない場合、元のファイルの名称がそのまま使用されます。
     *
     * @access public
     * @static
     * @param string $path 添付するファイルのパス
     * @param string $name 添付するファイルにつける名前
     */
    function download($path, $name = null)
    {
        $error = false;
        if (!file_exists($path)) {
            Moony_Logger::warn('File not found: ' . $path, __FILE__, __LINE__);
            $error = true;
        }
        if (!($fp = fopen($path, 'r'))) {
            Moony_Logger::warn('Unable to open file: ' . $path, __FILE__, __LINE__);
            $error = true;
        }
        fclose($fp);
        if (($size = filesize($path)) == 0) {
            Moony_Logger::warn('File size=0: ' . $path, __FILE__, __LINE__);
            $error = true;
        }
        if ($error) {
            Moony_Error::notFound();
            exit(1);
        }

        if (strlen($name) == 0) {
            $name = basename($path);
        }

        header("Content-Disposition: attachment; filename=\"${name}\"");
        header("Content-Length: ${size}");
        header('Content-Type: application/octet-stream');

        if (!readfile($path)) {
            Moony_Logger::warn('Unable to read file: ' . $path, __FILE__, __LINE__);
            Moony_Error::notFound();
            exit(1);
        }
    }
}
?>
