<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * エラーを処理するクラスです。
 * スタティックなメソッドで構成されます。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 */
class Moony_Error
{
    /**
     * 発生したエラーのハンドリングを行います。
     * エラーログを出力、HTTPのステータス500を返し、処理を終了します。
     * 
     * @access public
     * @static
     * @param integer $code エラーコード
     * @param string $message メッセージ
     * @param string $file 呼び出し元のファイル名
     * @param integer $line 呼び出し元の行番号
     */
    function handle($code, $message, $file, $line)
    {
        switch ($code) {

            case E_STRICT:
                // 何もしない
                break;

            case E_NOTICE:
            case E_USER_NOTICE:
            case E_USER_WARNING:
            case E_CORE_WARNING:
            case E_COMPILE_WARNING:
                Moony_Logger::warn($message, $file, $line);
                break;

            case E_ERROR:
            case E_PARSE:
            case E_USER_ERROR:
            case E_CORE_ERROR:
            case E_COMPILE_ERROR:
                Moony_Logger::error($message, $file, $line);
                Moony_Error::internalServerError();
                exit(1);
        }
    }

    /**
     * エラーを発生させます。
     * エラーコードにはE_USER_ERRORを使用します。
     *
     * @access public
     * @static
     * @param string $message メッセージ
     * @param string $file 呼び出し元のファイル名
     * @param integer $line 呼び出し元の行番号
     */
    function raise($message, $file, $line)
    {
        if (MOONY_USE_ERROR_HANDLER) {
            Moony_Error::handle(E_USER_ERROR, $message, $file, $line);
        } else {
            trigger_error($message, E_USER_ERROR);
        }
    }

    /**
     * テンプレートファイルが見つからない場合のエラー処理です。
     * httpのステータスで404を返します。
     *
     * @access public
     * @static
     */
    function notFound()
    {
        Moony_Utils::sendStatus(404);
        echo 'Not Found';
    }

    /**
     * 動作エラーが発生した場合のエラー処理です。
     * httpのステータスで500を返します。
     *
     * @access public
     * @static
     */
    function internalServerError()
    {
        Moony_Utils::sendStatus(500);
        echo 'Internal Server Error';
    }
}
?>
