<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * 入力パラメータのフィルタ処理の基本機能を提供するクラスです。
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 */
class Moony_Filter
{
    /**
     * 内部でmb_convert_kanaを使用してパラメータ値変換を行います。
     * $optionにはmb_convert_kanaで使用できるオプションを指定してください。
     * 値が配列の場合、全ての要素が変換対象となります。
     *
     * @access public
     * @static
     * @param object $request Moony_Requestのインスタンス
     * @param string $name パラメータ名称
     * @param string $option 変換オプション（mb_convert_kanaで使用できるオプション）
     */
    function convertKana(&$request, $name, $option)
    {
        if (($value = $request->get($name, false)) === false) {
            return;
        }
        if (is_array($value)) {
            $result = array();
            foreach ($value as $each) {
                $result[] = mb_convert_kana($each, $option);
            }
            $request->replace($name, $result);
        } else {
            $request->replace($name, mb_convert_kana($value, $option));
        }
    }

    /**
     * かなを全て全角カタカナに変換します。
     * 値が配列の場合、全ての要素が変換対象となります。
     *
     * @access public
     * @static
     * @param object $request Moony_Requestのインスタンス
     * @param string $name パラメータ名称
     */
    function toFullWidthKatakana(&$request, $name)
    {
        Moony_Filter::convertKana(&$request, $name, 'KVC');
    }

    /**
     * 全角の英数字を半角に変換します。
     * 値が配列の場合、全ての要素が変換対象となります。
     *
     * @access public
     * @static
     * @param object $request Moony_Requestのインスタンス
     * @param string $name パラメータ名称
     */
    function toHalfWidthAlnum(&$request, $name)
    {
        Moony_Filter::convertKana($request, $name, 'a');
    }
}
?>
