<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */
require_once 'Config.php';
require_once 'Utils.php';

// check environment
$sapi_name = php_sapi_name();
if ($sapi_name != 'cli') {
    if (isset($_SERVER['REQUEST_METHOD']) && strlen($_SERVER['REQUEST_METHOD']) > 0) {
        Moony_Utils::sendStatus(403);
    }
    die("Error: Not using CLI PHP\n");
}

// check arguments
if ($_SERVER['argc'] != 4) {
    $error_message = "Parameter Error...\n";
    $error_message .= "usage: /path/to/php Generator.php [action_name] [action_dir] [template_dir]\n";
    die($error_message);
}

// get arguments
$action_name = $_SERVER['argv'][1];
$action_dir = $_SERVER['argv'][2];
$template_dir = $_SERVER['argv'][3];

// create file paths
$action_file = Moony_Utils::buildPath($action_dir, $action_name . 'Action.', MOONY_ACTION_EXT);
$template_file = Moony_Utils::buildPath($template_dir, $action_name, MOONY_SMARTY_TEMPLATE_EXT);

// files existance check
if (file_exists($action_file)) {
    die("Error: Action class file already exists\n");
}
if (file_exists($template_file)) {
    die("Error: Template file already exists\n");
}

// skelton for the action class
$action_tpl = <<<_ACTION_TPL_END
<?php
class %s extends Moony_Action
{
    function filter(\$request)
    {
    }
    function validate(\$request, \$errors)
    {
        return true;
    }
    function execute(\$request, \$response)
    {
    }
}
?>

_ACTION_TPL_END;

// skelton for the template file
$template_tpl = <<<_TEMPLATE_TPL_END
<html>

<head>
</head>

<body>
<p>Hello, Moony!</p>
</body>

</html>

_TEMPLATE_TPL_END;

// generate contents
$action_content = sprintf($action_tpl, $action_name . 'Action');
$template_content = sprintf($template_tpl, $action_name);

// generate the action class file
$fp = fopen($action_file, 'w') or die("Error: Unable to open action class file\n");
fputs($fp, $action_content);
fclose($fp);

// generate the template file
$fp = fopen($template_file, 'w') or die("Error: Unable to open template file\n");;
fputs($fp, $template_content);
fclose($fp);

echo "Skeleton for '$action_name' successfully generated!\n";
?>
