<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * メッセージを格納するためのクラスです。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 */
class Moony_Messages
{
    /** @var array メッセージを格納する連想配列 */
    var $_messages;

    /**
     * コンストラクタです。
     *
     * @access public
     */
    function Moony_Messages()
    {
        $this->_messages = array();
    }

    /**
     * メッセージを設定します。
     *
     * @access public
     * @param string $name 項目名称
     * @param string $message メッセージ
     */
    function set($name, $message)
    {
        $this->_messages[$name] = $message;
    }

    /**
     * 設定されているメッセージを取得します。
     *
     * @access public
     * @param string $name 項目名称
     * @param string $alt 該当項目が設定されていない場合の代替値
     * @return string メッセージ
     */
    function get($name, $alt = null)
    {
        return Moony_Utils::getArrayValue($name, $this->_messages, $alt);
    }

    /**
     * 設定されているメッセージ全てを連想配列として取得します。
     *
     * @access public
     * @return array 設定されている全てのメッセージ
     */
    function getAll()
    {
        return $this->_messages;
    }

    /**
     * 設定されているメッセージを除去します。
     *
     * @access public
     * @param string $name 項目名称
     * @return boolean 除去に成功すればtrue、失敗すればfalse
     */
    function remove($name)
    {
        if (!$this->exists($name)) {
            return false;
        }
        unset($this->_messages[$name]);
        return true;
    }

    /**
     * 指定された項目名称のメッセージが設定されているかどうか調べます。
     *
     * @access public
     * @param string $name 項目名称
     * @return boolean 設定されていればtrue、されていなければfalse
     */
    function exists($name)
    {
        return isset($this->_messages[$name]);
    }
}
?>
