<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * PATH_INFOを解析、アクション名を決定して
 * コントローラに処理を実行させるためのクラスです。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 */
class Moony_Router
{
    /**
     * コンストラクタです。
     *
     * @access public
     */
    function Router()
    {}

    /**
     * PATH_INFOを解析、アクション名を決定して
     * コントローラに処理を実行させます。
     *
     * @access public
     * @param object Moony_Controllerのインスタンス
     */
    function route(&$controller)
    {
        // PATH_INFO取得
        $path_info = '';
        if (isset($_SERVER['PATH_INFO'])) {
            $path_info = $_SERVER['PATH_INFO'];
        }

        // ディレクトリが指定されていた場合、'index'を末尾に付与
        if (substr($path_info, -1) == '/') {
            $path_info .= 'index';
        }

        // スラッシュ区切りで分割
        $path_info_array = explode('/', trim($path_info, '/'));

        // 最後の要素から拡張子を除去
        $count = count($path_info);
        if ($count > 0) {
            $path_info_array[$count - 1] = Moony_Utils::removeFileExtension($path_info_array[$count - 1]);
        }

        // アクション名称組み立て
        // /app/reg_user の場合、 AppRegUser
        $action_name = '';
        for ($i = 0; $i < MOONY_EVAL_AS_ACTION_SETTING; $i++) {
            if (isset($path_info_array[$i])) {
                $action_name .= Moony_Utils::camelCase($path_info_array[$i]);
            } else {
                break;
            }
        }

        // 設定されていない場合、デフォルトアクション
        if (strlen($action_name) == 0) {
            $action_name = 'Index';
        }

        // コントローラ処理実行
        $controller->process($action_name, $path_info_array);
    }
}
?>
