<?php
/**
 * Moony - a simple web application framework
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 */

/**
 * トランザクショントークンを取り扱うためのクラスです。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license http://www.opensource.org/licenses/bsd-license.php BSD License
 * @access public
 */
class Moony_Token
{
    /**
     * トランザクショントークンを生成、
     * セッションとResponseに保存します。
     * セッションが開始していない場合、無条件にfalseを返します。
     *
     * @access public
     * @static
     * @param object $request Moony_Requestのインスタンス
     * @param object $response Moony_Responseのインスタンス
     * @return boolean トランザクショントークン生成に成功したかどうか
     */
    function save(&$request, &$response)
    {
        $session = $request->getSession();
        if ($session->hasStarted()) {
            $token = md5(uniqid(rand(), true));
            $session->set(MOONY_TRANSACTION_TOKEN_NAME, $token);
            $response->set(MOONY_TRANSACTION_TOKEN_NAME, $token);
            return true;
        }
        return false;
    }

    /**
     * トランザクショントークンの妥当性チェックを行います。
     * セッションが開始されていない場合、無条件にfalseを返します。
     * トークンが送信されてこない場合、無条件にfalseを返します。
     * 比較後、セッション内のトークン値は直ちに削除されます。
     *
     * @access public
     * @static
     * @param object $request Moony_Requestのインスタンス
     * @return boolean トークンがセッションに格納された値と一致する場合true
     */
    function check(&$request)
    {
        $session = $request->getSession();
        if (!$session->hasStarted()) {
            // セッションが開始されていない場合
            return false;
        }

        // パラメータとして送信されてこない場合
        if (!$request->exists(MOONY_TRANSACTION_TOKEN_NAME)) {
            return false;
        }

        // セッションから保存しておいたトークン値取得、直ちにセッションから削除
        $saved = $session->get(MOONY_TRANSACTION_TOKEN_NAME);
        $session->remove(MOONY_TRANSACTION_TOKEN_NAME);

        // リクエストパラメータと比較
        if ($request->get(MOONY_TRANSACTION_TOKEN_NAME) == $saved) {
            return true;
        }

        return false;
    }
}
?>
