<?php
/**
 * Moony - the tiny web application framework
 *
 * @package   Moony
 * @author    YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @link      http://moony.sourceforge.jp/
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license   http://opensource.org/licenses/bsd-license.php The BSD License
 */

/**
 * テンプレートを扱うための基底クラスです。
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @access public
 * @abstract
 */
class Moony_Template
{
    /**
     * テンプレートに値を割り当てます。
     * $varが配列の場合、展開して全ての値を割り当てます。
     * サブクラスで必ずオーバーライドしてください。
     *
     * @access public
     * @abstract
     * @param string|array $var 値の名称、または割り当てる値の連想配列
     * @param mixed $value 割り当てる値
     */
    function assign($var, $value = null)
    {
        // to be overridden
    }

    /**
     * テンプレートの処理結果を取得します。
     * テンプレートファイルが存在しない場合、falseを返します。
     * サブクラスで必ずオーバーライドしてください。
     *
     * @access public
     * @abstract
     * @param string $template テンプレートファイル名
     * @return string|false テンプレートの処理結果
     */
    function fetch($template)
    {
        // to be overridden
    }

    /**
     * 設定を行います。
     * サブクラスで必ずオーバーライドしてください。
     *
     * @access public
     * @abstract
     * @param array $configs 設定内容の連想配列
     */
    function configure($configs)
    {
        // to be overridden
    }
}
?>
