<?php
class Moony_FlashTest extends UnitTestCase
{
    var $flash;

    function setUp()
    {
        $_SESSION = array();
        $_SESSION[MOONY_FLASH_KEY] = array('foo' => 'a', 'bar' => 'bb');
        $this->flash =& new Moony_Flash();
    }

    function testGet()
    {
        $this->assertEqual('a', $this->flash->get('foo'));
        $this->assertEqual('AAA', $this->flash->get('fooo', 'AAA'));
        $this->assertNull($this->flash->get('fooo'));
    }

    function testGetAll()
    {
        $expected = array('foo' => 'a', 'bar' => 'bb');
        $this->assertEqual($expected, $this->flash->getAll());
    }

    function testSet()
    {
        $expected = array('foo' => 'a', 'bar' => 'bb', 'baz' => 'ccc');
        $this->flash->set('baz', 'ccc');
        $this->assertEqual($expected, $this->flash->getAll());
        $this->assertEqual($_SESSION[MOONY_FLASH_KEY], array('baz' => 'ccc'));
    }

    function testExists()
    {
        $this->flash->set('baz', 'ccc');
        $this->assertTrue($this->flash->exists('foo'));
        $this->assertTrue($this->flash->exists('baz'));
        $this->assertFalse($this->flash->exists('fooo'));
        $this->assertFalse($this->flash->exists('bazzzz'));
    }

    function testRemove()
    {
        $this->flash->set('baz', 'ccc');
        $removed = $this->flash->remove('baz');
        $this->assertEqual('ccc', $removed);
        $this->assertFalse($this->flash->exists('baz'));
        $this->assertFalse(isset($_SESSION[MOONY_FLASH_KEY]['baz']));
    }

    function testClean()
    {
        $this->flash->clean();
        $this->assertEqual(array(), $this->flash->getAll());
        $this->assertEqual(array(), $_SESSION[MOONY_FLASH_KEY]);
    }

    function testKeep1()
    {
        $expected = array('foo' => 'a', 'baz' => 'ccc');
        $this->flash->set('baz', 'ccc');
        $this->flash->keep('foo');
        $this->assertEqual($expected, $_SESSION[MOONY_FLASH_KEY]);
    }

    function testKeep2()
    {
        $expected = array('foo' => 'a', 'bar' => 'bb', 'baz' => 'ccc');
        $this->flash->set('baz', 'ccc');
        $this->flash->keep();
        $this->assertEqual($expected, $_SESSION[MOONY_FLASH_KEY]);
    }
}
?>
