/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.handlers;

import jp.sourceforge.moreemacs.handlers.TextEditorExecution;
import jp.sourceforge.moreemacs.utils.CodePointIterator;
import jp.sourceforge.moreemacs.utils.DocumentCharSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public final class ForwardWordExecution
extends TextEditorExecution {
    @Override
    public void execute() throws BadLocationException {
        int current = this.cursor.offset();
        this.cursor.move(ForwardWordExecution.getNextWordPosition(this.doc, current));
    }

    public static int getNextWordPosition(IDocument doc, int offset) throws BadLocationException {
        DocumentCharSequence seq = new DocumentCharSequence(doc, offset, doc.getLength() - offset);
        CodePointIterator itr = new CodePointIterator(seq);
        while (itr.hasNext()) {
            int codePoint = itr.next();
            if (!Character.isLetterOrDigit(codePoint)) continue;
            itr.previous();
            break;
        }
        while (itr.hasNext()) {
            if (Character.isLetterOrDigit(itr.next())) continue;
            itr.previous();
            break;
        }
        return offset + itr.index();
    }
}

