/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.handlers;

import java.util.List;
import jp.sourceforge.moreemacs.handlers.RectangleExecution;
import jp.sourceforge.moreemacs.utils.CodePointIterator;
import jp.sourceforge.moreemacs.utils.ColumnUtils;
import jp.sourceforge.moreemacs.utils.DocumentCharSequence;
import jp.sourceforge.moreemacs.utils.DocumentTransaction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public final class YankRectangleExecution
extends RectangleExecution {
    @Override
    public void execute() throws BadLocationException {
        if (!this.textEditor.isEditable()) {
            return;
        }
        List<String> rectangle = YankRectangleExecution.getRectangle();
        if (rectangle == null) {
            return;
        }
        int current = this.cursor.offset();
        int row = this.doc.getLineOfOffset(current);
        int column = ColumnUtils.getColumn(this.doc, current, this.getTabStop());
        this.ensureLines(this.doc, row + rectangle.size());
        DocumentTransaction transaction = new DocumentTransaction(this.doc);
        transaction.begin(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
        try {
            this.yankRectangle(this.doc, row, column, rectangle);
        }
        finally {
            transaction.end();
        }
    }

    private void ensureLines(IDocument doc, int lines) throws BadLocationException {
        int n = lines - doc.getNumberOfLines();
        if (n <= 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        String delim = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        int i = 0;
        while (i < n) {
            builder.append(delim);
            ++i;
        }
        doc.replace(doc.getLength(), 0, builder.toString());
    }

    private void yankRectangle(IDocument doc, int row, int column, List<String> rectangle) throws BadLocationException {
        int i = 0;
        while (i < rectangle.size()) {
            this.yankString(doc, row + i, column, rectangle.get(i));
            ++i;
        }
    }

    private void yankString(IDocument doc, int row, int column, String str) throws BadLocationException {
        IRegion line = doc.getLineInformation(row);
        int col = 0;
        DocumentCharSequence seq = new DocumentCharSequence(doc, line.getOffset(), line.getLength());
        CodePointIterator itr = new CodePointIterator(seq);
        while (itr.hasNext()) {
            int offset = line.getOffset() + itr.index();
            int codePoint = itr.next();
            if (col >= column) {
                doc.replace(offset, 0, str);
                this.cursor.move(offset + str.length());
                return;
            }
            col = ColumnUtils.getNextColumn(col, codePoint, this.getTabStop());
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < column - col) {
            builder.append(" ");
            ++i;
        }
        builder.append(str);
        doc.replace(line.getOffset() + line.getLength(), 0, builder.toString());
        this.cursor.move(line.getOffset() + line.getLength() + builder.length());
    }
}

