/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.utils;

import com.ibm.icu.lang.UCharacter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class CharacterUtils {
    private static List<String> EAST_ASIAN_LANGS = Arrays.asList("ja", "vi", "kr", "zh");

    private CharacterUtils() {
    }

    public static int getWidth(int codePoint) {
        return CharacterUtils.getWidth(codePoint, Locale.getDefault());
    }

    public static int getWidth(int codePoint, Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale is null");
        }
        int value = UCharacter.getIntPropertyValue((int)codePoint, (int)4100);
        switch (value) {
            case 0: 
            case 2: 
            case 4: {
                return 1;
            }
            case 3: 
            case 5: {
                return 2;
            }
            case 1: {
                if (EAST_ASIAN_LANGS.contains(locale.getLanguage())) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }
}

