/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.utils;

import java.util.Iterator;

public final class CodePointIterator
implements Iterator<Integer> {
    private final CharSequence seq;
    private int index;

    public CodePointIterator(CharSequence seq) {
        this(seq, 0);
    }

    public CodePointIterator(CharSequence seq, int index) {
        if (seq == null) {
            throw new NullPointerException("seq is null");
        }
        this.seq = seq;
        this.setIndex(index);
    }

    public void setIndex(int index) {
        if (index < 0 || index > this.seq.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.index = index;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.seq.length();
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public int index() {
        return this.index;
    }

    @Override
    public Integer next() {
        int codePoint = Character.codePointAt(this.seq, this.index);
        this.index += Character.charCount(codePoint);
        return codePoint;
    }

    public Integer previous() {
        int codePoint = Character.codePointBefore(this.seq, this.index);
        this.index -= Character.charCount(codePoint);
        return codePoint;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("unsupported");
    }

    public static Iterable<Integer> each(final CharSequence seq) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new CodePointIterator(seq);
            }
        };
    }
}

