/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.handlers;

import jp.sourceforge.moreemacs.handlers.TextEditorExecution;
import jp.sourceforge.moreemacs.utils.CodePointIterator;
import jp.sourceforge.moreemacs.utils.DocumentCharSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public final class DeleteHorizontalSpaceExecution
extends TextEditorExecution {
    @Override
    public void execute() throws BadLocationException {
        if (!this.textEditor.isEditable()) {
            return;
        }
        int current = this.cursor.offset();
        int start = this.skipBackwardSpaces(this.doc, current);
        int end = this.skipForwardSpaces(this.doc, current);
        this.doc.replace(start, end - start, "");
    }

    int skipBackwardSpaces(IDocument doc, int offset) throws BadLocationException {
        IRegion line = doc.getLineInformationOfOffset(offset);
        DocumentCharSequence seq = new DocumentCharSequence(doc, line.getOffset(), offset - line.getOffset());
        int result = offset;
        CodePointIterator itr = new CodePointIterator(seq, seq.length());
        while (itr.hasPrevious()) {
            int codePoint = itr.previous();
            if (!Character.isWhitespace(codePoint)) break;
            result = line.getOffset() + itr.index();
        }
        return result;
    }

    int skipForwardSpaces(IDocument doc, int offset) throws BadLocationException {
        IRegion line = doc.getLineInformationOfOffset(offset);
        DocumentCharSequence seq = new DocumentCharSequence(doc, offset, line.getOffset() + line.getLength() - offset);
        int result = offset;
        CodePointIterator itr = new CodePointIterator(seq);
        while (itr.hasNext()) {
            int codePoint = itr.next();
            if (!Character.isWhitespace(codePoint)) break;
            result = offset + itr.index();
        }
        return result;
    }
}

