/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.sql;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DriverDataSource
implements DataSource,
Serializable {
    private String driver = null;
    private String url = null;
    private Properties info = null;
    private boolean autoCommit = false;
    private boolean readOnly = false;
    static /* synthetic */ Class class$0;

    public DriverDataSource(String driver, String url, Properties info) {
        this.url = url;
        this.driver = driver;
        this.info = info;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            cl.loadClass(driver).newInstance();
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.morpho.webapp.sql.DriverDataSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger log = Logger.getLogger(clazz.getName());
            log.log(Level.FINEST, e.getMessage(), e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public DriverDataSource(String driver, String url) {
        this(driver, url, null);
    }

    private Connection initConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(this.autoCommit);
        conn.setReadOnly(this.readOnly);
        return conn;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.info == null) {
            return this.initConnection(DriverManager.getConnection(this.url));
        }
        return this.initConnection(DriverManager.getConnection(this.url, this.info));
    }

    public synchronized Connection getConnection(String username, String password) throws SQLException {
        return this.initConnection(DriverManager.getConnection(this.url, username, password));
    }

    public synchronized int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public synchronized PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public synchronized void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    public synchronized void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    public synchronized boolean isAutoCommit() {
        return this.autoCommit;
    }

    public synchronized void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

