/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import jp.morpho.webapp.sql.PersistenceConnection;

public class PersistenceConnectionHolder
implements PooledConnection {
    private List eventListenerList = new ArrayList();
    private Connection conn;
    private Date closedTime;

    public PersistenceConnectionHolder(Connection conn) {
        this.conn = conn;
        this.closedTime = new Date();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.eventListenerList.remove(listener);
        this.eventListenerList.add(listener);
    }

    public void close() throws SQLException {
        this.conn.close();
    }

    public Connection getConnection() throws SQLException {
        return new PersistenceConnection(this, this.conn);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListenerList.remove(listener);
    }

    public void fireConnectionClosed() {
        this.closedTime = new Date();
        ConnectionEventListener[] liteners = this.getConnectionEventListeners();
        if (liteners == null) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(this);
        int i = 0;
        while (i < liteners.length) {
            liteners[i].connectionClosed(event);
            ++i;
        }
    }

    protected ConnectionEventListener[] getConnectionEventListeners() {
        if (this.eventListenerList == null) {
            return null;
        }
        ConnectionEventListener[] liteners = new ConnectionEventListener[this.eventListenerList.size()];
        return this.eventListenerList.toArray(liteners);
    }

    public synchronized long getIdleTime() {
        return new Date().getTime() - this.closedTime.getTime();
    }
}

